/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.model.ClockTime;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import javax.faces.event.ValueChangeEvent;

public class Time
extends WebuiInput
implements NamingContainer,
ComplexComponent {
    public static final String HOUR_FACET = "hour";
    public static final String MINUTES_FACET = "minutes";
    private static final String TIME_SUBMITTED = "com.sun.webui.jsf.TimeSubmitted";
    private static final boolean DEBUG = false;
    private String hourTooltipKey;
    private String minutesTooltipKey;
    private boolean disabled = false;
    private boolean disabled_set = false;
    private boolean readOnly = false;
    private boolean readOnly_set = false;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndex_set = false;
    private TimeZone timeZone = null;
    private boolean visible = false;
    private boolean visible_set = false;

    public Time() {
        this.setRendererType("com.sun.webui.jsf.Time");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Time";
    }

    public DropDown getHourMenu() {
        return this.getMenu(HOUR_FACET, this.getHourItems());
    }

    public DropDown getMinutesMenu() {
        return this.getMenu(MINUTES_FACET, this.getMinuteItems());
    }

    private DropDown getMenu(String facet, Option[] options) {
        int tindex;
        DropDown menu = (DropDown)ComponentUtilities.getPrivateFacet(this, facet, true);
        if (menu == null) {
            menu = new DropDown();
            menu.setId(ComponentUtilities.createPrivateFacetId(this, facet));
            menu.setItems(options);
            menu.setConverter(new IntegerConverter());
            ComponentUtilities.putPrivateFacet(this, facet, menu);
        }
        if ((tindex = this.getTabIndex()) > 0) {
            menu.setTabIndex(tindex);
        }
        menu.setDisabled(this.isDisabled());
        menu.setRequired(this.isRequired());
        return menu;
    }

    private Option[] getHourItems() {
        int counter;
        Option[] hours = new Option[25];
        hours[0] = new Option(new Integer(-1), " ");
        for (counter = 0; counter < 10; ++counter) {
            hours[counter + 1] = new Option(new Integer(counter), "0" + counter);
        }
        while (counter < 24) {
            hours[counter + 1] = new Option(new Integer(counter), String.valueOf(counter));
            ++counter;
        }
        return hours;
    }

    private Option[] getMinuteItems() {
        Option[] minutes = new Option[13];
        minutes[0] = new Option(new Integer(-1), " ");
        minutes[1] = new Option(new Integer(0), "00");
        minutes[2] = new Option(new Integer(5), "05");
        for (int i = 2; i < 12; ++i) {
            minutes[i + 1] = new Option(new Integer(5 * i), String.valueOf(5 * i));
        }
        return minutes;
    }

    public String getOffset() {
        Calendar calendar = this.getCalendar();
        TimeZone timeZone = calendar.getTimeZone();
        StringBuffer gmtTimeZone = new StringBuffer(8);
        int value = calendar.get(15) + calendar.get(16);
        if (value < 0) {
            gmtTimeZone.append('-');
            value = -value;
        } else {
            gmtTimeZone.append('+');
        }
        int num = value / 3600000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num).append(":");
        num = value % 3600000 / 60000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num);
        return gmtTimeZone.toString();
    }

    public Calendar getCalendar() {
        TimeZone timeZone;
        Calendar calendar = null;
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        if (locale == null) {
            locale = locale.getDefault();
        }
        calendar = (timeZone = this.getTimeZone()) == null ? Calendar.getInstance(locale) : Calendar.getInstance(timeZone, locale);
        return calendar;
    }

    public String getHourTooltipKey() {
        return this.hourTooltipKey;
    }

    public void setHourTooltipKey(String hourTooltipKey) {
        this.hourTooltipKey = hourTooltipKey;
    }

    public String getMinutesTooltipKey() {
        return this.minutesTooltipKey;
    }

    public void setMinutesTooltipKey(String minutesTooltipKey) {
        this.minutesTooltipKey = minutesTooltipKey;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        ComponentUtilities.getPrivateFacet(this, HOUR_FACET, false).processDecodes(context);
        ComponentUtilities.getPrivateFacet(this, MINUTES_FACET, false).processDecodes(context);
        this.setSubmittedValue(TIME_SUBMITTED);
        if (this.isImmediate()) {
            this.runValidation(context);
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object hourValue = ((EditableValueHolder)((Object)ComponentUtilities.getPrivateFacet(this, HOUR_FACET, false))).getValue();
        Object minuteValue = ((EditableValueHolder)((Object)ComponentUtilities.getPrivateFacet(this, MINUTES_FACET, false))).getValue();
        ClockTime newValue = null;
        try {
            newValue = this.createClockTime(hourValue, minuteValue, context);
        }
        catch (ConverterException ce) {
            FacesMessage message = ce.getFacesMessage();
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            context.renderResponse();
        }
        catch (Exception ex) {
            FacesMessage message = new FacesMessage("Invalid input");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            context.renderResponse();
        }
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent(new ValueChangeEvent(this, previous, newValue));
            }
        }
    }

    private void runValidation(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClockTime createClockTime(Object hourObject, Object minuteObject, FacesContext context) {
        String messageKey = null;
        ClockTime time = null;
        if (hourObject instanceof Integer && minuteObject instanceof Integer) {
            int hour = (Integer)hourObject;
            int minute = (Integer)minuteObject;
            if (hour == -1 && minute == -1) {
                if (!this.isRequired()) return null;
                messageKey = "Time.required";
            } else if (hour == -1) {
                messageKey = "Time.enterHour";
            } else if (minute == -1) {
                messageKey = "Time.enterMinute";
            } else {
                time = new ClockTime();
                try {
                    time.setHour(new Integer(hour));
                    time.setMinute(new Integer(minute));
                }
                catch (Exception ex) {
                    messageKey = "Time.invalidData";
                }
            }
        } else {
            if (!this.isRequired()) return null;
            messageKey = "Time.required";
        }
        if (messageKey == null) return time;
        String message = ThemeUtilities.getTheme(context).getMessage(messageKey);
        throw new ConverterException(new FacesMessage(message));
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        String rendererType;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        DropDown hourMenu = this.getHourMenu();
        DropDown minuteMenu = this.getMinutesMenu();
        if (this.getSubmittedValue() == null) {
            Object object = this.getValue();
            ClockTime value = null;
            if (object != null && object instanceof ClockTime) {
                value = (ClockTime)object;
            }
            if (value != null) {
                hourMenu.setValue(value.getHour());
            } else {
                hourMenu.setValue(new Integer(-1));
            }
            if (value != null) {
                minuteMenu.setValue(value.getMinute());
            } else {
                minuteMenu.setValue(new Integer(-1));
            }
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String key = this.getHourTooltipKey();
        if (key != null) {
            hourMenu.setToolTip(theme.getMessage(key));
        }
        if ((key = this.getMinutesTooltipKey()) != null) {
            minuteMenu.setToolTip(theme.getMessage(key));
        }
        if ((rendererType = this.getRendererType()) != null) {
            this.getRenderer(context).encodeEnd(context, this);
        }
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public String getLabeledElementId(FacesContext context) {
        DropDown comp = this.getHourMenu();
        if (comp == null) {
            return null;
        }
        if (comp instanceof ComplexComponent) {
            return ((ComplexComponent)comp).getLabeledElementId(context);
        }
        return ((UIComponent)comp).getClientId(context);
    }

    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public UIComponent getIndicatorComponent(FacesContext context, Label label) {
        return this;
    }

    public boolean isDisabled() {
        if (this.disabled_set) {
            return this.disabled;
        }
        ValueExpression _vb = this.getValueExpression("disabled");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.disabled_set = true;
    }

    public boolean isReadOnly() {
        if (this.readOnly_set) {
            return this.readOnly;
        }
        ValueExpression _vb = this.getValueExpression("readOnly");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.readOnly_set = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression _vb = this.getValueExpression("style");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression _vb = this.getValueExpression("styleClass");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public int getTabIndex() {
        if (this.tabIndex_set) {
            return this.tabIndex;
        }
        ValueExpression _vb = this.getValueExpression("tabIndex");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
        this.tabIndex_set = true;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        ValueExpression _vb = this.getValueExpression("timeZone");
        if (_vb != null) {
            return (TimeZone)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.disabled = (Boolean)_values[1];
        this.disabled_set = (Boolean)_values[2];
        this.readOnly = (Boolean)_values[3];
        this.readOnly_set = (Boolean)_values[4];
        this.style = (String)_values[5];
        this.styleClass = (String)_values[6];
        this.tabIndex = (Integer)_values[7];
        this.tabIndex_set = (Boolean)_values[8];
        this.timeZone = (TimeZone)_values[9];
        this.visible = (Boolean)_values[10];
        this.visible_set = (Boolean)_values[11];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabled_set ? Boolean.TRUE : Boolean.FALSE, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnly_set ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, new Integer(this.tabIndex), this.tabIndex_set ? Boolean.TRUE : Boolean.FALSE, this.timeZone, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

