/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.ajax;

import com.sun.webui.jsf.component.ProgressBar;
import com.sun.webui.jsf.util.ComponentUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgressBarRenderer
extends com.sun.webui.jsf.renderkit.widget.ProgressBarRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String id = component.getClientId(context);
        Map<String, String> params = context.getExternalContext().getRequestParameterMap();
        String hiddenFieldId = id + "_controlType";
        String valueObject = params.get(hiddenFieldId);
        String value = null;
        if (valueObject != null) {
            value = valueObject.trim();
            ProgressBar progressBar = (ProgressBar)component;
            if (ProgressBar.TASK_STOPPED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_STOPPED);
            } else if (ProgressBar.TASK_PAUSED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_PAUSED);
            } else if (ProgressBar.TASK_RESUMED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_RESUMED);
            } else if (ProgressBar.TASK_CANCELED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_CANCELED);
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (ComponentUtilities.isAjaxRequest(context, component, "refresh")) {
            super.encodeChildren(context, component);
        }
        if (!ComponentUtilities.isAjaxRequest(context, component, "progress")) {
            return;
        }
        try {
            UIComponent bottomTextFacet;
            ProgressBar progressBar = (ProgressBar)component;
            String status = progressBar.getStatus();
            String topText = progressBar.getDescription();
            String logMessage = progressBar.getLogMessage();
            String failedStateText = progressBar.getFailedStateText();
            UIComponent topTextFacet = component.getFacet("progressTextTop");
            if (topTextFacet != null) {
                topText = null;
            }
            if ((bottomTextFacet = component.getFacet("progressTextBottom")) != null) {
                status = null;
            }
            JSONObject json = new JSONObject();
            json.put("id", progressBar.getClientId(context));
            json.put("taskState", progressBar.getTaskState());
            json.put("progress", String.valueOf(progressBar.getProgress()));
            json.put("status", status);
            json.put("topText", topText);
            json.put("logMessage", logMessage);
            json.put("failedStateText", failedStateText);
            json.write(context.getResponseWriter());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

