/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.FileChooser;
import com.sun.webui.jsf.component.HelpInline;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.json.JSONException;
import org.json.JSONObject;

public class FileChooserRenderer
extends AbstractRenderer {
    private static final boolean DEBUG = false;
    public static final String HYFEN = "-";

    public void decode(FacesContext context, UIComponent component) {
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        if (!(component instanceof FileChooser)) {
            throw new FacesException("FileChooserRenderer can only render FileChooser components.");
        }
        FileChooser chooser = (FileChooser)component;
        if (chooser.getSubmittedValue() == null) {
            this.decodeSubmittedValue(context, chooser);
        }
    }

    private void decodeSubmittedValue(FacesContext context, FileChooser chooser) {
        String selectionsId = chooser.getClientId(context) + ":" + chooser.getId() + "_selections";
        Map<String, String[]> requestParameters = context.getExternalContext().getRequestParameterValuesMap();
        String[] selections = requestParameters.get(selectionsId);
        if (selections != null) {
            chooser.setSubmittedValue(selections);
        } else {
            chooser.setSubmittedValue(null);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (!(component instanceof FileChooser)) {
            String msg = "Can only convert values for FileChooser component.";
            throw new ConverterException(msg);
        }
        return ((FileChooser)component).getConvertedValue(context, (FileChooser)component, submittedValue);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        try {
            FileChooser chooser = null;
            if (!(component instanceof FileChooser)) {
                String message = "Component " + component.toString() + " has been associated with a FileChooser. " + " This renderer can only be used by components " + " that extend com.sun.webui.jsf.component.FileChooser.";
                throw new FacesException(message);
            }
            chooser = (FileChooser)component;
            if (!chooser.isRendered()) {
                return;
            }
            Theme theme = ThemeUtilities.getTheme(context);
            writer.startElement("div", component);
            writer.writeAttribute("id", component.getClientId(context), null);
            String style = chooser.getStyle();
            if (style != null) {
                writer.writeAttribute("style", style, null);
            }
            RenderingUtilities.renderStyleClass(context, writer, component, null);
            writer.writeText("\n", null);
            this.renderChooserTitle(context, chooser, writer, theme);
            writer.startElement("div", component);
            writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_CONMGN"), null);
            writer.writeText("\n", null);
            writer.startElement("table", chooser);
            writer.writeAttribute("border", "0", "border");
            writer.writeAttribute("cellpadding", "0", "cellpadding");
            writer.writeAttribute("cellspacing", "0", "cellspacing");
            writer.writeAttribute("title", " ", "title");
            writer.writeText("\n", null);
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            this.renderServerName(context, chooser, writer, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            this.renderLookinTextField(context, chooser, writer, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            this.renderFilterField(context, chooser, writer, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            String helpMessage = theme.getMessage("filechooser.enterKeyHelp");
            this.renderInlineHelp(context, chooser, writer, helpMessage, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText("\n", null);
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            writer.startElement("hr", chooser);
            writer.writeAttribute("color", "#98a0a5", null);
            writer.writeAttribute("size", "1", null);
            writer.endElement("hr");
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText("\n", null);
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            this.renderButtons(context, chooser, writer, theme);
            this.renderSortFields(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText("\n", null);
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            writer.startElement("div", chooser);
            writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_LST_HDR"), null);
            writer.startElement("div", chooser);
            writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_NAME_HDR"), null);
            writer.write(theme.getMessage("filechooser.name_column_header"));
            writer.endElement("div");
            writer.writeText("\n", null);
            writer.startElement("div", chooser);
            writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_SIZE_HDR"), null);
            writer.write(theme.getMessage("filechooser.size_column_header"));
            writer.endElement("div");
            writer.writeText("\n", null);
            writer.startElement("div", chooser);
            writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_DATE_TIME_HDR"), null);
            writer.write(theme.getMessage("filechooser.date_time_column_header"));
            writer.endElement("div");
            writer.writeText("\n", null);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText("\n", null);
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            this.renderFileList(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            this.renderMultiSelectHelp(context, chooser, writer, theme);
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            writer.writeText("\n", null);
            this.renderSelectText(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText("\n", null);
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            writer.startElement("hr", chooser);
            writer.writeAttribute("color", "#98a0a5", null);
            writer.writeAttribute("size", "1", null);
            writer.endElement("hr");
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText("\n", null);
            writer.endElement("table");
            writer.endElement("div");
            writer.endElement("div");
            String hiddenID = chooser.getClientId(context) + ":" + chooser.getId() + FileChooser.FILECHOOSER_HIDDENFIELD_ID;
            writer.startElement("input", chooser);
            writer.writeAttribute("id", hiddenID, null);
            writer.writeAttribute("name", hiddenID, null);
            writer.writeAttribute("type", "hidden", null);
            writer.writeAttribute("value", "NOACTION", null);
            writer.endElement("input");
            Button hiddenButton = (Button)chooser.getHiddenFCButton();
            RenderingUtilities.renderComponent(hiddenButton, context);
            this.renderJavaScript(chooser, context, writer, theme);
        }
        catch (Exception e) {
            throw new FacesException("Filechooser throws exception whilerendering: " + e.getMessage());
        }
    }

    private void renderSelectedSelections(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("select", chooser);
        String id = chooser.getClientId(context) + ":" + chooser.getId() + "_selections";
        writer.writeAttribute("id", id, null);
        writer.writeAttribute("name", id, null);
        writer.writeAttribute("style", "{display:none}", null);
        writer.writeAttribute("multiple", "multiple", null);
        writer.endElement("select");
    }

    private void renderRoots(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        String[] roots = chooser.getRoots();
        writer.startElement("select", chooser);
        String id = chooser.getClientId(context) + ":" + chooser.getId() + "_roots";
        writer.writeAttribute("id", id, null);
        writer.writeAttribute("name", id, null);
        writer.writeAttribute("style", "{display:none}", null);
        writer.writeAttribute("multiple", "multiple", null);
        for (int i = 0; i < roots.length; ++i) {
            writer.startElement("option", chooser);
            writer.writeAttribute("value", roots[i], null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void renderServerName(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        UIOutput uio = (UIOutput)chooser.getServerNameText();
        Label label = (Label)chooser.getServerNameLabel();
        if (!uio.isRendered() || !label.isRendered()) {
            return;
        }
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_SRV_DIV"), null);
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_LEV2_DIV"), null);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("div");
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(uio, context);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderChooserTitle(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        StaticText title = (StaticText)chooser.getFileChooserTitle();
        if (!title.isRendered()) {
            return;
        }
        writer.startElement("table", chooser);
        writer.writeAttribute("width", "100%", "width");
        writer.writeAttribute("border", "0", "border");
        writer.writeAttribute("cellpadding", "0", "cellpadding");
        writer.writeAttribute("cellspacing", "0", "cellspacing");
        writer.writeAttribute("title", "", "title");
        writer.startElement("tr", chooser);
        writer.writeAttribute("valign", "bottom", "valign");
        writer.startElement("td", chooser);
        writer.writeAttribute("valign", "bottom", "valign");
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("TITLE_TEXT_DIV"), "class");
        writer.startElement("h1", chooser);
        writer.writeAttribute("class", theme.getStyleClass("TITLE_TEXT"), "class");
        RenderingUtilities.renderComponent(title, context);
        writer.endElement("h1");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.writeText("\n", null);
    }

    protected void renderInlineHelp(FacesContext context, FileChooser chooser, ResponseWriter writer, String messageKey, Theme theme) throws Exception {
        UIComponent help = chooser.getEnterInlineHelp();
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_FLT_HLP_DIV"), null);
        if (help.isRendered()) {
            RenderingUtilities.renderComponent(help, context);
        }
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderLookinTextField(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        TextField lookinField = (TextField)chooser.getLookInTextField();
        if (!lookinField.isRendered()) {
            return;
        }
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_LOOK_IN_DIV"), null);
        writer.writeText("\n", null);
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_LEV2_DIV"), null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(chooser.getLookInLabel(), context);
        writer.endElement("div");
        writer.writeText("\n", null);
        this.setEnterKeyPressHandler(context, chooser, lookinField);
        RenderingUtilities.renderComponent(lookinField, context);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderFilterField(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        TextField filterOnField = (TextField)chooser.getFilterTextField();
        if (!filterOnField.isRendered()) {
            return;
        }
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_FLT_DIV"), null);
        writer.writeText("\n", null);
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_LEV2_DIV"), null);
        RenderingUtilities.renderComponent(chooser.getFilterLabel(), context);
        writer.endElement("div");
        writer.writeText("\n", null);
        this.setEnterKeyPressHandler(context, chooser, filterOnField);
        RenderingUtilities.renderComponent(filterOnField, context);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderSortFields(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_SORT_BY_DIV"), null);
        writer.writeText("\n", null);
        Label sortLabel = (Label)chooser.getSortComponentLabel();
        DropDown jdd = (DropDown)chooser.getSortComponent();
        if (!jdd.isRendered()) {
            return;
        }
        if (sortLabel.isRendered()) {
            RenderingUtilities.renderComponent(sortLabel, context);
        }
        RenderingUtilities.renderComponent(jdd, context);
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderFileList(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_LST_DIV"), null);
        UIComponent fileList = chooser.getListComponent();
        this.createJavaScriptForFileList(chooser, context, fileList);
        this.setEnterKeyPressHandler(context, chooser, fileList);
        RenderingUtilities.renderComponent(fileList, context);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    protected void renderMultiSelectHelp(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        HelpInline help = (HelpInline)chooser.getMultiSelectHelp();
        if (help != null && help.isRendered()) {
            writer.startElement("tr", chooser);
            writer.startElement("td", chooser);
            writer.startElement("div", chooser);
            writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_MULT_HLP_DIV"), null);
            RenderingUtilities.renderComponent(help, context);
            writer.endElement("div");
            this.renderClearDiv(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected void renderButtons(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_BTN_GRP_DIV"), null);
        this.renderUpLevelButton(context, chooser, writer, theme);
        this.renderOpenFolderButton(context, chooser, writer, theme);
        writer.endElement("div");
    }

    protected void renderUpLevelButton(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.writeText("\n", null);
        Button child = (Button)chooser.getUpLevelButton(false);
        if (!child.isRendered()) {
            return;
        }
        StringBuffer jsBuffer = new StringBuffer(256);
        jsBuffer.append(JavaScriptUtilities.getDomNode(context, chooser));
        jsBuffer.append(".moveUpButtonClicked();");
        child.setOnClick(jsBuffer.toString());
        RenderingUtilities.renderComponent(child, context);
        writer.writeText("\n", null);
    }

    protected void renderOpenFolderButton(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.writeText("\n", null);
        Button child = (Button)chooser.getOpenFolderButton();
        if (!child.isRendered()) {
            return;
        }
        StringBuffer jsBuffer = new StringBuffer(256);
        jsBuffer.append(JavaScriptUtilities.getDomNode(context, chooser));
        jsBuffer.append(".openFolderClicked();");
        child.setOnClick(jsBuffer.toString());
        RenderingUtilities.renderComponent(child, context);
        writer.writeText("\n", null);
    }

    protected void renderSelectText(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        TextField selectedTextField = (TextField)chooser.getSelectedTextField();
        if (!selectedTextField.isRendered()) {
            return;
        }
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_SEL_FILE_DIV"), null);
        writer.writeText("\n", null);
        writer.startElement("div", chooser);
        writer.writeAttribute("class", theme.getStyleClass("FILECHOOSER_SEL_FILE_LEV2_DIV"), null);
        RenderingUtilities.renderComponent(chooser.getSelectLabel(), context);
        writer.endElement("div");
        this.setEnterKeyPressHandler(context, chooser, selectedTextField);
        RenderingUtilities.renderComponent(selectedTextField, context);
        writer.endElement("div");
        this.renderClearDiv(context, chooser, writer, theme);
    }

    private void renderJavaScript(FileChooser chooser, FacesContext context, ResponseWriter writer, Theme theme) throws IOException {
        String chooserType = null;
        chooserType = chooser.isFolderChooser() ? "folderChooser" : (chooser.isFileAndFolderChooser() ? "fileAndFolderChooser" : "fileChooser");
        String esc = chooser.getEscapeChar();
        if (esc.equals("\\")) {
            esc = "\\\\";
        }
        String parentDir = chooser.getParentFolder();
        String currentFolder = chooser.getCurrentFolder();
        if (parentDir == null) {
            parentDir = currentFolder;
        }
        String sep = chooser.getSeparatorString();
        if (parentDir == null) {
            parentDir = "";
        } else if (sep.equals("\\")) {
            sep = sep + sep;
            parentDir = parentDir.replaceAll(sep, sep + sep);
        }
        sep = chooser.getSeparatorString();
        if (currentFolder == null) {
            currentFolder = "";
        } else if (sep.equals("\\")) {
            sep = sep + sep;
            currentFolder = currentFolder.replaceAll(sep, sep + sep);
        }
        try {
            String id = chooser.getClientId(context);
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            json.put("id", id).put("chooserType", chooserType).put("parentFolder", parentDir).put("separatorChar", sep).put("escapeChar", esc).put("delimiter", chooser.getDelimiterChar()).put("currentFolder", currentFolder);
            buff.append(JavaScriptUtilities.getModule("fileChooser")).append("\n").append(JavaScriptUtilities.getModuleName("fileChooser._init")).append("(").append(JSONUtilities.getString(json)).append(");");
            JavaScriptUtilities.renderJavaScript(chooser, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void createJavaScriptForFileList(FileChooser chooser, FacesContext context, UIComponent fileList) {
        String jsObject = JavaScriptUtilities.getDomNode(context, chooser);
        StringBuffer dblClickBuffer = new StringBuffer(256);
        dblClickBuffer.append(jsObject);
        dblClickBuffer.append(".handleDblClick();");
        fileList.getAttributes().put("onDblClick", dblClickBuffer.toString());
        StringBuffer jsBuffer = new StringBuffer(256);
        jsBuffer.append(jsObject);
        jsBuffer.append(".handleOnChange();");
        fileList.getAttributes().put("onChange", jsBuffer.toString());
    }

    private void setEnterKeyPressHandler(FacesContext context, FileChooser chooser, UIComponent child) {
        StringBuffer scriptBuffer = new StringBuffer();
        scriptBuffer.append("return ");
        scriptBuffer.append(JavaScriptUtilities.getDomNode(context, chooser));
        scriptBuffer.append(".enterKeyPressed(this);");
        String js = this.getReturnKeyJavascriptWrapper(scriptBuffer.toString());
        scriptBuffer.setLength(0);
        scriptBuffer.append(js);
        child.getAttributes().put("onKeyPress", scriptBuffer.toString());
    }

    private void renderEmptyLine(FacesContext context, FileChooser chooser, ResponseWriter writer, String colSpan, int wd, int ht, Theme theme) {
        try {
            writer.startElement("tr", chooser);
            this.renderDotImage(writer, chooser, context, colSpan, wd, ht, theme);
            writer.endElement("tr");
            writer.writeText("\n", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderClearDiv(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) {
        try {
            writer.startElement("div", chooser);
            writer.writeAttribute("class", theme.getStyleClass("CLEAR"), null);
            writer.endElement("div");
            writer.writeText("\n", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderDotImage(ResponseWriter writer, FileChooser chooser, FacesContext context, String colSpan, int wd, int ht, Theme theme) {
        try {
            writer.startElement("td", chooser);
            if (colSpan != null) {
                writer.writeAttribute("colspan", colSpan, null);
            }
            Icon dot = ThemeUtilities.getIcon(theme, "DOT");
            dot.setWidth(wd);
            dot.setHeight(ht);
            dot.setBorder(0);
            dot.setAlt("");
            RenderingUtilities.renderComponent(dot, context);
            writer.endElement("td");
            writer.writeText("\n", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void log(String s) {
        if (LogUtil.fineEnabled(FileChooserRenderer.class)) {
            LogUtil.fine(FileChooserRenderer.class, s);
        }
    }

    private String getReturnKeyJavascriptWrapper(String body) {
        ClientSniffer cs = ClientSniffer.getInstance(this.getFacesContext());
        String keyCode = cs.isNav() ? "event.which" : "event.keyCode";
        StringBuffer buff = new StringBuffer(128).append("if (event && ").append(keyCode).append("==13) {");
        if (cs.isNav6() || cs.isNav70()) {
            buff.append("event.cancelBubble = true;");
        }
        buff.append(body).append("} else { return true; }");
        return buff.toString();
    }
}

