/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.OrderableList;
import com.sun.webui.jsf.renderkit.html.ListRendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderableListRenderer
extends ListRendererBase {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof OrderableList)) {
            String message = "Component " + component.toString() + " has been associated with an OrderableListRenderer. " + " This renderer can only be used by components " + " that extend com.sun.webui.jsf.component.Selector.";
            throw new FacesException(message);
        }
        this.renderListComponent(context, (OrderableList)component, this.getStyles(component, context));
    }

    public void decode(FacesContext context, UIComponent component) {
        String id = component.getClientId(context).concat("_list_value");
        super.decode(context, component, id);
    }

    private void renderListComponent(FacesContext context, OrderableList component, String[] styles) throws IOException {
        if (component.isReadOnly()) {
            UIComponent label = component.getHeaderComponent();
            super.renderReadOnlyList(component, label, context, styles[15]);
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        this.renderOpenEncloser(component, context, "div", styles[15]);
        UIComponent headerComponent = component.getHeaderComponent();
        if (headerComponent != null) {
            if (!component.isLabelOnTop()) {
                writer.writeText("\n", null);
                writer.startElement("span", component);
                writer.writeAttribute("class", styles[10], null);
                writer.writeText("\n", null);
                RenderingUtilities.renderComponent(headerComponent, context);
                writer.writeText("\n", null);
                writer.endElement("span");
                writer.writeText("\n", null);
            } else {
                RenderingUtilities.renderComponent(headerComponent, context);
                writer.startElement("br", component);
                writer.endElement("br");
            }
        }
        this.renderColumnTop(component, writer, styles[10]);
        String id = component.getClientId(context);
        if (component instanceof ComplexComponent) {
            id = component.getLabeledElementId(context);
        }
        this.renderList(component, id, context, styles);
        this.renderColumnBottom(writer);
        this.renderColumnTop(component, writer, styles[10]);
        this.renderButtons(component, context, writer, styles);
        this.renderColumnBottom(writer);
        writer.startElement("div", component);
        writer.writeAttribute("class", styles[11], null);
        writer.endElement("div");
        UIComponent footerComponent = component.getFacet("footer");
        if (footerComponent != null) {
            writer.startElement("div", component);
            writer.writeText("\n", null);
            RenderingUtilities.renderComponent(footerComponent, context);
            writer.writeText("\n", null);
            writer.endElement("div");
            writer.writeText("\n", null);
        }
        String jsID = component.getClientId(context);
        this.renderHiddenValue(component, context, writer, styles[15]);
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
        this.renderJavaScript(component, context, writer, styles);
    }

    private void renderJavaScript(UIComponent component, FacesContext context, ResponseWriter writer, String[] styles) throws IOException {
        try {
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            json.put("id", component.getClientId(context)).put("moveMessage", styles[14]);
            buff.append(JavaScriptUtilities.getModule("orderableList")).append("\n").append(JavaScriptUtilities.getModuleName("orderableList._init")).append("(").append(JSONUtilities.getString(json)).append(");");
            JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void renderColumnTop(OrderableList component, ResponseWriter writer, String style) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("class", style, null);
        writer.writeText("\n", null);
    }

    private void renderColumnBottom(ResponseWriter writer) throws IOException {
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    private void renderButtons(OrderableList component, FacesContext context, ResponseWriter writer, String[] styles) throws IOException {
        writer.writeText("\n", null);
        writer.startElement("div", component);
        String style = "padding-left:10;padding-right:10";
        writer.writeAttribute("style", style, null);
        writer.writeText("\n", null);
        writer.startElement("table", component);
        writer.writeAttribute("class", styles[12], null);
        writer.writeText("\n", null);
        writer.startElement("tr", component);
        writer.writeText("\n", null);
        writer.startElement("td", component);
        writer.writeAttribute("align", "center", null);
        writer.writeAttribute("width", "125", null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(component.getMoveUpButtonComponent(context), context);
        writer.writeText("\n", null);
        this.renderButton(component, component.getMoveDownButtonComponent(context), styles[9], writer, context);
        if (component.isMoveTopBottom()) {
            this.renderButton(component, component.getMoveTopButtonComponent(context), styles[8], writer, context);
            this.renderButton(component, component.getMoveBottomButtonComponent(context), styles[9], writer, context);
        }
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
        writer.endElement("table");
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    private void renderButton(OrderableList list, UIComponent comp, String style, ResponseWriter writer, FacesContext context) throws IOException {
        if (comp == null) {
            return;
        }
        writer.startElement("div", list);
        writer.writeAttribute("class", style, null);
        writer.writeText("\n", null);
        RenderingUtilities.renderComponent(comp, context);
        writer.writeText("\n", null);
        writer.endElement("div");
        writer.writeText("\n", null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    private void addComponentSingleRow(OrderableList list, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", list);
        writer.writeText("\n", null);
        writer.startElement("td", list);
        RenderingUtilities.renderComponent(component, context);
        writer.writeText("\n", null);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.endElement("tr");
        writer.writeText("\n", null);
    }

    private String[] getStyles(UIComponent component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        StringBuffer buff = new StringBuffer(256);
        buff.append(JavaScriptUtilities.getDomNode(context, component)).append(".onChange(); ").append("return false;");
        String[] styles = new String[]{buff.toString(), theme.getStyleClass("LIST"), theme.getStyleClass("LIST_DISABLED"), theme.getStyleClass("LIST_OPTION"), theme.getStyleClass("LIST_OPTION_DISABLED"), theme.getStyleClass("LIST_OPTION_SELECTED"), theme.getStyleClass("LIST_OPTION_GROUP"), theme.getStyleClass("LIST_OPTION_SEPARATOR"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_BETWEEN"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_WITHIN"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_ALIGN"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_LAST"), theme.getStyleClass("ADDREMOVE_BUTTON_TABLE"), null, theme.getMessage("OrderableList.moveMessage"), theme.getStyleClass("HIDDEN")};
        return styles;
    }
}

