/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class StaticTextRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"onClick", "onDblClick", "onMouseUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver"};

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.writeText("\n", null);
        writer.startElement("span", component);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        StaticText st = (StaticText)component;
        this.addCoreAttributes(context, component, writer, null);
        StaticTextRenderer.addStringAttributes(context, component, writer, stringAttributes);
        if (st.getToolTip() != null) {
            writer.writeAttribute("title", st.getToolTip(), null);
        }
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        StaticText staticText = (StaticText)component;
        String currentValue = ConversionUtilities.convertValueToString(component, staticText.getText());
        String style = staticText.getStyle();
        String styleClass = staticText.getStyleClass();
        if (currentValue != null) {
            ArrayList<Object> parameterList = new ArrayList<Object>();
            for (UIComponent kid : component.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                parameterList.add(((UIParameter)kid).getValue());
            }
            String message = null;
            message = parameterList.size() > 0 ? MessageFormat.format(currentValue, parameterList.toArray(new Object[parameterList.size()])) : currentValue;
            if (message != null) {
                if (staticText.isEscape()) {
                    writer.writeText(message, "value");
                } else {
                    writer.write(message);
                }
            }
        }
        writer.endElement("span");
    }
}

