/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TablePanels;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TablePanelsRenderer
extends Renderer {
    private static final String[] stringAttributes = new String[]{"abbr", "align", "axis", "bgColor", "char", "charOff", "dir", "headers", "height", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign", "width"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TablePanels panel = (TablePanels)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, panel, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TablePanels panel = (TablePanels)component;
        ResponseWriter writer = context.getResponseWriter();
        if (panel.isFilterPanel()) {
            this.renderFilterPanel(context, panel, writer);
        }
        if (panel.isPreferencesPanel()) {
            this.renderPreferencesPanel(context, panel, writer);
        }
        this.renderSortPanel(context, panel, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TablePanels panel = (TablePanels)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagEnd(context, panel, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderFilterPanel(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderFilterPanel", "Cannot render filter panel, TablePanels is null");
            return;
        }
        Table table = component.getTableAncestor();
        UIComponent uIComponent = facet = table != null ? table.getFacet("filterPanel") : null;
        if (facet == null || !facet.isRendered()) {
            this.log("renderFilterPanel", "Filter panel not rendered, nothing to display");
            return;
        }
        this.renderPanelStart(context, component, writer, "_filterPanel", this.getTheme().getMessage("table.panel.filterTitle"), null);
        RenderingUtilities.renderComponent(facet, context);
        this.renderPanelEnd(writer);
    }

    protected void renderPreferencesPanel(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderPreferencesPanel", "Cannot render preferences panel, TablePanels is null");
            return;
        }
        Table table = component.getTableAncestor();
        UIComponent uIComponent = facet = table != null ? table.getFacet("preferencesPanel") : null;
        if (facet == null || !facet.isRendered()) {
            this.log("renderPreferencesPanel", "Preferences panel not rendered, nothing to display");
            return;
        }
        this.renderPanelStart(context, component, writer, "_preferencesPanel", this.getTheme().getMessage("table.panel.preferencesTitle"), null);
        RenderingUtilities.renderComponent(facet, context);
        this.renderPanelEnd(writer);
    }

    protected void renderSortPanel(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderSortPanel", "Cannot render sort panel, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        this.renderPanelStart(context, component, writer, "_sortPanel", theme.getMessage("table.panel.sortTitle"), theme.getMessage("table.panel.help"));
        Table table = component.getTableAncestor();
        UIComponent uIComponent = facet = table != null ? table.getFacet("sortPanel") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            this.renderSortPanelLayout(context, component, writer);
        }
        this.renderPanelEnd(writer);
    }

    protected void renderEnclosingTagStart(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText("\n", null);
        writer.startElement("td", component);
        writer.writeAttribute("id", component.getClientId(context), null);
        String extraHtml = RenderingUtilities.renderStyleClass(context, writer, component, theme.getStyleClass("TABLE_PANEL_TD"), component.getExtraHtml());
        if (component.getColSpan() > -1 && (extraHtml == null || extraHtml.indexOf("colspan=") == -1)) {
            writer.writeAttribute("colspan", Integer.toString(component.getColSpan()), null);
        }
        if (component.getRowSpan() > -1 && (extraHtml == null || extraHtml.indexOf("rowspan=") == -1)) {
            writer.writeAttribute("rowspan", Integer.toString(component.getRowSpan()), null);
        }
        if (component.isNoWrap() && (extraHtml == null || extraHtml.indexOf("nowrap=") == -1)) {
            writer.writeAttribute("nowrap", "nowrap", null);
        }
        if (component.getToolTip() != null && (extraHtml == null || extraHtml.indexOf("title=") == -1)) {
            writer.writeAttribute("title", component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes(component, writer, stringAttributes, extraHtml);
    }

    protected void renderEnclosingTagEnd(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagEnd", "Cannot render enclosing tag, TablePanels is null");
            return;
        }
        writer.endElement("td");
    }

    private String getId(UIComponent component, String id) {
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        return clientId + ':' + id;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private void log(String method, String message) {
        Class<?> clazz = this.getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void renderPanelStart(FacesContext context, TablePanels component, ResponseWriter writer, String id, String title, String tip) throws IOException {
        if (component == null) {
            this.log("renderPanelStart", "Cannot render panel, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("id", this.getId(component, id), null);
        writer.writeAttribute("class", theme.getStyleClass("HIDDEN"), null);
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_SHADOW3_DIV"), null);
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_SHADOW2_DIV"), null);
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_SHADOW1_DIV"), null);
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_DIV"), null);
        if (tip != null) {
            writer.writeText("\n", null);
            writer.startElement("div", component);
            writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_HELP_TEXT"), null);
            writer.writeText(tip, null);
            writer.endElement("div");
        }
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_TITLE"), null);
        writer.writeText(title, null);
        writer.endElement("div");
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_CONTENT"), null);
    }

    private void renderPanelEnd(ResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderSortPanelLayout(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        Option[] options;
        if (component == null) {
            this.log("renderSortPanelLayout", "Cannot render sort panel layout, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText("\n", null);
        writer.startElement("table", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_TABLE"), null);
        writer.writeAttribute("border", "0", null);
        writer.writeAttribute("cellpadding", "0", null);
        writer.writeAttribute("cellspacing", "0", null);
        this.renderSortPanelRow(context, component, writer, component.getPrimarySortColumnMenuLabel(), component.getPrimarySortColumnMenu(), component.getPrimarySortOrderMenu());
        UIComponent menu = component.getSecondarySortColumnMenu();
        Option[] optionArray = options = menu instanceof DropDown ? (Option[])((DropDown)menu).getItems() : null;
        if (options != null && options.length > 2) {
            this.renderSortPanelRow(context, component, writer, component.getSecondarySortColumnMenuLabel(), menu, component.getSecondarySortOrderMenu());
        } else {
            this.log("renderSortPanelLayout", "Secondary sort column menu not rendered");
        }
        menu = component.getTertiarySortColumnMenu();
        Option[] optionArray2 = options = menu instanceof DropDown ? (Option[])((DropDown)menu).getItems() : null;
        if (options != null && options.length > 3) {
            this.renderSortPanelRow(context, component, writer, component.getTertiarySortColumnMenuLabel(), menu, component.getTertiarySortOrderMenu());
        } else {
            this.log("renderSortPanelLayout", "Tertiary sort column menu not rendered");
        }
        writer.endElement("table");
        writer.writeText("\n", null);
        writer.startElement("div", component);
        writer.writeAttribute("class", theme.getStyleClass("TABLE_PANEL_BUTTON_DIV"), null);
        RenderingUtilities.renderComponent(component.getSortPanelSubmitButton(), context);
        RenderingUtilities.renderComponent(component.getSortPanelCancelButton(), context);
        writer.endElement("div");
    }

    private void renderSortPanelRow(FacesContext context, TablePanels component, ResponseWriter writer, UIComponent label, UIComponent columnMenu, UIComponent orderMenu) throws IOException {
        if (component == null) {
            this.log("renderSortPanelRow", "Cannot render sort panel row, TablePanels is null");
            return;
        }
        writer.writeText("\n", null);
        writer.startElement("tr", component);
        writer.writeText("\n", null);
        writer.startElement("td", component);
        if (label instanceof Label) {
            ((Label)label).setFor(columnMenu.getClientId(context));
            RenderingUtilities.renderComponent(label, context);
        } else {
            this.log("renderSortPanelRow", "Cannot render label, not Label instance");
        }
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", component);
        RenderingUtilities.renderComponent(columnMenu, context);
        writer.endElement("td");
        writer.writeText("\n", null);
        writer.startElement("td", component);
        RenderingUtilities.renderComponent(orderMenu, context);
        writer.endElement("td");
        writer.endElement("tr");
    }
}

