/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Upload;
import com.sun.webui.jsf.renderkit.html.FieldRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.util.UploadFilterFileItem;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.fileupload.FileUploadBase;

public class UploadRenderer
extends FieldRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String pid;
        Map<String, String> paramMap;
        String preservePath;
        UploadFilterFileItem fi;
        Upload upload = (Upload)component;
        Map<String, Object> fileItemMap = context.getExternalContext().getRequestMap();
        if (this.checkForFatalErrors(context, component, fileItemMap)) {
            upload.setSubmittedValue(null);
            return;
        }
        String id = component.getClientId(context);
        if (component instanceof ComplexComponent) {
            id = ((ComplexComponent)((Object)component)).getLabeledElementId(context);
        }
        if ((fi = (UploadFilterFileItem)fileItemMap.get(id)) != null && (preservePath = (paramMap = context.getExternalContext().getRequestParameterMap()).get(pid = id.concat("_preserve_path"))) != null) {
            fi.setClientFilePath(preservePath);
        }
        upload.setSubmittedValue(null);
        if (fi != null && !this.checkForFileErrors(context, component, fi)) {
            upload.setSubmittedValue(id);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Upload)) {
            Object[] params = new Object[]{component.toString(), this.getClass().getName(), Upload.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Upload.renderer", params);
            throw new FacesException(message);
        }
        Upload upload = (Upload)component;
        Map<String, Object> map = context.getExternalContext().getRequestMap();
        this.checkForFatalErrors(context, upload, map);
        super.renderField(context, upload, "file", this.getStyles(context));
        String id = upload.getClientId(context);
        StringBuilder jsString = new StringBuilder(128);
        jsString.append(JavaScriptUtilities.getModuleName("upload.setEncodingType")).append("('").append(id).append("');\n");
        if (upload.isPreservePath()) {
            jsString.append(JavaScriptUtilities.getModuleName("upload.preservePath")).append("('").append(id).append("','").append(id.concat("_com.sun.webui.jsf.upload").concat("_preserve_path")).append("');\n");
        }
        JavaScriptUtilities.renderJavaScript(upload, context.getResponseWriter(), jsString.toString(), JavaScriptUtilities.isParseOnLoad());
    }

    private boolean checkForFatalErrors(FacesContext context, UIComponent component, Map map) {
        String message = null;
        Throwable cause = null;
        Throwable error = (Throwable)map.get("upload_error_key");
        if (error != null) {
            cause = error.getCause();
            if (cause != null) {
                message = cause.getMessage();
            } else {
                cause = error;
            }
            if (message == null) {
                message = error.getMessage();
            }
            if (message == null) {
                message = ThemeUtilities.getTheme(context).getMessage("Upload.fatalError.parseException");
            }
        } else {
            String errorKey = (String)map.get("upload_nodata_key");
            if (errorKey != null) {
                message = ThemeUtilities.getTheme(context).getMessage("Upload.fatalError.noData");
            } else {
                return false;
            }
        }
        FacesMessage fmsg = new FacesMessage(message);
        context.addMessage(component.getClientId(context), fmsg);
        if (LogUtil.warningEnabled(Upload.class)) {
            if (cause != null) {
                LogUtil.warning(Upload.class, message, cause);
            } else {
                LogUtil.warning(Upload.class, message);
            }
        }
        map.remove("upload_error_key");
        map.remove("upload_nodata_key");
        return true;
    }

    private boolean checkForFileErrors(FacesContext context, UIComponent component, UploadFilterFileItem ufi) {
        List errorLog = ufi.getErrorLog();
        if (errorLog == null || errorLog.isEmpty()) {
            return false;
        }
        String msg = null;
        for (Exception e : errorLog) {
            msg = e instanceof FileUploadBase.SizeLimitExceededException ? ThemeUtilities.getTheme(context).getMessage("Upload.error", new Object[]{Long.valueOf(e.getMessage())}) : e.getMessage();
            if (msg == null) {
                msg = ThemeUtilities.getTheme(context).getMessage("Upload.fileError.IOException");
            }
            FacesMessage fmsg = new FacesMessage(msg);
            context.addMessage(component.getClientId(context), fmsg);
            if (!LogUtil.fineEnabled(Upload.class)) continue;
            LogUtil.fine(Upload.class, msg == null ? e.getClass().getName() : msg, e);
        }
        return true;
    }
}

