/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AnchorRendererBase
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"accessKey", "charset", "coords", "onBlur", "onClick", "onDblClick", "onFocus", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "rel", "rev", "shape", "style", "target", "type"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        this.setAttributes(context, component, json);
        this.setContents(context, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.anchor");
    }

    protected void setAttributes(FacesContext context, UIComponent component, JSONObject json) throws JSONException, IOException {
        Map<String, Object> attrsMap = component.getAttributes();
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        String tmp = null;
        tmp = (String)attrsMap.get("style");
        if (tmp != null && tmp.length() > 0) {
            json.put("style", tmp);
        }
        if ((tmp = (String)attrsMap.get("styleClass")) != null && tmp.length() > 0) {
            json.put("className", tmp);
        }
        if ((tmp = (String)attrsMap.get("toolTip")) != null && tmp.length() > 0) {
            json.put("title", tmp);
        }
        if ((tmp = (String)attrsMap.get("urlLang")) != null && tmp.length() > 0) {
            json.put("hrefLang", tmp);
        }
        json.put("disabled", (Boolean)attrsMap.get("disabled"));
        json.put("visible", (Boolean)attrsMap.get("visible"));
        String url = (String)attrsMap.get("url");
        this.setURL(context, component, json, url);
        int tabIndex = (Integer)attrsMap.get("tabIndex");
        if (tabIndex != Integer.MIN_VALUE) {
            json.put("tabIndex", tabIndex);
        }
    }

    protected void setContents(FacesContext context, UIComponent component, JSONObject json) throws JSONException, IOException {
        JSONArray jArray = new JSONArray();
        json.put("contents", jArray);
        String text = ConversionUtilities.convertValueToString(component, component.getAttributes().get("text"));
        if (text.length() > 0) {
            jArray.put(text);
        }
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UIParameter) continue;
            jArray.put(WidgetUtilities.renderComponent(context, child));
        }
    }

    protected void setURL(FacesContext context, UIComponent component, JSONObject json, String url) throws JSONException {
        if (url != null && url.length() > 0) {
            if (!url.startsWith("#")) {
                url = WidgetUtilities.translateURL(context, component, url);
            }
            json.put("prefix", context.getExternalContext().getRequestContextPath()).put("href", url);
        }
    }
}

