/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.FacesMessageUtils;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LabelRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "style", "onClick", "onFocus", "onBlur", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "dir", "lang", "accessKey"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        UIComponent labeledComponent;
        if (!(component instanceof Label)) {
            throw new IllegalArgumentException("LabelRenderer can only render Label components.");
        }
        Label label = (Label)component;
        Theme theme = this.getTheme();
        String forId = label.getFor();
        UIComponent fallbackIndicatorComponent = labeledComponent = label.getLabeledComponent(context);
        if (labeledComponent != null) {
            if (labeledComponent instanceof ComplexComponent) {
                forId = ((ComplexComponent)((Object)labeledComponent)).getLabeledElementId(context);
                fallbackIndicatorComponent = ((ComplexComponent)((Object)labeledComponent)).getIndicatorComponent(context, label);
            } else {
                forId = labeledComponent.getClientId(context);
            }
        }
        boolean isHideIndicators = label.isHideIndicators();
        boolean requiredFlag = label.isRequiredIndicator() && !isHideIndicators;
        boolean errorFlag = false;
        String errorMsg = null;
        if (!isHideIndicators) {
            UIComponent indicatorComponent = label.getIndicatorComponent(context, false);
            if (indicatorComponent == null) {
                indicatorComponent = fallbackIndicatorComponent;
            }
            if (indicatorComponent != null) {
                if (this.isProperty(indicatorComponent, "readOnly", false)) {
                    requiredFlag = false;
                } else {
                    requiredFlag = this.isProperty(indicatorComponent, "required", false);
                    boolean bl = errorFlag = !this.isProperty(indicatorComponent, "valid", true);
                }
                if (errorFlag) {
                    errorMsg = FacesMessageUtils.getDetailMessages(context, indicatorComponent.getClientId(context), true, " ");
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("level", label.getLabelLevel()).put("value", this.formatLabelText(context, label)).put("htmlFor", forId).put("required", requiredFlag).put("valid", !errorFlag).put("className", label.getStyleClass()).put("title", label.getToolTip()).put("visible", label.isVisible());
        UIComponent facet = component.getFacet("required");
        if (facet != null) {
            json.put("requiredImage", WidgetUtilities.renderComponent(context, facet));
        }
        if ((facet = component.getFacet("error")) != null) {
            json.put("errorImage", WidgetUtilities.renderComponent(context, facet));
        }
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        this.setContents(context, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.label");
    }

    protected String formatLabelText(FacesContext context, Label label) {
        String text = ConversionUtilities.convertValueToString(label, label.getValue());
        text = text.concat(" ");
        if (label.getChildCount() == 0) {
            return text;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (UIComponent kid : label.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            list.add(((UIParameter)kid).getValue());
        }
        if (list.size() == 0) {
            return text;
        }
        return MessageFormat.format(text, list.toArray(new Object[list.size()]));
    }

    protected void setContents(FacesContext context, UIComponent component, JSONObject json) throws IOException, JSONException {
        Iterator<UIComponent> kids = component.getChildren().iterator();
        if (!kids.hasNext()) {
            return;
        }
        JSONArray jArray = new JSONArray();
        json.put("contents", jArray);
        while (kids.hasNext()) {
            UIComponent child = kids.next();
            if (!child.isRendered()) continue;
            jArray.put(WidgetUtilities.renderComponent(context, child));
        }
    }

    private boolean isProperty(UIComponent component, String property, boolean doesNotExist) {
        Object o = component.getAttributes().get(property);
        if (o == null) {
            return doesNotExist;
        }
        return o instanceof Boolean ? (Boolean)o : false;
    }
}

