/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ProgressBar;
import com.sun.webui.jsf.component.TextArea;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgressBarRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"style"};
    private static final String[] intAttributes = new String[]{"progress", "width", "height", "refreshRate"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof ProgressBar)) {
            throw new IllegalArgumentException("ProgressBarRenderer can only render ProgressBar components.");
        }
        ProgressBar progressBar = (ProgressBar)component;
        JSONObject json = new JSONObject();
        String prefix = context.getExternalContext().getRequestContextPath();
        json.put("failedStateText", progressBar.getFailedStateText()).put("logMessage", progressBar.getLogMessage()).put("overlayAnimation", progressBar.isOverlayAnimation()).put("percentChar", this.getTheme().getMessage("ProgressBar.percentChar")).put("progressImageUrl", progressBar.getProgressImageUrl()).put("taskState", progressBar.getTaskState()).put("toolTip", progressBar.getToolTip() != null ? progressBar.getToolTip() : this.getTheme().getMessage("ProgressBar.toolTip")).put("type", progressBar.getType()).put("className", progressBar.getStyleClass()).put("prefix", prefix).put("refreshRate", progressBar.getRefreshRate()).put("visible", progressBar.isVisible());
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        this.setFacetProperties(context, progressBar, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.progressBar");
    }

    private void setFacetProperties(FacesContext context, ProgressBar component, JSONObject json) throws IOException, JSONException {
        UIComponent bottomTextFacet;
        ProgressBar pb;
        UIComponent rightButtonCon = component.getFacet("progressControlRight");
        UIComponent bottomButtonCon = component.getFacet("progressControlBottom");
        if (rightButtonCon != null) {
            json.put("progressControlRight", WidgetUtilities.renderComponent(context, rightButtonCon));
        }
        if (bottomButtonCon != null) {
            json.put("progressControlBottom", WidgetUtilities.renderComponent(context, bottomButtonCon));
        }
        if ((pb = component).getLogMessage() != null) {
            TextArea textArea = (TextArea)pb.getLogMsgComponent(component);
            json.put("log", WidgetUtilities.renderComponent(context, textArea));
            json.put("logId", ((UIComponent)textArea).getClientId(context));
        }
        if ((bottomTextFacet = component.getFacet("progressTextBottom")) != null) {
            json.put("bottomText", WidgetUtilities.renderComponent(context, bottomTextFacet));
        } else {
            json.put("bottomText", pb.getStatus());
        }
        UIComponent topTextFacet = component.getFacet("progressTextTop");
        if (topTextFacet != null) {
            json.put("topText", WidgetUtilities.renderComponent(context, topTextFacet));
        } else {
            json.put("topText", pb.getDescription());
        }
    }
}

