/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class StaticTextRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "style", "onClick", "onDblClick", "dir", "lang"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof StaticText)) {
            throw new IllegalArgumentException("StaticTextRenderer can only render StaticText components.");
        }
        StaticText staticText = (StaticText)component;
        String message = null;
        String currentValue = ConversionUtilities.convertValueToString(component, staticText.getText());
        if (currentValue != null) {
            ArrayList<Object> parameterList = new ArrayList<Object>();
            for (UIComponent kid : component.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                parameterList.add(((UIParameter)kid).getValue());
            }
            message = parameterList.size() > 0 ? MessageFormat.format(currentValue, parameterList.toArray(new Object[parameterList.size()])) : currentValue;
        }
        String templatePath = staticText.getHtmlTemplate();
        JSONObject json = new JSONObject();
        json.put("value", message).put("title", staticText.getToolTip()).put("escape", staticText.isEscape()).put("className", staticText.getStyleClass()).put("visible", staticText.isVisible());
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.staticText");
    }
}

