/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.faces.extensions.avatar.lifecycle.AsyncResponse;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class ComponentUtilities {
    private static final String USCORE = "_";

    public static void putPrivateFacet(UIComponent parent, String facetName, UIComponent facet) {
        if (parent == null || facet == null || facetName == null) {
            return;
        }
        parent.getFacets().put(ComponentUtilities.createPrivateFacetName(facetName), facet);
    }

    public static void removePrivateFacet(UIComponent parent, String facetName) {
        if (parent == null || facetName == null) {
            return;
        }
        parent.getFacets().remove(ComponentUtilities.createPrivateFacetName(facetName));
    }

    public static UIComponent getPrivateFacet(UIComponent parent, String facetName, boolean matchId) {
        if (parent == null || facetName == null) {
            return null;
        }
        String pfacetName = ComponentUtilities.createPrivateFacetName(facetName);
        UIComponent facet = parent.getFacets().get(pfacetName);
        if (facet == null) {
            return null;
        }
        if (!matchId) {
            return facet;
        }
        String id = ComponentUtilities.createPrivateFacetId(parent, facetName);
        if (!id.equals(facet.getId())) {
            parent.getFacets().remove(pfacetName);
            return null;
        }
        return facet;
    }

    public static String createPrivateFacetName(String facetName) {
        return USCORE.concat(facetName);
    }

    public static String createPrivateFacetId(UIComponent parent, String facetName) {
        String pfacetName = ComponentUtilities.createPrivateFacetName(facetName);
        String id = parent.getId();
        if (id != null) {
            pfacetName = id.concat(pfacetName);
        }
        return pfacetName;
    }

    public static boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled == null) {
            return false;
        }
        if (disabled instanceof String) {
            return Boolean.valueOf((String)disabled);
        }
        return disabled.equals(Boolean.TRUE);
    }

    public static boolean isReadOnly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly == null) {
            return false;
        }
        if (readonly instanceof String) {
            return Boolean.valueOf((String)readonly);
        }
        return readonly.equals(Boolean.TRUE);
    }

    public static boolean isAjaxRequest(FacesContext context, UIComponent component) {
        return ComponentUtilities.isAjaxRequest(context, component, null);
    }

    public static boolean isAjaxRequest(FacesContext context, UIComponent component, String event) {
        if (context == null || component == null) {
            return false;
        }
        boolean isAjaxRequest = false;
        if (AsyncResponse.isAjaxRequest()) {
            try {
                Map<String, String> map = context.getExternalContext().getRequestHeaderMap();
                JSONObject xjson = new JSONObject(map.get("X-JSON"));
                String id = (String)xjson.get("id");
                if (component.getClientId(context).equals(id)) {
                    if (event != null) {
                        String evt = (String)xjson.get("event");
                        if (event.equals(evt)) {
                            isAjaxRequest = true;
                        }
                    } else {
                        isAjaxRequest = true;
                    }
                }
            }
            catch (JSONException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return isAjaxRequest;
    }

    public static boolean isAjaxExecuteRequest(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            return false;
        }
        if (AsyncResponse.isAjaxRequest()) {
            Map<String, String> map = context.getExternalContext().getRequestHeaderMap();
            String listToExecute = map.get("com.sun.faces.avatar.execute");
            if (listToExecute == null || listToExecute.equals("none")) {
                return false;
            }
            String compId = component.getClientId(context);
            StringTokenizer st = new StringTokenizer(listToExecute, ", ");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(compId)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getDefaultDatePattern(String pattern, Locale locale) {
        if (locale == null) {
            locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        }
        String resultPattern = null;
        if (pattern != null) {
            resultPattern = new String(pattern);
        } else {
            SimpleDateFormat dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
            resultPattern = dateFormat.toPattern();
        }
        if (resultPattern.indexOf("yyyy") == -1) {
            resultPattern = resultPattern.replaceFirst("yy", "yyyy");
        }
        if (resultPattern.indexOf("MM") == -1) {
            resultPattern = resultPattern.replaceFirst("M", "MM");
        }
        if (resultPattern.indexOf("dd") == -1) {
            resultPattern = resultPattern.replaceFirst("d", "dd");
        }
        return resultPattern;
    }
}

