/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.util.ValueType;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;

public class ValueTypeEvaluator {
    private ValueType valueType = null;
    private UIComponent component = null;
    private static final boolean DEBUG = false;

    public ValueTypeEvaluator(UIComponent component) {
        this.component = component;
        if (!(component instanceof ValueHolder)) {
            this.valueType = ValueType.NONE;
        }
    }

    public ValueType getValueType() {
        if (this.valueType == null) {
            this.valueType = this.getValueType(FacesContext.getCurrentInstance());
        }
        return this.valueType;
    }

    public ValueType getValueType(FacesContext context) {
        if (this.valueType == null) {
            this.valueType = this.evaluateValueType(context);
        }
        return this.valueType;
    }

    public void reset() {
        this.valueType = null;
    }

    private ValueType evaluateValueType(FacesContext context) {
        ValueExpression valueExpr = this.component.getValueExpression("value");
        if (valueExpr != null) {
            return this.evaluateValueBinding(valueExpr, context);
        }
        Object valueObject = ((ValueHolder)((Object)this.component)).getValue();
        if (valueObject == null) {
            if (this.component instanceof Selector) {
                boolean isMultiple = ((Selector)this.component).isMultiple();
                if (isMultiple) {
                    return ValueType.ARRAY;
                }
                return ValueType.OBJECT;
            }
            return ValueType.OBJECT;
        }
        return this.evaluateClass(valueObject.getClass());
    }

    private ValueType evaluateValueBinding(ValueExpression valueExpression, FacesContext context) {
        Object value;
        Class<?> clazz = valueExpression.getType(context.getELContext());
        if (clazz == null) {
            String msg = "\tComponent has invalid value binding for \"value\".";
            throw new ConverterException(msg);
        }
        if (Object.class.equals(clazz) && (value = valueExpression.getValue(context.getELContext())) != null) {
            clazz = value.getClass();
        }
        return this.evaluateClass(clazz);
    }

    private ValueType evaluateClass(Class clazz) {
        if (clazz.isArray()) {
            return ValueType.ARRAY;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ValueType.LIST;
        }
        return ValueType.OBJECT;
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }
}

