/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.validator;

import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.text.MessageFormat;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class StringLengthValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "com.sun.webui.jsf.StringLength";
    private String tooShortMessage = null;
    private String tooLongMessage;
    private int minLength = 0;
    private int maxLength = 0;
    private boolean minimumSet = false;
    private static final boolean DEBUG = false;
    private boolean transientValue = false;

    public StringLengthValidator() {
    }

    public StringLengthValidator(int max) {
        this.maxLength = max;
    }

    public StringLengthValidator(int max, int min) {
        this(max);
        this.minLength = min;
        this.minimumSet = true;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String string = value == null ? new String() : (String)value;
        if (string.length() > this.maxLength) {
            if (this.tooLongMessage == null) {
                Theme theme = ThemeUtilities.getTheme(context);
                this.tooLongMessage = theme.getMessage("StringLengthValidator.itemTooLong");
            }
            MessageFormat mf = new MessageFormat(this.tooLongMessage, context.getViewRoot().getLocale());
            Object[] params = new Object[]{String.valueOf(this.maxLength)};
            FacesMessage msg = new FacesMessage(mf.format(params));
            throw new ValidatorException(msg);
        }
        if (this.minimumSet && string.length() < this.minLength) {
            if (this.tooShortMessage == null) {
                Theme theme = ThemeUtilities.getTheme(context);
                this.tooShortMessage = theme.getMessage("StringLengthValidator.itemTooLong");
            }
            MessageFormat mf = new MessageFormat(this.tooShortMessage, context.getViewRoot().getLocale());
            Object[] params = new Object[]{String.valueOf(this.minLength)};
            FacesMessage msg = new FacesMessage(mf.format(params));
            throw new ValidatorException(msg);
        }
    }

    private String integerToString(UIComponent component, Integer toConvert) {
        String result = null;
        Converter converter = null;
        FacesContext context = FacesContext.getCurrentInstance();
        converter = context.getApplication().createConverter("javax.faces.Number");
        result = converter.getAsString(context, component, toConvert);
        return result;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{new Integer(this.maxLength), new Integer(this.minLength), this.minimumSet ? Boolean.TRUE : Boolean.FALSE, this.tooLongMessage, this.tooShortMessage};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maxLength = (Integer)values[0];
        this.minLength = (Integer)values[1];
        this.minimumSet = (Boolean)values[2];
        if (values[3] != null) {
            this.tooLongMessage = values[3].toString();
        }
        if (values[4] != null) {
            this.tooShortMessage = values[4].toString();
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean transientValue) {
    }

    public String getTooLongMessage() {
        return this.tooLongMessage;
    }

    public void setTooLongMessage(String tooLongMessage) {
        this.tooLongMessage = tooLongMessage;
    }

    public String getTooShortMessage() {
        return this.tooShortMessage;
    }

    public void setTooShortMessage(String tooShortMessage) {
        this.tooShortMessage = tooShortMessage;
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }
}

