/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.theme.SPIThemeFactory;
import com.sun.webui.theme.ThemeFactory;
import java.util.Locale;
import java.util.Set;

public abstract class ThemeContext {
    public static final String THEME_MESSAGES = "com.sun.webui.theme.THEME_MESSAGES";
    private String messages;
    public static final String SUPPORTED_LOCALES = "com.sun.webui.theme.SUPPORTED_LOCALES";
    protected static final String LOCALE_SEPARATOR = ",";
    private Set supportedLocales;
    protected static final String THEME_CONTEXT = "com.sun.webui.theme.THEME_CONTEXT";
    protected static final String DEFAULT_LOCALE = "com.sun.webui.theme.DEFAULT_LOCALE";
    protected static final String DEFAULT_THEME = "com.sun.webui.theme.DEFAULT_THEME";
    protected static final String DEFAULT_THEME_VERSION = "com.sun.webui.theme.DEFAULT_THEME_VERSION";
    protected static final String THEME_RESOURCES = "com.sun.webui.theme.THEME_RESOURCES";
    protected static final String THEME_FACTORY_CLASS_NAME = "com.sun.webui.theme.THEME_FACTORY_CLASS_NAME";
    protected static final String THEME_SERVLET_CONTEXT = "com.sun.webui.theme.THEME_SERVLET_CONTEXT";
    private Locale defaultLocale = Locale.getDefault();
    private String defaultTheme = null;
    private String defaultThemeVersion = null;
    private String themeServletContext;
    private String[] themeResources;
    private String themeFactoryClassName;
    private ClassLoader defaultClassLoader;
    private String requestContextPath;
    private ThemeFactory themeFactory;
    public static final int NOVERSION = -1;
    private static String DOT = "\\.";

    public String getMessages() {
        return this.messages;
    }

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public Set getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(Set supportedLocales) {
        this.supportedLocales = supportedLocales;
    }

    ThemeContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeFactory getThemeFactory() {
        if (this.themeFactory == null) {
            ThemeContext themeContext = this;
            synchronized (themeContext) {
                if (this.themeFactory == null) {
                    try {
                        this.themeFactory = (ThemeFactory)Class.forName(this.getThemeFactoryClassName()).newInstance();
                    }
                    catch (Exception e) {
                        return new SPIThemeFactory();
                    }
                }
            }
        }
        return this.themeFactory;
    }

    public String[] getThemeResources() {
        return this.themeResources;
    }

    public void setThemeResources(String[] themeResources) {
        this.themeResources = themeResources;
    }

    public String getRequestContextPath() {
        return this.requestContextPath;
    }

    public void setRequestContextPath(String requestContextPath) {
        this.requestContextPath = requestContextPath;
    }

    public String getResourcePath(String path) {
        return this.getRequestContextPath() + this.getThemeServletContext() + (path.startsWith("/") ? "/" + path : path);
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = this.getLocale(defaultLocale);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader == null ? this.getClass().getClassLoader() : this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public String getThemeFactoryClassName() {
        return this.themeFactoryClassName;
    }

    public void setThemeFactoryClassName(String themeFactoryClassName) {
        this.themeFactoryClassName = themeFactoryClassName;
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setDefaultTheme(String defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public String getDefaultThemeVersion() {
        return this.defaultThemeVersion;
    }

    public void setDefaultThemeVersion(String defaultThemeVersion) {
        this.defaultThemeVersion = defaultThemeVersion;
    }

    public String getThemeServletContext() {
        return this.themeServletContext;
    }

    public void setThemeServletContext(String themeServletContext) {
        this.themeServletContext = themeServletContext;
    }

    public int getDefaultThemeMajorVersion() {
        return this.getVersionNumber(Version.MAJOR);
    }

    public int getDefaultThemeMinorVersion() {
        return this.getVersionNumber(Version.MINOR);
    }

    private int getVersionNumber(Version majorOrMinor) {
        int version = -1;
        if (this.getDefaultThemeVersion() == null) {
            return -1;
        }
        try {
            String[] majmin = this.getDefaultThemeVersion().split(DOT);
            switch (majorOrMinor) {
                case MAJOR: {
                    version = Integer.parseInt(majmin[0]);
                    break;
                }
                case MINOR: {
                    version = Integer.parseInt(majmin[1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private Locale getLocale(String localeString) {
        if (localeString == null) {
            return null;
        }
        if ((localeString = localeString.trim()).length() == 0) {
            return null;
        }
        Locale locale = null;
        String[] strings = localeString.split("_");
        if (strings.length > 2) {
            locale = new Locale(strings[0], strings[1], strings[2]);
        } else if (strings.length > 1) {
            locale = new Locale(strings[0], strings[1]);
        } else if (strings.length > 0) {
            locale = new Locale(strings[0]);
        }
        return locale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Version {
        MAJOR,
        MINOR;

    }
}

