/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SingleSignOn
extends ValveBase
implements SessionListener {
    protected HashMap cache = new HashMap();
    protected static final String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected HashMap reverse = new HashMap();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log("Stopped");
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.debug >= 1) {
            this.log("Process session destroyed on " + session);
        }
        String ssoId = null;
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        this.deregister(ssoId, session);
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.debug >= 1) {
            this.log("Process request for '" + hreq.getRequestURI() + "'");
        }
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                this.log(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 2;
        }
        if (this.debug >= 1) {
            this.log(" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(" SSO cookie is not present");
            }
            return 1;
        }
        if (this.debug >= 1) {
            this.log(" Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue())) != null) {
            if (this.debug >= 1) {
                this.log(" Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
        } else {
            if (this.debug >= 1) {
                this.log(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
        }
        return 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        SingleSignOnEntry sso;
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log("Associate sso id " + ssoId + " with session " + session);
        }
        if ((sso = this.lookup(ssoId)) != null) {
            sso.addSession(this, session);
        }
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.put(session, ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso == null) {
            return;
        }
        sso.removeSession(session);
        Session[] sessions = sso.findSessions();
        if (sessions == null || sessions.length == 0) {
            HashMap hashMap2 = this.cache;
            synchronized (hashMap2) {
                sso = (SingleSignOnEntry)this.cache.remove(ssoId);
            }
        }
    }

    protected void register(String ssoId, Principal principal, String authType, String username, String password, String realmName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.debug >= 1) {
            this.log("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'");
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, new SingleSignOnEntry(ssoId, principal, authType, username, password));
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, throwable);
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            return (SingleSignOnEntry)this.cache.get(ssoId);
        }
    }
}

