/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import com.sun.grizzly.tcp.ProtocolHandler;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mbeans.ClassNameMBean;
import org.apache.tomcat.util.IntrospectionUtils;

public class ConnectorMBean
extends ClassNameMBean {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object attribute = null;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        Connector connector = null;
        try {
            connector = (Connector)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        if (!("algorithm".equals(name) || "keystoreType".equals(name) || "maxThreads".equals(name) || "maxSpareThreads".equals(name))) {
            if (!"minSpareThreads".equals(name)) return super.getAttribute(name);
        }
        if ("keystoreType".equals(name)) {
            name = "keyType";
        }
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        try {
            if (protocolHandler == null) return attribute;
            return IntrospectionUtils.getAttribute(protocolHandler, name);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute is null"), "Attribute is null");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        Connector connector = null;
        try {
            connector = (Connector)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        if ("algorithm".equals(name) || "keystoreType".equals(name) || "maxThreads".equals(name) || "maxSpareThreads".equals(name) || "minSpareThreads".equals(name)) {
            if ("keystoreType".equals(name)) {
                name = "keyType";
            }
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            try {
                if (protocolHandler == null) return;
                IntrospectionUtils.setAttribute(protocolHandler, name, value);
                return;
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        } else {
            super.setAttribute(attribute);
        }
    }
}

