/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;

public class IndirectList
extends Vector
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Vector delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    private transient List addedElements;
    private transient List removedElements;
    protected int initialCapacity = 10;

    public IndirectList() {
        this(10);
    }

    public IndirectList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IndirectList(int initialCapacity, int capacityIncrement) {
        super(0);
        this.initialize(initialCapacity, capacityIncrement);
    }

    public IndirectList(Collection c) {
        super(0);
        this.initialize(c);
    }

    public void add(int index, Object element) {
        this.getDelegate().add(index, element);
        this.raiseAddChangeEvent(element);
    }

    protected void raiseAddChangeEvent(Object element) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, element, CollectionChangeEvent.ADD));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(element, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object element) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, element, CollectionChangeEvent.REMOVE));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(element);
        }
    }

    public synchronized boolean add(Object element) {
        boolean added = true;
        if (this.shouldAvoidInstantiation()) {
            if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
                this.getRemovedElements().remove(element);
            } else {
                if (this.getAddedElements().contains(element)) {
                    return false;
                }
                this.getAddedElements().add(element);
            }
        } else {
            added = this.getDelegate().add(element);
        }
        this.raiseAddChangeEvent(element);
        return added;
    }

    public synchronized boolean addAll(int index, Collection c) {
        Iterator objects = c.iterator();
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            while (objects.hasNext()) {
                this.add(index, objects.next());
                ++index;
            }
            return true;
        }
        return this.getDelegate().addAll(index, c);
    }

    public synchronized boolean addAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.add(objects.next());
            }
            return true;
        }
        return this.getDelegate().addAll(c);
    }

    public synchronized void addElement(Object obj) {
        this.add(obj);
    }

    protected Vector buildDelegate() {
        int index;
        int size;
        Vector delegate = (Vector)this.getValueHolder().getValue();
        if (delegate == null) {
            delegate = new Vector(this.initialCapacity, this.capacityIncrement);
        }
        while (delegate instanceof IndirectList) {
            delegate = ((IndirectList)delegate).getDelegate();
        }
        if (this.hasAddedElements()) {
            size = this.getAddedElements().size();
            for (index = 0; index < size; ++index) {
                Object element = ((List)this.getAddedElements()).get(index);
                if (delegate.contains(element)) continue;
                delegate.add(element);
            }
            this.addedElements = null;
        }
        if (this.hasRemovedElements()) {
            size = this.getRemovedElements().size();
            for (index = 0; index < size; ++index) {
                delegate.remove(((List)this.getRemovedElements()).get(index));
            }
            this.removedElements = null;
        }
        return delegate;
    }

    public int capacity() {
        return this.getDelegate().capacity();
    }

    public void clear() {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(o);
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public synchronized Object clone() {
        IndirectList result = (IndirectList)super.clone();
        result.delegate = (Vector)this.getDelegate().clone();
        result.attributeName = null;
        result.changeListener = null;
        return result;
    }

    public boolean contains(Object element) {
        if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
            return true;
        }
        if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
            return false;
        }
        return this.getDelegate().contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.getDelegate().containsAll(c);
    }

    public synchronized void copyInto(Object[] anArray) {
        this.getDelegate().copyInto(anArray);
    }

    public synchronized Object elementAt(int index) {
        return this.getDelegate().elementAt(index);
    }

    public Enumeration elements() {
        return this.getDelegate().elements();
    }

    public synchronized void ensureCapacity(int minCapacity) {
        this.getDelegate().ensureCapacity(minCapacity);
    }

    public synchronized boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    public synchronized Object firstElement() {
        return this.getDelegate().firstElement();
    }

    public synchronized Object get(int index) {
        return this.getDelegate().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getDelegate() {
        if (this.delegate == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    public Object getDelegateObject() {
        return this.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Vector(this.initialCapacity, this.capacityIncrement));
                }
            }
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public int indexOf(Object elem) {
        return this.getDelegate().indexOf(elem);
    }

    public synchronized int indexOf(Object elem, int index) {
        return this.getDelegate().indexOf(elem, index);
    }

    protected void initialize(int initialCapacity, int capacityIncrement) {
        this.initialCapacity = initialCapacity;
        this.capacityIncrement = capacityIncrement;
        this.delegate = null;
        this.valueHolder = null;
    }

    protected void initialize(Collection c) {
        this.delegate = null;
        Vector temp = new Vector(c);
        this.valueHolder = new ValueHolder(temp);
    }

    public synchronized void insertElementAt(Object obj, int index) {
        this.getDelegate().insertElementAt(obj, index);
        this.raiseAddChangeEvent(obj);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().iterator();
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
            }
        };
    }

    public synchronized Object lastElement() {
        return this.getDelegate().lastElement();
    }

    public int lastIndexOf(Object elem) {
        return this.getDelegate().lastIndexOf(elem);
    }

    public synchronized int lastIndexOf(Object elem, int index) {
        return this.getDelegate().lastIndexOf(elem, index);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            ListIterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().listIterator(index);
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public Object previous() {
                this.currentObject = this.delegateIterator.previous();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
            }

            public void set(Object object) {
                this.delegateIterator.set(object);
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
                IndirectList.this.raiseAddChangeEvent(object);
            }

            public void add(Object object) {
                this.delegateIterator.add(object);
                IndirectList.this.raiseAddChangeEvent(object);
            }
        };
    }

    public synchronized Object remove(int index) {
        Object value = this.getDelegate().remove(index);
        this.raiseRemoveChangeEvent(value);
        return value;
    }

    public boolean remove(Object element) {
        if (this.shouldAvoidInstantiation()) {
            if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
                this.getAddedElements().remove(element);
            } else {
                if (this.getRemovedElements().contains(element)) {
                    return false;
                }
                this.getRemovedElements().add(element);
            }
            this.raiseRemoveChangeEvent(element);
            return true;
        }
        if (this.getDelegate().remove(element)) {
            this.raiseRemoveChangeEvent(element);
            return true;
        }
        return false;
    }

    public synchronized boolean removeAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.remove(objects.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(c);
    }

    public synchronized void removeAllElements() {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(object);
            }
            return;
        }
        this.getDelegate().removeAllElements();
    }

    public synchronized boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    public synchronized void removeElementAt(int index) {
        this.remove(index);
    }

    public synchronized boolean retainAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.getDelegate().iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                if (c.contains(object)) continue;
                objects.remove();
                this.raiseRemoveChangeEvent(object);
            }
            return true;
        }
        return this.getDelegate().retainAll(c);
    }

    public synchronized Object set(int index, Object element) {
        Object oldValue = this.getDelegate().set(index, element);
        this.raiseRemoveChangeEvent(oldValue);
        this.raiseAddChangeEvent(element);
        return oldValue;
    }

    public synchronized void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public synchronized void setSize(int newSize) {
        if ((this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) && newSize > this.size()) {
            for (int index = this.size(); index > newSize; --index) {
                this.remove(index - 1);
            }
        }
        this.getDelegate().setSize(newSize);
    }

    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    public synchronized Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.getDelegate().toArray(a);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public synchronized void trimToSize() {
        this.getDelegate().trimToSize();
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Collection getRemovedElements() {
        if (this.removedElements == null) {
            this.removedElements = new ArrayList();
        }
        return this.removedElements;
    }

    public Collection getAddedElements() {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList();
        }
        return this.addedElements;
    }

    public boolean hasAddedElements() {
        return this.addedElements != null && !this.addedElements.isEmpty();
    }

    public boolean hasRemovedElements() {
        return this.removedElements != null && !this.removedElements.isEmpty();
    }

    public boolean hasDeferredChanges() {
        return this.hasRemovedElements() || this.hasAddedElements();
    }

    protected boolean shouldAvoidInstantiation() {
        return !this.isInstantiated() && this._persistence_getPropertyChangeListener() instanceof AttributeChangeListener;
    }
}

