/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;

public abstract class ContainerPolicy
implements Cloneable,
Serializable {
    protected transient ClassDescriptor elementDescriptor;
    protected transient Constructor constructor;

    protected boolean addInto(Object key, Object element, Object container) {
        throw QueryException.cannotAddToContainer(element, container, this);
    }

    public boolean addInto(Object element, Object container, AbstractSession session) {
        return this.addInto(null, element, container, session);
    }

    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        Object elementToAdd = element;
        if (this.elementDescriptor != null) {
            elementToAdd = this.elementDescriptor.getObjectBuilder().wrapObject(element, session);
        }
        return this.addInto(key, elementToAdd, container);
    }

    public void addIntoWithOrder(Integer index, Object element, Object container) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public void addIntoWithOrder(Integer index, Object element, Object container, AbstractSession session) {
        Object elementToAdd = element;
        if (this.elementDescriptor != null) {
            elementToAdd = this.elementDescriptor.getObjectBuilder().wrapObject(element, session);
        }
        this.addIntoWithOrder(index, elementToAdd, container);
    }

    public void addIntoWithOrder(Vector indexes, Hashtable elements, Object container, AbstractSession session) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        Object container = this.containerInstance(vector.size());
        int size = vector.size();
        for (int index = 0; index < size; ++index) {
            this.addInto(vector.get(index), container, session);
        }
        return container;
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass) {
        return ContainerPolicy.buildPolicyFor(concreteContainerClass, false);
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass, boolean hasOrdering) {
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.List_Class)) {
            if (hasOrdering) {
                return new OrderedListContainerPolicy(concreteContainerClass);
            }
            return new ListContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.SortedSet_Class)) {
            return new SortedCollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Collection_Class)) {
            return new CollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Map_Class)) {
            return new MapContainerPolicy(concreteContainerClass);
        }
        if (concreteContainerClass.equals(ClassConstants.CursoredStream_Class)) {
            return new CursoredStreamPolicy();
        }
        if (concreteContainerClass.equals(ClassConstants.ScrollableCursor_Class)) {
            return new ScrollableCursorPolicy();
        }
        throw ValidationException.illegalContainerClass(concreteContainerClass);
    }

    public void clear(Object container) {
        throw QueryException.methodNotValid(this, "clear(Object container)");
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public ContainerPolicy clone(ReadQuery query) {
        return (ContainerPolicy)this.clone();
    }

    public Object cloneFor(Object container) {
        throw QueryException.cannotCreateClone(this, container);
    }

    public void compareCollectionsForChange(Object oldCollection, Object newCollection, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        IdentityHashMap<Object, Object> originalKeyValues = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> cloneKeyValues = new IdentityHashMap<Object, Object>();
        if (oldCollection != null) {
            Object backUpIter = this.iteratorFor(oldCollection);
            while (this.hasNext(backUpIter)) {
                Object secondObject = this.next(backUpIter, session);
                if (secondObject == null) continue;
                originalKeyValues.put(secondObject, secondObject);
            }
        }
        if (newCollection != null) {
            Object cloneIter = this.iteratorFor(newCollection);
            while (this.hasNext(cloneIter)) {
                Object firstObject = this.next(cloneIter, session);
                if (firstObject == null) continue;
                if (originalKeyValues.containsKey(firstObject)) {
                    if (this.compareKeys(firstObject, session)) {
                        originalKeyValues.remove(firstObject);
                        continue;
                    }
                    Object backUpVersion = null;
                    backUpVersion = ((UnitOfWorkImpl)session).isClassReadOnly(firstObject.getClass()) ? ((UnitOfWorkImpl)session).getOriginalVersionOfObject(firstObject) : ((UnitOfWorkImpl)session).getBackupClone(firstObject);
                    ObjectChangeSet changeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(firstObject, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
                    changeSet.setOldKey(this.keyFrom(backUpVersion, session));
                    changeSet.setNewKey(this.keyFrom(firstObject, session));
                    cloneKeyValues.put(firstObject, firstObject);
                    continue;
                }
                cloneKeyValues.put(firstObject, firstObject);
            }
        }
        changeRecord.addAdditionChange(cloneKeyValues, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(originalKeyValues, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
    }

    public boolean compareKeys(Object sourceKey, AbstractSession session) {
        return true;
    }

    public Object concatenateContainers(Object firstContainer, Object secondContainer) {
        Object container = this.containerInstance(this.sizeFor(firstContainer) + this.sizeFor(secondContainer));
        Object firstIter = this.iteratorFor(firstContainer);
        while (this.hasNext(firstIter)) {
            this.addInto(null, this.next(firstIter), container);
        }
        Object secondIter = this.iteratorFor(secondContainer);
        while (this.hasNext(secondIter)) {
            this.addInto(null, this.next(secondIter), container);
        }
        return container;
    }

    public Object containerInstance() {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getContainerClass()));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }

    public Object containerInstance(int initialCapacity) {
        if (this.getConstructor() == null) {
            return this.containerInstance();
        }
        try {
            Object[] arguments = new Object[]{new Integer(initialCapacity)};
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getConstructor(), arguments));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                }
            }
            return PrivilegedAccessHelper.invokeConstructor(this.getConstructor(), arguments);
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }

    protected boolean contains(Object element, Object container) {
        throw QueryException.methodNotValid(this, "contains(Object element, Object container)");
    }

    public boolean contains(Object element, Object container, AbstractSession session) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator = this.iteratorFor(container);
            while (this.hasNext(iterator)) {
                Object next = this.next(iterator);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session).equals(element)) continue;
                return true;
            }
            return false;
        }
        return this.contains(element, container);
    }

    protected boolean containsKey(Object element, Object container) {
        throw QueryException.methodNotValid(this, "containsKey(Object element, Object container)");
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object execute() {
        throw QueryException.methodNotValid(this, "execute()");
    }

    protected Constructor getConstructor() {
        return this.constructor;
    }

    public Class getContainerClass() {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public String getContainerClassName() {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public ClassDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public boolean hasElementDescriptor() {
        return this.elementDescriptor != null;
    }

    public abstract boolean hasNext(Object var1);

    public boolean hasOrder() {
        return false;
    }

    public void initializeConstructor() {
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false));
                }
                catch (PrivilegedActionException exception) {
                    return;
                }
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false);
            }
            this.setConstructor(constructor);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isCollectionPolicy() {
        return false;
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return false;
    }

    public boolean isDirectMapPolicy() {
        return false;
    }

    public boolean isEmpty(Object container) {
        return this.sizeFor(container) == 0;
    }

    public boolean isListPolicy() {
        return false;
    }

    public boolean isMapPolicy() {
        return false;
    }

    public boolean isValidContainer(Object container) {
        throw QueryException.methodNotValid(this, "isValidContainer(Object container)");
    }

    public boolean isValidContainerType(Class containerType) {
        throw QueryException.methodNotValid(this, "isValidContainerType(Class containerType)");
    }

    public abstract Object iteratorFor(Object var1);

    public Object keyFrom(Object element, AbstractSession session) {
        return null;
    }

    public Object mergeCascadeParts(ObjectChangeSet objectChanges, MergeManager mergeManager, AbstractSession parentSession) {
        Object object = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            object = objectChanges.getTargetVersionOfSourceObject(parentSession);
            if (object == null && (objectChanges.isNew() || objectChanges.isAggregate()) && objectChanges.containsChangesFromSynchronization()) {
                if (!mergeManager.getObjectsAlreadyMerged().containsKey(objectChanges)) {
                    Class objectClass = objectChanges.getClassType(mergeManager.getSession());
                    object = mergeManager.getSession().getDescriptor(objectClass).getObjectBuilder().buildNewInstance();
                    mergeManager.getObjectsAlreadyMerged().put(objectChanges, object);
                } else {
                    object = mergeManager.getObjectsAlreadyMerged().get(objectChanges);
                }
            } else {
                object = objectChanges.getTargetVersionOfSourceObject(parentSession, true);
            }
            if (objectChanges.containsChangesFromSynchronization()) {
                mergeManager.mergeChanges(object, objectChanges);
            }
        } else {
            mergeManager.mergeChanges(objectChanges.getUnitOfWorkClone(), objectChanges);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession parentSession) {
        Iterator removeObjects = changeRecord.getRemoveObjectList().keySet().iterator();
        Object synchronizedValueOfTarget = valueOfTarget;
        if (valueOfTarget instanceof IndirectCollection) {
            synchronizedValueOfTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
        }
        Object object = synchronizedValueOfTarget;
        synchronized (object) {
            while (removeObjects.hasNext()) {
                ObjectChangeSet objectChanges = (ObjectChangeSet)removeObjects.next();
                this.removeFrom(objectChanges.getOldKey(), objectChanges.getTargetVersionOfSourceObject(mergeManager.getSession()), valueOfTarget, parentSession);
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) continue;
                mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
            }
            for (ObjectChangeSet objectChanges : changeRecord.getAddObjectList().keySet()) {
                Object object2 = null;
                if (shouldMergeCascadeParts) {
                    object2 = this.mergeCascadeParts(objectChanges, mergeManager, parentSession);
                }
                if (object2 == null) {
                    object2 = objectChanges.getTargetVersionOfSourceObject(mergeManager.getSession(), false);
                }
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object2, valueOfTarget, mergeManager.getSession())) continue;
                    this.addInto(objectChanges.getNewKey(), object2, valueOfTarget, mergeManager.getSession());
                    continue;
                }
                this.addInto(objectChanges.getNewKey(), object2, valueOfTarget, mergeManager.getSession());
            }
        }
    }

    protected abstract Object next(Object var1);

    public Object next(Object iterator, AbstractSession session) {
        Object next = this.next(iterator);
        if (this.hasElementDescriptor()) {
            next = this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session);
        }
        return next;
    }

    public boolean overridesRead() {
        return false;
    }

    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        if (query.isReadAllQuery() && !query.isReportQuery() && query.shouldUseWrapperPolicy()) {
            this.setElementDescriptor(query.getDescriptor());
        } else if (query.isDataReadQuery()) {
            ((DataReadQuery)query).setContainerPolicy(this);
        }
    }

    public void prepareForExecution() throws QueryException {
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getRemoveObjectList().remove(changeSetToAdd);
        } else {
            collectionChangeRecord.getAddObjectList().put(changeSetToAdd, changeSetToAdd);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToRemove)) {
            collectionChangeRecord.getAddObjectList().remove(changeSetToRemove);
        } else {
            collectionChangeRecord.getRemoveObjectList().put(changeSetToRemove, changeSetToRemove);
        }
    }

    public Object remoteExecute() {
        return null;
    }

    public void removeAllElements(Object container) {
        this.clear(container);
    }

    protected boolean removeFrom(Object key, Object element, Object container) {
        throw QueryException.cannotRemoveFromContainer(element, container, this);
    }

    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        Object objectToRemove = element;
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator = this.iteratorFor(container);
            while (this.hasNext(iterator)) {
                Object next = this.next(iterator);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session).equals(element)) continue;
                objectToRemove = next;
                break;
            }
        }
        return this.removeFrom(key, objectToRemove, container);
    }

    public boolean removeFrom(Object element, Object container, AbstractSession session) {
        return this.removeFrom(null, element, container, session);
    }

    public void removeFromWithOrder(int beginIndex, Object container) {
        throw QueryException.methodDoesNotExistInContainerClass("remove(index)", this.getContainerClass());
    }

    protected void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public void setContainerClass(Class containerClass) {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public void setContainerClassName(String containerClassName) {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public void setElementDescriptor(ClassDescriptor elementDescriptor) {
        this.elementDescriptor = elementDescriptor;
    }

    public void setKeyName(String instanceVariableName, String elementClassName) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, instanceVariableName);
    }

    public void setKeyName(String instanceVariableName, Class elementClass) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, instanceVariableName);
    }

    public int sizeFor(Object container) {
        throw QueryException.methodNotValid(this, "sizeFor(Object container)");
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.toStringInfo() + ")";
    }

    protected Object toStringInfo() {
        return "";
    }

    public void validateElementAndRehashIfRequired(Object sourceValue, Object target, AbstractSession session, Object targetVersionOfSource) {
    }

    public Vector vectorFor(Object container, AbstractSession session) {
        Vector<Object> result = new Vector<Object>(this.sizeFor(container));
        Object iter = this.iteratorFor(container);
        while (this.hasNext(iter)) {
            result.addElement(this.next(iter, session));
        }
        return result;
    }
}

