/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.IdentityHashSet;
import org.eclipse.persistence.internal.helper.IdentityWeakHashMap;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.jpa.PropertiesHandler;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectTracker;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkIdentityMapAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.coordination.MergeChangeSetCommand;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

public class UnitOfWorkImpl
extends AbstractSession
implements UnitOfWork {
    protected transient Map cloneToOriginals;
    protected transient AbstractSession parent;
    protected Map cloneMapping;
    protected Map newObjectsCloneToOriginal;
    protected Map newObjectsOriginalToClone;
    protected Map deletedObjects;
    protected Map allClones;
    protected Map objectsDeletedDuringCommit;
    protected Map removedObjects;
    protected Map unregisteredNewObjects;
    protected Map unregisteredNewObjectsInParent;
    protected Map unregisteredExistingObjects;
    protected Map newObjectsInParentOriginalToClone;
    protected Map newObjectsInParent;
    protected Map newAggregates;
    protected UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected UnitOfWorkImpl containerUnitOfWork;
    protected Map containerBeans;
    protected Map pessimisticLockedObjects;
    protected MergeManager lastUsedMergeManager;
    protected Map batchReadObjects;
    protected Hashtable readOnlyClasses;
    protected boolean wasTransactionBegunPrematurely;
    protected boolean shouldNewObjectsBeCached;
    protected boolean shouldPerformDeletesFirst;
    protected int shouldThrowConformExceptions;
    protected int validationLevel;
    public static final int None = 0;
    public static final int Partial = 1;
    public static final int Full = 2;
    protected int lifecycle;
    public static final int Birth = 0;
    public static final int CommitPending = 1;
    public static final int CommitTransactionPending = 2;
    public static final int WriteChangesFailed = 3;
    public static final int MergePending = 4;
    public static final int Death = 5;
    public static final int AfterExternalTransactionRolledBack = 6;
    public static final int DO_NOT_THROW_CONFORM_EXCEPTIONS = 0;
    public static final int THROW_ALL_CONFORM_EXCEPTIONS = 1;
    public static final String LOCK_QUERIES_PROPERTY = "LockQueriesProperties";
    protected static boolean SmartMerge = false;
    protected Hashtable optimisticReadLockObjects;
    public static final String ReadLockOnly = "no update";
    public static final String ReadLockUpdateVersion = "update version";
    protected List modifyAllQueries;
    protected List deferredModifyAllQueries;
    protected int cloneDepth = 0;
    protected Map objectsLockedForClone;
    protected Object transaction;
    protected ObjectTracker objectTracker;
    protected boolean shouldCheckWriteLock;
    protected boolean resumeOnTransactionCompletion;
    protected boolean wasNonObjectLevelModifyQueryExecuted;
    protected boolean shouldCascadeCloneToJoinedRelationship;
    protected boolean isNestedUnitOfWork;
    protected Boolean shouldValidateExistence;
    protected ReferenceMode referenceMode;
    protected IdentityHashSet changeTrackedHardList;

    public UnitOfWorkImpl(AbstractSession parent, ReferenceMode referenceMode) {
        this.referenceMode = referenceMode;
        this.name = parent.getName();
        this.parent = parent;
        this.cloneMapping = this.createMap();
        this.project = parent.getProject();
        this.profiler = parent.getProfiler();
        this.isInProfile = parent.isInProfile;
        this.sessionLog = parent.getSessionLog();
        this.eventManager = parent.getEventManager().clone(this);
        this.exceptionHandler = parent.getExceptionHandler();
        this.setReadOnlyClasses(parent.copyReadOnlyClasses());
        this.wasTransactionBegunPrematurely = false;
        this.shouldNewObjectsBeCached = false;
        this.validationLevel = 1;
        this.shouldPerformDeletesFirst = false;
        this.shouldThrowConformExceptions = 0;
        this.lifecycle = 0;
        this.shouldCheckWriteLock = parent.getDatasourceLogin().shouldSynchronizedReadOnWrite() || parent.getDatasourceLogin().shouldSynchronizeWrites();
        this.resumeOnTransactionCompletion = false;
        this.isNestedUnitOfWork = parent.isUnitOfWork();
        this.getEventManager().postAcquireUnitOfWork();
        this.incrementProfile("UnitOfWork");
    }

    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        UnitOfWorkImpl uow = super.acquireUnitOfWork();
        uow.discoverAllUnregisteredNewObjectsInParent();
        return uow;
    }

    public void addNewAggregate(Object originalObject) {
        this.getNewAggregates().put(originalObject, originalObject);
    }

    public void addObjectDeletedDuringCommit(Object object, ClassDescriptor descriptor) {
        this.getObjectsDeletedDuringCommit().put(object, this.keyFromObject(object, descriptor));
        ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObject(object, this);
    }

    public void addReadOnlyClass(Class theClass) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        this.getReadOnlyClasses().put(theClass, theClass);
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        if (descriptor.hasInheritance()) {
            Enumeration childEnum = descriptor.getInheritancePolicy().getChildDescriptors().elements();
            while (childEnum.hasMoreElements()) {
                ClassDescriptor childDescriptor = (ClassDescriptor)childEnum.nextElement();
                this.addReadOnlyClass(childDescriptor.getJavaClass());
            }
        }
    }

    public void addReadOnlyClasses(Collection classes) {
        for (Class theClass : classes) {
            this.addReadOnlyClass(theClass);
        }
    }

    public void addRemovedObject(Object orignal) {
        this.getRemovedObjects().put(orignal, orignal);
    }

    public void assignSequenceNumber(Object object) throws DatabaseException {
        this.assignSequenceNumber(object, this.getDescriptor(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSequenceNumber(Object object, ClassDescriptor descriptor) throws DatabaseException {
        if (descriptor.usesSequenceNumbers() && !this.getSequencing().shouldAcquireValueAfterInsert(object.getClass())) {
            this.startOperationProfile("assign sequence");
            ObjectBuilder builder = descriptor.getObjectBuilder();
            try {
                Object implementation = builder.unwrapObject(object, this);
                builder.assignSequenceNumber(implementation, this);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
            finally {
                this.endOperationProfile("assign sequence");
            }
        }
    }

    public void assignSequenceNumbers() throws DatabaseException {
        this.discoverAllUnregisteredNewObjects();
        this.assignSequenceNumbers(this.getUnregisteredNewObjects());
        this.assignSequenceNumbers(this.getNewObjectsCloneToOriginal());
    }

    protected void assignSequenceNumbers(Map objects) throws DatabaseException {
        Sequencing sequencing = this.getSequencing();
        if (sequencing == null) {
            return;
        }
        int whenShouldAcquireValueForAll = sequencing.whenShouldAcquireValueForAll();
        if (whenShouldAcquireValueForAll == 1) {
            return;
        }
        boolean shouldAcquireValueBeforeInsertForAll = whenShouldAcquireValueForAll == -1;
        this.startOperationProfile("assign sequence");
        for (Object object : objects.keySet()) {
            ClassDescriptor descriptor = this.getDescriptor(object);
            if (!descriptor.usesSequenceNumbers() || this.isObjectRegistered(object) && !this.isCloneNewObject(object) || !shouldAcquireValueBeforeInsertForAll && sequencing.shouldAcquireValueAfterInsert(object.getClass())) continue;
            descriptor.getObjectBuilder().assignSequenceNumber(object, this);
        }
        this.endOperationProfile("assign sequence");
    }

    public void beginEarlyTransaction() throws DatabaseException {
        this.beginTransaction();
        this.setWasTransactionBegunPrematurely(true);
    }

    public void beginTransaction() throws DatabaseException {
        this.getParent().beginTransaction();
    }

    public Object buildOriginal(Object workingClone) {
        ClassDescriptor descriptor = this.getDescriptor(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object original = builder.instantiateClone(workingClone, this);
        if (this.checkIfAlreadyRegistered(workingClone, descriptor) != null) {
            this.getCloneToOriginals().put(workingClone, original);
            return original;
        }
        Object backup = builder.instantiateClone(workingClone, this);
        this.getCloneMapping().put(workingClone, backup);
        this.getNewObjectsCloneToOriginal().put(workingClone, original);
        this.getNewObjectsOriginalToClone().put(original, workingClone);
        return original;
    }

    public UnitOfWorkChangeSet calculateChanges(Map registeredObjects, UnitOfWorkChangeSet changeSet, boolean assignSequences) {
        this.getEventManager().preCalculateUnitOfWorkChangeSet();
        if (assignSequences && !this.getProject().isPureCMP2Project()) {
            this.assignSequenceNumbers(this.getNewObjectsCloneToOriginal());
        }
        Iterator objects = registeredObjects.keySet().iterator();
        IdentityHashMap changedObjects = new IdentityHashMap();
        IdentityHashMap visitedNodes = new IdentityHashMap();
        while (objects.hasNext()) {
            Object object = objects.next();
            ClassDescriptor descriptor = this.getDescriptor(object);
            if (!descriptor.getObjectChangePolicy().shouldCompareForChange(object, this, descriptor)) continue;
            ObjectChangeSet changes = descriptor.getObjectChangePolicy().calculateChanges(object, this.getBackupClone(object), changeSet, this, descriptor, true);
            if (changes != null) {
                changeSet.addObjectChangeSet(changes, this, true);
                changedObjects.put(object, object);
                if (!changes.hasChanges() || changes.hasForcedChangesFromCascadeLocking()) continue;
                if (descriptor.hasCascadeLockingPolicies()) {
                    Enumeration policies = descriptor.getCascadeLockingPolicies().elements();
                    while (policies.hasMoreElements()) {
                        ((CascadeLockingPolicy)policies.nextElement()).lockNotifyParent(object, changeSet, this);
                    }
                    continue;
                }
                if (!descriptor.usesOptimisticLocking() || !descriptor.getOptimisticLockingPolicy().isCascaded()) continue;
                changes.setHasForcedChangesFromCascadeLocking(true);
                continue;
            }
            visitedNodes.put(object, object);
        }
        if (!this.getProject().isPureCMP2Project()) {
            IdentityHashMap newObjects = new IdentityHashMap();
            IdentityHashMap existingObjects = new IdentityHashMap(2);
            this.discoverUnregisteredNewObjects(changedObjects, newObjects, existingObjects, visitedNodes);
            this.setUnregisteredExistingObjects(existingObjects);
            this.setUnregisteredNewObjects(newObjects);
            if (assignSequences) {
                this.assignSequenceNumbers(newObjects);
            }
            for (Object object : newObjects.values()) {
                ClassDescriptor descriptor = this.getDescriptor(object);
                ObjectChangeSet changes = descriptor.getObjectChangePolicy().calculateChanges(object, this.getBackupClone(object), changeSet, this, descriptor, true);
                changeSet.addObjectChangeSet(changes, this, true);
            }
        }
        this.getEventManager().postCalculateUnitOfWorkChangeSet(changeSet);
        return changeSet;
    }

    protected boolean canChangeReadOnlySet() {
        return !this.hasCloneMapping() && !this.hasDeletedObjects();
    }

    public boolean checkForUnregisteredExistingObject(Object object) {
        ClassDescriptor descriptor = this.getDescriptor(object.getClass());
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true);
        if (primaryKey == null) {
            return false;
        }
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        existQuery = (DoesExistQuery)existQuery.clone();
        existQuery.setObject(object);
        existQuery.setPrimaryKey(primaryKey);
        existQuery.setDescriptor(descriptor);
        existQuery.setIsExecutionClone(true);
        return (Boolean)this.executeQuery(existQuery);
    }

    public Object checkExistence(Object object) {
        ClassDescriptor descriptor = this.getDescriptor(object.getClass());
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true);
        if (primaryKey == null) {
            return null;
        }
        DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
        Boolean exists = (Boolean)existQuery.checkEarlyReturn(object, primaryKey, this, null);
        if (exists == null) {
            existQuery = (DoesExistQuery)existQuery.clone();
            existQuery.setObject(object);
            existQuery.setPrimaryKey(primaryKey);
            existQuery.setDescriptor(descriptor);
            existQuery.setIsExecutionClone(true);
            exists = (boolean)((Boolean)this.executeQuery(existQuery));
        }
        if (exists.booleanValue()) {
            Object objectFromCache = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, object.getClass(), descriptor);
            if (objectFromCache != null) {
                if (this.shouldPerformFullValidation() && objectFromCache != object && this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, object.getClass(), descriptor) != object) {
                    throw ValidationException.wrongObjectRegistered(object, objectFromCache);
                }
                if (!this.isObjectDeleted(objectFromCache)) {
                    return objectFromCache;
                }
            }
            CacheKey cacheKey = new CacheKey(primaryKey);
            cacheKey.setReadTime(System.currentTimeMillis());
            return this.cloneAndRegisterObject(object, cacheKey, descriptor);
        }
        return null;
    }

    public Object checkIfAlreadyRegistered(Object object, ClassDescriptor descriptor) {
        if (this.isClassReadOnly(object.getClass(), descriptor)) {
            return null;
        }
        Object registeredObject = this.getCloneMapping().get(object);
        if (registeredObject != null) {
            return object;
        }
        if (this.hasNewObjects() && (registeredObject = this.getNewObjectsOriginalToClone().get(object)) != null) {
            return registeredObject;
        }
        if (this.isNestedUnitOfWork()) {
            if (this.hasNewObjectsInParentOriginalToClone()) {
                registeredObject = this.getNewObjectsInParentOriginalToClone().get(object);
            }
            if (registeredObject != null) {
                return registeredObject;
            }
        }
        return null;
    }

    protected Object cloneAndRegisterNewObject(Object original) {
        ClassDescriptor descriptor = this.getDescriptor(original);
        if (this.isNestedUnitOfWork() && descriptor.getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object clone = builder.instantiateWorkingCopyClone(original, this);
        this.getNewObjectsOriginalToClone().put(original, clone);
        this.getCloneMapping().put(clone, clone);
        builder.populateAttributesForClone(original, clone, this);
        this.registerNewObjectClone(clone, original, descriptor);
        Object backupClone = descriptor.getObjectChangePolicy().buildBackupClone(clone, builder, this);
        this.getCloneMapping().put(clone, backupClone);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cloneAndRegisterObject(Object original, CacheKey parentCacheKey, ClassDescriptor descriptor) {
        CacheKey unitOfWorkCacheKey = this.getIdentityMapAccessorInstance().acquireLock(parentCacheKey.getKey(), original.getClass(), descriptor);
        try {
            Object object = this.cloneAndRegisterObject(original, parentCacheKey, unitOfWorkCacheKey, descriptor);
            return object;
        }
        finally {
            unitOfWorkCacheKey.release();
        }
    }

    public void checkInvalidObject(Object object, CacheKey cacheKey, ClassDescriptor descriptor) {
        CacheInvalidationPolicy cachePolicy;
        if (!this.isNestedUnitOfWork() && cacheKey.getObject() != null && (cachePolicy = descriptor.getCacheInvalidationPolicy()).shouldRefreshInvalidObjectsInUnitOfWork() && cachePolicy.isInvalidated(cacheKey)) {
            ReadObjectQuery query = new ReadObjectQuery();
            query.setReferenceClass(object.getClass());
            query.setSelectionKey(cacheKey.getKey());
            query.refreshIdentityMapResult();
            query.setIsExecutionClone(true);
            this.parent.executeQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cloneAndRegisterObject(Object original, CacheKey parentCacheKey, CacheKey unitOfWorkCacheKey, ClassDescriptor descriptor) {
        ClassDescriptor concreteDescriptor = descriptor;
        if (original.getClass() != descriptor.getJavaClass()) {
            concreteDescriptor = this.getDescriptor(original);
        }
        if (this.isNestedUnitOfWork() && concreteDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder builder = concreteDescriptor.getObjectBuilder();
        Object workingClone = null;
        boolean identityMapLocked = this.shouldCheckWriteLock && this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
        boolean rootOfCloneRecursion = false;
        if (identityMapLocked) {
            this.checkInvalidObject(original, parentCacheKey, descriptor);
        } else if (this.objectsLockedForClone == null) {
            if (concreteDescriptor.shouldAcquireCascadedLocks()) {
                this.objectsLockedForClone = this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireLocksForClone(original, concreteDescriptor, parentCacheKey, this.getParent(), this);
            } else {
                this.checkInvalidObject(original, parentCacheKey, descriptor);
                parentCacheKey.acquireReadLock();
            }
            rootOfCloneRecursion = true;
        }
        try {
            workingClone = builder.instantiateWorkingCopyClone(original, this);
            if (workingClone instanceof PersistenceEntity) {
                ((PersistenceEntity)workingClone)._persistence_setPKVector(parentCacheKey.getKey());
            }
            this.getCloneMapping().put(workingClone, workingClone);
            if (this.isNestedUnitOfWork() && this.isCloneNewObjectFromParent(original)) {
                this.getNewObjectsInParentOriginalToClone().put(original, workingClone);
            }
            this.getCloneToOriginals().put(workingClone, original);
            this.populateAndRegisterObject(original, workingClone, unitOfWorkCacheKey, parentCacheKey, concreteDescriptor);
            if (concreteDescriptor.hasFetchGroupManager()) {
                concreteDescriptor.getFetchGroupManager().copyFetchGroupInto(original, workingClone, this);
            }
        }
        finally {
            if (identityMapLocked) {
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
            } else if (rootOfCloneRecursion) {
                if (this.objectsLockedForClone == null) {
                    parentCacheKey.releaseReadLock();
                } else {
                    Iterator iterator = this.objectsLockedForClone.values().iterator();
                    while (iterator.hasNext()) {
                        ((CacheKey)iterator.next()).releaseReadLock();
                    }
                    this.objectsLockedForClone = null;
                }
            }
        }
        concreteDescriptor.getObjectBuilder().instantiateEagerMappings(workingClone, this);
        return workingClone;
    }

    public Map collectAndPrepareObjectsForNestedMerge() {
        this.discoverAllUnregisteredNewObjectsInParent();
        return new IdentityHashMap(this.getCloneMapping());
    }

    public void commit() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        if (this.getLifecycle() == 2) {
            this.commitAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.isNestedUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.release();
    }

    public void commitAndResume() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            throw ValidationException.cannotCommitAndResumeSynchronizedUOW(this);
        }
        if (this.getLifecycle() == 2) {
            this.commitAndResumeAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.getParent().isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    public void commitAndResumeWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.getParent().isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWorkWithPreBuiltChangeSet(uowChangeSet);
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    public void commitAndResumeOnFailure() throws DatabaseException, OptimisticLockException {
        IdentityMapManager failureManager = (IdentityMapManager)this.getIdentityMapAccessorInstance().getIdentityMapManager().clone();
        try {
            this.commitAndResume();
        }
        catch (RuntimeException exception) {
            this.setUnitOfWorkChangeSet(null);
            this.getIdentityMapAccessorInstance().setIdentityMapManager(failureManager);
            this.log(2, "transaction", "resuming_unit_of_work_from_failure");
            throw exception;
        }
    }

    protected void commitAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.setDead();
        this.release();
    }

    protected void commitAndResumeAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    protected boolean commitInternallyStartedExternalTransaction() {
        boolean committed = false;
        if (!this.getParent().isInTransaction() || this.wasTransactionBegunPrematurely() && this.getParent().getTransactionMutex().getDepth() == 1) {
            committed = this.getParent().commitExternalTransaction();
        }
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitNestedUnitOfWork() {
        this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
        try {
            if (this.getUnitOfWorkChangeSet() == null) {
                this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
            }
            this.unitOfWorkChangeSet = this.calculateChanges(this.collectAndPrepareObjectsForNestedMerge(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), false);
            this.resetAllCloneCollection();
            this.mergeChangesIntoParent();
            if (this.hasDeletedObjects()) {
                for (Object deletedObject : this.getDeletedObjects().keySet()) {
                    Object originalObject = this.getOriginalVersionOfObject(deletedObject);
                    if (originalObject != null && ((UnitOfWorkImpl)this.getParent()).getNewObjectsCloneToOriginal().containsKey(originalObject)) {
                        ((UnitOfWorkImpl)this.getParent()).unregisterObject(originalObject);
                        continue;
                    }
                    ((UnitOfWorkImpl)this.getParent()).getDeletedObjects().put(originalObject, this.keyFromObject(originalObject));
                }
            }
            if (this.hasRemovedObjects()) {
                Iterator removedObjects = this.getRemovedObjects().values().iterator();
                while (removedObjects.hasNext()) {
                    ((UnitOfWorkImpl)this.getParent()).getCloneMapping().remove(removedObjects.next());
                }
            }
        }
        finally {
            this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
        }
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(true);
        this.mergeChangesIntoParent();
        this.changeTrackedHardList = new IdentityHashSet();
    }

    public void commitRootUnitOfWorkWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet) throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithPreBuiltChangeSet(uowChangeSet, true);
        this.mergeChangesIntoParent();
    }

    protected void commitToDatabase(boolean commitTransaction) {
        block20: {
            try {
                Iterator objects;
                if (this.wasTransactionBegunPrematurely()) {
                    this.setWasTransactionBegunPrematurely(false);
                } else {
                    this.beginTransaction();
                }
                if (commitTransaction) {
                    this.setWasNonObjectLevelModifyQueryExecuted(false);
                }
                Vector deletedObjects = null;
                if (this.hasDeletedObjects()) {
                    deletedObjects = new Vector(this.getDeletedObjects().size());
                    objects = this.getDeletedObjects().keySet().iterator();
                    while (objects.hasNext()) {
                        deletedObjects.addElement(objects.next());
                    }
                }
                if (this.shouldPerformDeletesFirst) {
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(deletedObjects);
                        objects = this.getObjectsDeletedDuringCommit().keySet().iterator();
                        while (objects.hasNext()) {
                            ObjectChangeSet objectChangeSet = (ObjectChangeSet)this.unitOfWorkChangeSet.getObjectChangeSetForClone(objects.next());
                            if (objectChangeSet == null) continue;
                            objectChangeSet.clear();
                        }
                    }
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    this.issueModifyAllQueryList();
                } else {
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(deletedObjects);
                    }
                    this.issueModifyAllQueryList();
                }
                this.getEventManager().prepareUnitOfWork();
                if (commitTransaction) {
                    try {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase()) {
                            this.setMergeManager(new MergeManager(this));
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                        }
                        this.commitTransaction();
                        break block20;
                    }
                    catch (RuntimeException throwable) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw throwable;
                    }
                    catch (Error throwable) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw throwable;
                    }
                }
                this.setWasTransactionBegunPrematurely(true);
            }
            catch (RuntimeException exception) {
                this.copyStatementsCountIntoProperties();
                this.rollbackTransaction(commitTransaction);
                if (this.hasExceptionHandler()) {
                    this.getExceptionHandler().handleException(exception);
                }
                throw exception;
            }
        }
    }

    protected void commitToDatabaseWithChangeSet(boolean commitTransaction) throws DatabaseException, OptimisticLockException {
        try {
            this.startOperationProfile("UnitOfWorkCommits");
            try {
                this.getCommitManager().setIsActive(true);
                if (this.getUnitOfWorkChangeSet() == null) {
                    this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
                }
                this.calculateChanges(new IdentityHashMap(this.getCloneMapping()), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), true);
            }
            catch (RuntimeException exception) {
                this.copyStatementsCountIntoProperties();
                throw exception;
            }
            if (this.hasModifications()) {
                this.commitToDatabase(commitTransaction);
            } else {
                try {
                    if (this.wasTransactionBegunPrematurely() && commitTransaction) {
                        this.setWasTransactionBegunPrematurely(false);
                        this.setWasNonObjectLevelModifyQueryExecuted(false);
                        this.commitTransaction();
                    }
                    this.getCommitManager().setIsActive(false);
                }
                catch (RuntimeException exception) {
                    this.copyStatementsCountIntoProperties();
                    throw exception;
                }
            }
            this.endOperationProfile("UnitOfWorkCommits");
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    protected void commitToDatabaseWithPreBuiltChangeSet(UnitOfWorkChangeSet uowChangeSet, boolean commitTransaction) throws DatabaseException, OptimisticLockException {
        try {
            uowChangeSet.setIsChangeSetFromOutsideUOW(true);
            this.getCommitManager().setIsActive(true);
            this.setUnitOfWorkChangeSet(uowChangeSet);
            this.commitToDatabase(commitTransaction);
            uowChangeSet.setIsChangeSetFromOutsideUOW(false);
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
    }

    public void commitTransaction() throws DatabaseException {
        this.getParent().commitTransaction();
    }

    protected void commitTransactionAfterWriteChanges() {
        this.setWasNonObjectLevelModifyQueryExecuted(false);
        if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
            try {
                this.setWasTransactionBegunPrematurely(false);
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getUnitOfWorkChangeSet() != null) {
                    this.setMergeManager(new MergeManager(this));
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                }
                this.commitTransaction();
            }
            catch (RuntimeException exception) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                this.rollbackTransaction();
                this.release();
                this.handleException(exception);
            }
            catch (Error throwable) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                throw throwable;
            }
        }
    }

    public Vector copyReadOnlyClasses() {
        return Helper.buildVectorFromHashtableElements(this.getReadOnlyClasses());
    }

    public Object deepMergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 3);
    }

    public Object deepRevertObject(Object clone) {
        return this.revertObject(clone, 3);
    }

    public void deepUnregisterObject(Object clone) {
        this.unregisterObject(clone, 3);
    }

    public void deleteAllObjects(Vector domainObjects) {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.deleteObject(objectsEnum.nextElement());
        }
    }

    protected void discoverAllUnregisteredNewObjects() {
        IdentityHashMap visitedNodes = new IdentityHashMap();
        IdentityHashMap newObjects = new IdentityHashMap();
        IdentityHashMap existingObjects = new IdentityHashMap();
        this.discoverUnregisteredNewObjects(new IdentityHashMap(this.getCloneMapping()), newObjects, existingObjects, visitedNodes);
        this.setUnregisteredNewObjects(newObjects);
        this.setUnregisteredExistingObjects(existingObjects);
    }

    protected void discoverAllUnregisteredNewObjectsInParent() {
        if (this.isNestedUnitOfWork()) {
            IdentityHashMap visitedNodes = new IdentityHashMap();
            IdentityHashMap newObjects = new IdentityHashMap();
            UnitOfWorkImpl parent = (UnitOfWorkImpl)this.getParent();
            parent.discoverUnregisteredNewObjects(((UnitOfWorkImpl)this.getParent()).getCloneMapping(), newObjects, new IdentityHashMap(), visitedNodes);
            this.setUnregisteredNewObjectsInParent(newObjects);
        }
    }

    public void discoverUnregisteredNewObjects(Map clones, final Map knownNewObjects, final Map unregisteredExistingObjects, Map visitedObjects) {
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                if (UnitOfWorkImpl.isSmartMerge() && UnitOfWorkImpl.this.isOriginalNewObject(object)) {
                    return;
                }
                if (!UnitOfWorkImpl.this.isObjectRegistered(object)) {
                    if (UnitOfWorkImpl.this.shouldPerformNoValidation() && (!UnitOfWorkImpl.this.shouldValidateExistence() || UnitOfWorkImpl.this.checkForUnregisteredExistingObject(object))) {
                        unregisteredExistingObjects.put(object, object);
                        this.setShouldBreak(true);
                        return;
                    }
                    knownNewObjects.put(object, object);
                }
            }
        };
        this.setUnregisteredExistingObjects(unregisteredExistingObjects);
        iterator.setVisitedObjects(visitedObjects);
        iterator.setResult(knownNewObjects);
        iterator.setSession(this);
        iterator.setShouldIterateOverWrappedObjects(false);
        Iterator clonesEnum = clones.keySet().iterator();
        while (clonesEnum.hasNext()) {
            iterator.startIterationOn(clonesEnum.next());
        }
    }

    public void dontPerformValidation() {
        this.setValidationLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Accessor accessor = query.getSessionName() == null ? query.getSession().getAccessor(query.getReferenceClass()) : query.getSession().getAccessor(query.getSessionName());
        query.setAccessor(accessor);
        try {
            Object object = query.getAccessor().executeCall(call, translationRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                query.setAccessor(null);
            }
        }
    }

    public void forceUpdateToVersionField(Object lockObject, boolean shouldModifyVersionField) {
        ClassDescriptor descriptor = this.getDescriptor(lockObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(lockObject.getClass().toString());
        }
        this.getOptimisticReadLockObjects().put(descriptor.getObjectBuilder().unwrapObject(lockObject, this), shouldModifyVersionField);
    }

    public Accessor getAccessor() {
        return this.getParent().getAccessor();
    }

    public CommitManager getCommitManager() {
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
            this.commitManager.setCommitOrder(this.getParent().getCommitManager().getCommitOrder());
        }
        return this.commitManager;
    }

    public Accessor getAccessor(Class domainClass) {
        return this.getParent().getAccessor(domainClass);
    }

    public Accessor getAccessor(String sessionName) {
        return this.getParent().getAccessor(sessionName);
    }

    public UnitOfWork getActiveUnitOfWork() {
        return this.getParent().getActiveUnitOfWork();
    }

    public Vector getAllFromNewObjects(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, int valueHolderPolicy) {
        if (this.shouldNewObjectsBeCached() && selectionCriteria != null) {
            return new Vector(1);
        }
        if (!this.hasNewObjects()) {
            return new Vector(1);
        }
        Vector objects = new Vector();
        for (Object object : this.getNewObjectsOriginalToClone().values()) {
            if (!theClass.isInstance(object)) continue;
            if (selectionCriteria == null) {
                objects.addElement(object);
                continue;
            }
            if (!selectionCriteria.doesConform(object, this, translationRow, valueHolderPolicy)) continue;
            objects.addElement(object);
        }
        return objects;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getBackupClone(Object clone) throws QueryException {
        void var2_5;
        Object v = this.getCloneMapping().get(clone);
        if (v != null) {
            return v;
        }
        if (this.isObjectRegistered(clone)) {
            return this.getCloneMapping().get(clone);
        }
        ClassDescriptor descriptor = this.getDescriptor(clone);
        Vector primaryKey = this.keyFromObject(clone, descriptor);
        if (this.getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, clone.getClass(), descriptor)) {
            if (this.getUnregisteredNewObjects().get(clone) != null && this.isMergePending()) {
                return descriptor.getObjectBuilder().buildNewInstance();
            }
            if (!this.hasObjectsDeletedDuringCommit() || !this.getObjectsDeletedDuringCommit().containsKey(clone)) throw QueryException.backupCloneIsOriginalFromParent(clone);
            throw QueryException.backupCloneIsDeleted(clone);
        }
        if (this.hasNewObjects() && this.getNewObjectsOriginalToClone().containsKey(clone)) {
            if (!UnitOfWorkImpl.isSmartMerge()) throw QueryException.backupCloneIsOriginalFromSelf(clone);
            Object v2 = this.getCloneMapping().get(this.getNewObjectsOriginalToClone().get(clone));
            return var2_5;
        } else {
            Object object = descriptor.getObjectBuilder().buildNewInstance();
        }
        return var2_5;
    }

    public Object getBackupCloneForCommit(Object clone) {
        Object backupClone = this.getBackupClone(clone);
        if (this.isCloneNewObject(clone)) {
            return this.getDescriptor(clone).getObjectBuilder().buildNewInstance();
        }
        return backupClone;
    }

    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getCurrentChanges() {
        Map allObjects = this.collectAndPrepareObjectsForNestedMerge();
        return this.calculateChanges(allObjects, new UnitOfWorkChangeSet(), false);
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        if (canReturnSelf && !terminalOnly) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(query, true, terminalOnly);
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        return this.getParent().getExecutionSession(query);
    }

    public Map getCloneMapping() {
        if (this.cloneMapping == null) {
            this.cloneMapping = this.createMap();
        }
        return this.cloneMapping;
    }

    protected boolean hasCloneMapping() {
        return this.cloneMapping != null && !this.cloneMapping.isEmpty();
    }

    public Map getCloneToOriginals() {
        if (this.cloneToOriginals == null) {
            this.cloneToOriginals = this.createMap();
        }
        return this.cloneToOriginals;
    }

    protected boolean hasCloneToOriginals() {
        return this.cloneToOriginals != null && !this.cloneToOriginals.isEmpty();
    }

    public Map getContainerBeans() {
        if (this.containerBeans == null) {
            this.containerBeans = new IdentityHashMap();
        }
        return this.containerBeans;
    }

    public boolean hasContainerBeans() {
        return this.containerBeans != null && !this.containerBeans.isEmpty();
    }

    public boolean hasNewObjects() {
        return this.newObjectsOriginalToClone != null && !this.newObjectsOriginalToClone.isEmpty();
    }

    public UnitOfWorkImpl getContainerUnitOfWork() {
        if (this.containerUnitOfWork == null) {
            this.containerUnitOfWork = this.getParent().acquireNonSynchronizedUnitOfWork(ReferenceMode.WEAK);
        }
        return this.containerUnitOfWork;
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.getParent().getDefaultReadOnlyClasses();
    }

    public Map getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashMap();
        }
        return this.deletedObjects;
    }

    public boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public int getLifecycle() {
        return this.lifecycle;
    }

    public MergeManager getMergeManager() {
        return this.lastUsedMergeManager;
    }

    public Map getNewAggregates() {
        if (this.newAggregates == null) {
            this.newAggregates = new IdentityHashMap();
        }
        return this.newAggregates;
    }

    public synchronized Map getNewObjectsCloneToOriginal() {
        if (this.newObjectsCloneToOriginal == null) {
            this.newObjectsCloneToOriginal = new IdentityHashMap();
        }
        return this.newObjectsCloneToOriginal;
    }

    public Map getNewObjectsInParentOriginalToClone() {
        if (this.newObjectsInParentOriginalToClone == null) {
            this.newObjectsInParentOriginalToClone = new IdentityHashMap();
        }
        return this.newObjectsInParentOriginalToClone;
    }

    protected boolean hasNewObjectsInParentOriginalToClone() {
        return this.newObjectsInParentOriginalToClone != null && !this.newObjectsInParentOriginalToClone.isEmpty();
    }

    public boolean hasOptimisticReadLockObjects() {
        return this.optimisticReadLockObjects != null && !this.optimisticReadLockObjects.isEmpty();
    }

    public synchronized Map getNewObjectsOriginalToClone() {
        if (this.newObjectsOriginalToClone == null) {
            this.newObjectsOriginalToClone = new IdentityHashMap();
        }
        return this.newObjectsOriginalToClone;
    }

    public Sequencing getSequencing() {
        return this.getParent().getSequencing();
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public String getSessionTypeString() {
        return "UnitOfWork";
    }

    public void afterExternalTransactionRollback() {
        this.getParent().setWasJTSTransactionInternallyStarted(false);
        this.setLifecycle(6);
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
    }

    public void releaseJTSConnection() {
        this.getParent().releaseJTSConnection();
    }

    public Object getObjectFromNewObjects(Class theClass, Vector selectionKey) {
        if (!this.hasNewObjects()) {
            return null;
        }
        ObjectBuilder objectBuilder = this.getDescriptor(theClass).getObjectBuilder();
        for (Object object : this.getNewObjectsOriginalToClone().values()) {
            Vector primaryKey;
            if (!theClass.isInstance(object) || !new CacheKey(primaryKey = objectBuilder.extractPrimaryKeyFromObject(object, this)).equals(new CacheKey(selectionKey))) continue;
            return object;
        }
        return null;
    }

    public Object getObjectFromNewObjects(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, int valueHolderPolicy) {
        if (!this.hasNewObjects()) {
            return null;
        }
        for (Object object : this.getNewObjectsOriginalToClone().values()) {
            if (!theClass.isInstance(object)) continue;
            if (selectionCriteria == null) {
                return object;
            }
            if (!selectionCriteria.doesConform(object, this, translationRow, valueHolderPolicy)) continue;
            return object;
        }
        return null;
    }

    public Map getObjectsDeletedDuringCommit() {
        if (this.objectsDeletedDuringCommit == null) {
            this.objectsDeletedDuringCommit = new IdentityHashMap();
        }
        return this.objectsDeletedDuringCommit;
    }

    protected boolean hasObjectsDeletedDuringCommit() {
        return this.objectsDeletedDuringCommit != null && !this.objectsDeletedDuringCommit.isEmpty();
    }

    public Hashtable getOptimisticReadLockObjects() {
        if (this.optimisticReadLockObjects == null) {
            this.optimisticReadLockObjects = new Hashtable(2);
        }
        return this.optimisticReadLockObjects;
    }

    public Object getOriginalVersionOfNewObject(Object workingClone) {
        if (!this.hasNewObjects()) {
            return null;
        }
        return this.getNewObjectsCloneToOriginal().get(workingClone);
    }

    public Object getOriginalVersionOfObject(Object workingClone) {
        if (workingClone == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        Vector primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object original = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
        if (original == null) {
            original = this.getOriginalVersionOfNewObject(implementation);
        }
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        if (original == null) {
            original = this.buildOriginal(implementation);
        }
        return original;
    }

    public Object getOriginalVersionOfObjectOrNull(Object workingClone, ObjectChangeSet changeSet, ClassDescriptor descriptor) {
        if (workingClone == null) {
            return null;
        }
        Object original = null;
        CacheKey cacheKey = null;
        if (changeSet != null && (cacheKey = changeSet.getActiveCacheKey()) != null && (original = cacheKey.getObject()) != null) {
            return original;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        if (cacheKey == null) {
            Vector primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
            original = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
        }
        if (original == null) {
            original = this.getOriginalVersionOfNewObject(implementation);
        }
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        return original;
    }

    public Object getOriginalVersionOfObjectOrNull(Object workingClone, ClassDescriptor descriptor) {
        if (workingClone == null) {
            return null;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(workingClone, this);
        Vector primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object original = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
        if (original == null) {
            original = this.getOriginalVersionOfNewObject(implementation);
        }
        if (original == null) {
            if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
                return implementation;
            }
            if (this.hasCloneToOriginals()) {
                original = this.getCloneToOriginals().get(workingClone);
            }
        }
        return original;
    }

    public AbstractSession getParent() {
        return this.parent;
    }

    public Object getProperty(String name) {
        Object propertyValue = super.getProperties().get(name);
        if (propertyValue == null) {
            propertyValue = this.getParent().getProperty(name);
        }
        return propertyValue;
    }

    public Platform getPlatform(Class domainClass) {
        return this.getParent().getPlatform(domainClass);
    }

    public int getShouldThrowConformExceptions() {
        return this.shouldThrowConformExceptions;
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        DatabaseQuery query = super.getQuery(name, arguments);
        if (query == null) {
            query = this.getParent().getQuery(name, arguments);
        }
        return query;
    }

    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (query == null) {
            query = this.getParent().getQuery(name);
        }
        return query;
    }

    public Hashtable getReadOnlyClasses() {
        return this.readOnlyClasses;
    }

    protected Map getRemovedObjects() {
        if (this.removedObjects == null) {
            this.removedObjects = new IdentityHashMap();
        }
        return this.removedObjects;
    }

    protected boolean hasRemovedObjects() {
        return this.removedObjects != null && !this.removedObjects.isEmpty();
    }

    protected boolean hasModifyAllQueries() {
        return this.modifyAllQueries != null && !this.modifyAllQueries.isEmpty();
    }

    protected boolean hasDeferredModifyAllQueries() {
        return this.deferredModifyAllQueries != null && !this.deferredModifyAllQueries.isEmpty();
    }

    public int getState() {
        return this.lifecycle;
    }

    public ObjectTracker getObjectTracker() {
        return this.objectTracker;
    }

    public void setObjectTracker(ObjectTracker objectTracker) {
        this.objectTracker = objectTracker;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Object transaction) {
        this.transaction = transaction;
    }

    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getUnitOfWorkChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public Map getUnregisteredExistingObjects() {
        if (this.unregisteredExistingObjects == null) {
            this.unregisteredExistingObjects = new IdentityHashMap();
        }
        return this.unregisteredExistingObjects;
    }

    protected Map getUnregisteredNewObjects() {
        if (this.unregisteredNewObjects == null) {
            this.unregisteredNewObjects = new IdentityHashMap();
        }
        return this.unregisteredNewObjects;
    }

    protected Map getUnregisteredNewObjectsInParent() {
        if (this.unregisteredNewObjectsInParent == null) {
            this.unregisteredNewObjectsInParent = new IdentityHashMap();
        }
        return this.unregisteredNewObjectsInParent;
    }

    public int getValidationLevel() {
        return this.validationLevel;
    }

    public boolean hasChanges() {
        if (this.hasNewObjects()) {
            return true;
        }
        if (this.hasDeletedObjects()) {
            return true;
        }
        IdentityHashMap allObjects = new IdentityHashMap(this.getCloneMapping());
        UnitOfWorkChangeSet changeSet = this.calculateChanges(allObjects, new UnitOfWorkChangeSet(), false);
        return changeSet.hasChanges();
    }

    protected boolean hasModifications() {
        return this.getUnitOfWorkChangeSet().hasChanges() || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries() || ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).hasForcedChanges();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new UnitOfWorkIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord databaseRow) throws DatabaseException, QueryException {
        return query.executeInUnitOfWork(this, databaseRow);
    }

    public Object internalRegisterObject(Object object, ClassDescriptor descriptor) {
        if (object == null) {
            return null;
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object registeredObject = this.checkIfAlreadyRegistered(object, descriptor);
        if (registeredObject == null) {
            UnitOfWorkImpl parentUnitOfWork;
            if (this.isNestedUnitOfWork() && ((parentUnitOfWork = (UnitOfWorkImpl)this.getParent()).isObjectRegistered(object) || this.isUnregisteredNewObjectInParent(object))) {
                Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                registeredObject = this.isCloneNewObjectFromParent(object) || this.isUnregisteredNewObjectInParent(object) ? this.cloneAndRegisterObject(object, new CacheKey(primaryKey), new CacheKey(primaryKey), descriptor) : this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, descriptor.getJavaClass(), descriptor);
                return registeredObject;
            }
            registeredObject = this.checkExistence(object);
            if (registeredObject == null) {
                registeredObject = this.cloneAndRegisterNewObject(object);
            }
        }
        return registeredObject;
    }

    public boolean isActive() {
        return !this.isDead();
    }

    public boolean isClassReadOnly(Class theClass, ClassDescriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        return theClass != null && this.getReadOnlyClasses().containsKey(theClass);
    }

    public boolean isCloneNewObjectFromParent(Object clone) {
        if (this.getParent().isUnitOfWork()) {
            if (((UnitOfWorkImpl)this.getParent()).isCloneNewObject(clone)) {
                return true;
            }
            if (((UnitOfWorkImpl)this.getParent()).isObjectRegistered(clone)) {
                clone = ((UnitOfWorkImpl)this.getParent()).getCloneToOriginals().get(clone);
            }
            return ((UnitOfWorkImpl)this.getParent()).isCloneNewObjectFromParent(clone);
        }
        return false;
    }

    public boolean isCloneNewObject(Object clone) {
        if (!this.hasNewObjects()) {
            return false;
        }
        return this.getNewObjectsCloneToOriginal().containsKey(clone);
    }

    public boolean isCommitPending() {
        return this.getLifecycle() == 1;
    }

    public boolean isDead() {
        return this.getLifecycle() == 5;
    }

    public boolean isInTransaction() {
        return this.getParent().isInTransaction();
    }

    public boolean isMergePending() {
        return this.getLifecycle() == 4;
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2 || this.getLifecycle() == 3;
    }

    protected boolean isAfterWriteChangesFailed() {
        return this.getLifecycle() == 3;
    }

    public boolean isNestedUnitOfWork() {
        return this.isNestedUnitOfWork;
    }

    public boolean isNewObjectInParent(Object clone) {
        Object original = null;
        if (this.hasCloneToOriginals()) {
            original = this.getCloneToOriginals().get(clone);
        }
        if (original != null) {
            return ((UnitOfWorkImpl)this.getParent()).getNewObjectsCloneToOriginal().containsKey(original);
        }
        return false;
    }

    public boolean isObjectDeleted(Object object) {
        boolean isDeleted = false;
        if (this.hasDeletedObjects()) {
            isDeleted = this.getDeletedObjects().containsKey(object);
        }
        if (this.getParent().isUnitOfWork()) {
            return isDeleted || ((UnitOfWorkImpl)this.getParent()).isObjectDeleted(object);
        }
        return isDeleted;
    }

    public boolean isObjectNew(Object clone) {
        return this.isCloneNewObject(clone) || !this.isObjectRegistered(clone) && !this.getReadOnlyClasses().containsKey(clone.getClass()) && !this.getUnregisteredExistingObjects().containsKey(clone);
    }

    public boolean isObjectRegistered(Object clone) {
        if (this.getCloneMapping().containsKey(clone)) {
            return true;
        }
        if (UnitOfWorkImpl.isSmartMerge()) {
            ClassDescriptor descriptor = this.getDescriptor(clone);
            if (this.getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(this.keyFromObject(clone, descriptor), clone.getClass(), descriptor)) {
                this.mergeCloneWithReferences(clone);
                return true;
            }
        }
        return false;
    }

    public boolean isOriginalNewObject(Object original) {
        return this.hasNewObjects() && this.getNewObjectsOriginalToClone().containsKey(original) || this.getNewAggregates().containsKey(original);
    }

    public static boolean isSmartMerge() {
        return SmartMerge;
    }

    public void issueSQLbeforeCompletion() {
        this.issueSQLbeforeCompletion(true);
    }

    public void issueSQLbeforeCompletion(boolean commitTransaction) {
        if (this.getLifecycle() == 2) {
            this.commitTransactionAfterWriteChanges();
            return;
        }
        this.mergeBmpAndWsEntities();
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        this.commitToDatabaseWithChangeSet(commitTransaction);
    }

    protected void issueModifyAllQueryList() {
        if (this.deferredModifyAllQueries != null) {
            for (int i = 0; i < this.deferredModifyAllQueries.size(); ++i) {
                Object[] queries = (Object[])this.deferredModifyAllQueries.get(i);
                ModifyAllQuery query = (ModifyAllQuery)queries[0];
                AbstractRecord translationRow = (AbstractRecord)queries[1];
                this.getParent().executeQuery((DatabaseQuery)query, translationRow);
            }
        }
    }

    public boolean isUnitOfWork() {
        return true;
    }

    public boolean isUnregisteredNewObjectInParent(Object originalObject) {
        return this.getUnregisteredNewObjectsInParent().containsKey(originalObject);
    }

    protected void mergeBmpAndWsEntities() {
        if (this.hasContainerBeans()) {
            Iterator containerBeansEnum = this.getContainerBeans().keySet().iterator();
            while (containerBeansEnum.hasNext()) {
                this.mergeCloneWithReferences(containerBeansEnum.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeChangesIntoParent() {
        block26: {
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            if (this.hasModifications()) {
                this.setPendingMerge();
                this.startOperationProfile("merge");
                this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
                MergeManager manager = this.getMergeManager();
                if (manager == null) {
                    manager = new MergeManager(this);
                }
                try {
                    Object objectToWrite;
                    boolean isNestedUnitOfWork = this.isNestedUnitOfWork();
                    if (!isNestedUnitOfWork) {
                        this.preMergeChanges();
                    }
                    this.getParent().getEventManager().preMergeUnitOfWorkChangeSet(uowChangeSet);
                    if (!isNestedUnitOfWork && this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWrite()) {
                        this.setMergeManager(manager);
                        this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                    }
                    Enumeration changeSetLists = ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getObjectChanges().elements();
                    block9: while (changeSetLists.hasMoreElements()) {
                        Hashtable objectChangesList = (Hashtable)((Hashtable)changeSetLists.nextElement()).clone();
                        if (objectChangesList == null) continue;
                        Enumeration pendingEnum = objectChangesList.elements();
                        while (pendingEnum.hasMoreElements()) {
                            ObjectChangeSet changeSetToWrite = (ObjectChangeSet)pendingEnum.nextElement();
                            if (changeSetToWrite.hasChanges()) {
                                objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                                ClassDescriptor descriptor = this.getDescriptor(objectToWrite);
                                if (!isNestedUnitOfWork && descriptor.shouldIsolateObjectsInUnitOfWork()) continue block9;
                                manager.mergeChanges(objectToWrite, changeSetToWrite);
                                continue;
                            }
                            uowChangeSet.removeObjectChangeSet(changeSetToWrite);
                        }
                    }
                    if (this.modifyAllQueries != null) {
                        for (int i = 0; i < this.modifyAllQueries.size(); ++i) {
                            ModifyAllQuery query = (ModifyAllQuery)this.modifyAllQueries.get(i);
                            query.setSession(this.getParent());
                            query.mergeChangesIntoSharedCache();
                        }
                    }
                    if (isNestedUnitOfWork) {
                        changeSetLists = ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().elements();
                        while (changeSetLists.hasMoreElements()) {
                            IdentityHashMap objectChangesList = new IdentityHashMap((Map)changeSetLists.nextElement());
                            if (objectChangesList == null) continue;
                            for (ObjectChangeSet changeSetToWrite : objectChangesList.values()) {
                                if (changeSetToWrite.hasChanges()) {
                                    objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                                    manager.mergeChanges(objectToWrite, changeSetToWrite);
                                    continue;
                                }
                                uowChangeSet.removeObjectChangeSet(changeSetToWrite);
                            }
                        }
                    }
                    if (isNestedUnitOfWork) break block26;
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(manager);
                    this.setMergeManager(null);
                    this.postMergeChanges();
                    if (!this.getParent().shouldPropagateChanges() || this.getParent().getCommandManager() == null) break block26;
                    if (this.hasDeletedObjects()) {
                        uowChangeSet.addDeletedObjects(this.getDeletedObjects(), this);
                    }
                    if (this.hasObjectsDeletedDuringCommit()) {
                        uowChangeSet.addDeletedObjects(this.getObjectsDeletedDuringCommit(), this);
                    }
                    boolean hasData = false;
                    if (!uowChangeSet.hasChanges()) break block26;
                    MergeChangeSetCommand command = new MergeChangeSetCommand();
                    command.setChangeSet(uowChangeSet);
                    try {
                        hasData = command.convertChangeSetToByteArray(this);
                    }
                    catch (IOException exception) {
                        throw CommunicationException.unableToPropagateChanges(command.getServiceId().getId(), exception);
                    }
                    if (hasData) {
                        this.getParent().getCommandManager().propagateCommand(command);
                    }
                }
                finally {
                    if (!this.isNestedUnitOfWork() && !manager.getAcquiredLocks().isEmpty()) {
                        try {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(manager);
                        }
                        catch (Exception exception) {}
                        this.setMergeManager(null);
                    }
                    this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
                    this.getParent().getEventManager().postMergeUnitOfWorkChangeSet(uowChangeSet);
                    this.endOperationProfile("merge");
                }
            }
        }
    }

    public Object mergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 2);
    }

    public Object mergeClone(Object rmiClone, int cascadeDepth) {
        if (rmiClone == null) {
            return null;
        }
        this.logDebugMessage(rmiClone, "merge_clone");
        this.startOperationProfile("merge");
        ObjectBuilder builder = this.getDescriptor(rmiClone).getObjectBuilder();
        Object implementation = builder.unwrapObject(rmiClone, this);
        MergeManager manager = new MergeManager(this);
        manager.mergeCloneIntoWorkingCopy();
        manager.setCascadePolicy(cascadeDepth);
        Object merged = null;
        try {
            merged = manager.mergeChanges(implementation, null);
        }
        catch (RuntimeException exception) {
            merged = this.handleException(exception);
        }
        this.endOperationProfile("merge");
        return merged;
    }

    public void mergeClonesAfterCompletion() {
        if (!CMPPolicy.OPTIMIZE_PESSIMISTIC_CMP) {
            this.mergeChangesIntoParent();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
    }

    public Object mergeCloneWithReferences(Object rmiClone) {
        return this.mergeCloneWithReferences(rmiClone, 2);
    }

    public Object mergeCloneWithReferences(Object rmiClone, int cascadePolicy) {
        return this.mergeCloneWithReferences(rmiClone, cascadePolicy, false);
    }

    public Object mergeCloneWithReferences(Object rmiClone, int cascadePolicy, boolean forceCascade) {
        MergeManager manager = new MergeManager(this);
        manager.mergeCloneWithReferencesIntoWorkingCopy();
        manager.setCascadePolicy(cascadePolicy);
        manager.setForceCascade(forceCascade);
        return this.mergeCloneWithReferences(rmiClone, manager);
    }

    public Object mergeCloneWithReferences(Object rmiClone, MergeManager manager) {
        if (rmiClone == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(rmiClone);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            if (manager.getCascadePolicy() == 4) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{rmiClone}));
            }
            return rmiClone;
        }
        this.logDebugMessage(rmiClone, "merge_clone_with_references");
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(rmiClone, this);
        Object mergedObject = manager.mergeChanges(implementation, null);
        if (UnitOfWorkImpl.isSmartMerge()) {
            return builder.wrapObject(mergedObject, this);
        }
        return mergedObject;
    }

    public Object newInstance(Class theClass) {
        this.logDebugMessage(theClass, "new_instance");
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        Object newObject = descriptor.getObjectBuilder().buildNewInstance();
        return this.registerObject(newObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRemove(Object toBeDeleted, Map visitedObjects) {
        try {
            if (toBeDeleted == null) {
                return;
            }
            ClassDescriptor descriptor = this.getDescriptor(toBeDeleted);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{toBeDeleted}));
            }
            this.logDebugMessage(toBeDeleted, "deleting_object");
            this.startOperationProfile("deleted object");
            if (this.getDeletedObjects().containsKey(toBeDeleted)) {
                return;
            }
            visitedObjects.put(toBeDeleted, toBeDeleted);
            Object registeredObject = this.checkIfAlreadyRegistered(toBeDeleted, descriptor);
            if (registeredObject == null) {
                Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(toBeDeleted, this);
                DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
                existQuery = (DoesExistQuery)existQuery.clone();
                existQuery.setObject(toBeDeleted);
                existQuery.setPrimaryKey(primaryKey);
                existQuery.setDescriptor(descriptor);
                existQuery.setIsExecutionClone(true);
                existQuery.setCheckCacheFirst(true);
                if (((Boolean)this.executeQuery(existQuery)).booleanValue()) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_remove_detatched_entity", new Object[]{toBeDeleted}));
                }
            } else {
                if (descriptor.getEventManager().hasAnyEventListeners()) {
                    DescriptorEvent event = new DescriptorEvent(toBeDeleted);
                    event.setEventCode(16);
                    event.setSession(this);
                    descriptor.getEventManager().executeEvent(event);
                }
                if (this.hasNewObjects() && this.getNewObjectsCloneToOriginal().containsKey(registeredObject)) {
                    this.unregisterObject(registeredObject, 1);
                } else {
                    this.getDeletedObjects().put(toBeDeleted, toBeDeleted);
                }
            }
            descriptor.getObjectBuilder().cascadePerformRemove(toBeDeleted, this, visitedObjects);
        }
        finally {
            this.endOperationProfile("deleted object");
        }
    }

    public void performFullValidation() {
        this.setValidationLevel(2);
    }

    public void performPartialValidation() {
        this.setValidationLevel(1);
    }

    protected void populateAndRegisterObject(Object original, Object workingClone, CacheKey unitOfWorkCacheKey, CacheKey parentCacheKey, ClassDescriptor descriptor) {
        unitOfWorkCacheKey.setObject(workingClone);
        unitOfWorkCacheKey.setReadTime(parentCacheKey.getReadTime());
        unitOfWorkCacheKey.setWriteLockValue(parentCacheKey.getWriteLockValue());
        descriptor.getObjectChangePolicy().setChangeListener(workingClone, this, descriptor);
        descriptor.getObjectChangePolicy().dissableEventProcessing(workingClone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        builder.populateAttributesForClone(original, workingClone, this);
        Object backupClone = descriptor.getObjectChangePolicy().buildBackupClone(workingClone, builder, this);
        if (workingClone != backupClone) {
            this.getCloneMapping().put(workingClone, backupClone);
        }
        descriptor.getObjectChangePolicy().enableEventProcessing(workingClone);
    }

    protected void postMergeChanges() {
        if (!this.getUnitOfWorkChangeSet().getDeletedObjects().isEmpty()) {
            Map deletedObjects = this.getUnitOfWorkChangeSet().getDeletedObjects();
            for (ObjectChangeSet removedObjectChangeSet : deletedObjects.keySet()) {
                Vector primaryKeys = removedObjectChangeSet.getPrimaryKeys();
                ClassDescriptor descriptor = this.getDescriptor(removedObjectChangeSet.getClassType(this));
                if (descriptor.shouldIsolateObjectsInUnitOfWork()) continue;
                this.getParent().getIdentityMapAccessorInstance().removeFromIdentityMap(primaryKeys, descriptor.getJavaClass(), descriptor);
            }
        }
    }

    protected void preMergeChanges() {
        if (this.hasObjectsDeletedDuringCommit()) {
            for (Object removedObject : this.getObjectsDeletedDuringCommit().keySet()) {
                Object referenceObjectToRemove;
                this.getCloneMapping().remove(removedObject);
                if (!this.hasNewObjects() || (referenceObjectToRemove = this.getNewObjectsCloneToOriginal().get(removedObject)) == null) continue;
                this.getNewObjectsCloneToOriginal().remove(removedObject);
                this.getNewObjectsOriginalToClone().remove(referenceObjectToRemove);
            }
        }
    }

    public void printRegisteredObjects() {
        if (this.shouldLog(7, "cache")) {
            this.basicPrintRegisteredObjects();
        }
    }

    public Object processDeleteObjectQuery(DeleteObjectQuery deleteQuery) {
        if (deleteQuery.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(deleteQuery);
        }
        ClassDescriptor descriptor = this.getDescriptor(deleteQuery.getObject());
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(deleteQuery.getObject(), this);
        if (this.isClassReadOnly(implementation.getClass(), descriptor)) {
            throw QueryException.cannotDeleteReadOnlyObject(implementation);
        }
        if (this.isCloneNewObject(implementation)) {
            this.unregisterObject(implementation);
            return implementation;
        }
        Vector primaryKey = builder.extractPrimaryKeyFromObject(implementation, this);
        Object clone = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
        if (clone == null) {
            clone = implementation;
        }
        clone = builder.unwrapObject(clone, this);
        deleteQuery.setObject(clone);
        if (!this.getCommitManager().isActive()) {
            this.getDeletedObjects().put(clone, primaryKey);
            return clone;
        }
        if (this.hasObjectsDeletedDuringCommit() && this.getObjectsDeletedDuringCommit().containsKey(clone)) {
            return clone;
        }
        return null;
    }

    protected void basicPrintRegisteredObjects() {
        String cr = Helper.cr();
        StringWriter writer = new StringWriter();
        writer.write(LoggingLocalization.buildMessage("unitofwork_identity_hashcode", new Object[]{cr, String.valueOf(System.identityHashCode(this))}));
        if (this.hasDeletedObjects()) {
            writer.write(cr + LoggingLocalization.buildMessage("deleted_objects"));
            for (Object object : this.getDeletedObjects().keySet()) {
                writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, Helper.printVector(this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this)), "\t", String.valueOf(System.identityHashCode(object)), object}));
            }
        }
        writer.write(cr + LoggingLocalization.buildMessage("all_registered_clones"));
        for (Object object : this.getCloneMapping().keySet()) {
            writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, Helper.printVector(this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this)), "\t", String.valueOf(System.identityHashCode(object)), object}));
        }
        if (this.hasNewObjectsInParentOriginalToClone()) {
            writer.write(cr + LoggingLocalization.buildMessage("new_objects"));
            for (Object object : this.getNewObjectsCloneToOriginal().keySet()) {
                writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, Helper.printVector(this.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, this)), "\t", String.valueOf(System.identityHashCode(object)), object}));
            }
        }
        this.log(7, "transaction", writer.toString(), null, null, false);
    }

    public Vector registerAllObjects(Collection domainObjects) {
        Vector<Object> clones = new Vector<Object>(domainObjects.size());
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            clones.addElement(this.registerObject(objectsEnum.next()));
        }
        return clones;
    }

    public Vector registerAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Vector<Object> clones = new Vector<Object>(domainObjects.size());
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            clones.addElement(this.registerObject(objectsEnum.nextElement()));
        }
        return clones;
    }

    public synchronized Object registerExistingObject(Object existingObject) {
        if (existingObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(existingObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(existingObject.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return existingObject;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(existingObject, this);
        Object registeredObject = this.registerExistingObject(implementation, descriptor);
        if (implementation != existingObject) {
            return builder.wrapObject(registeredObject, this);
        }
        return registeredObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerExistingObject(Object objectToRegister, ClassDescriptor descriptor) {
        Object registeredObject;
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return objectToRegister;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerExistingObject");
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(objectToRegister.getClass());
        }
        this.logDebugMessage(objectToRegister, "register_existing");
        try {
            this.startOperationProfile("register");
            registeredObject = this.checkIfAlreadyRegistered(objectToRegister, descriptor);
            if (registeredObject == null) {
                Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToRegister, this);
                registeredObject = this.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, objectToRegister.getClass(), descriptor);
                if (registeredObject == null) {
                    CacheKey cacheKey = new CacheKey(primaryKey);
                    cacheKey.setReadTime(System.currentTimeMillis());
                    registeredObject = this.cloneAndRegisterObject(objectToRegister, cacheKey, descriptor);
                }
            }
            if (descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().shouldWriteInto(objectToRegister, registeredObject)) {
                descriptor.getFetchGroupManager().writePartialIntoClones(objectToRegister, registeredObject, this);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return registeredObject;
    }

    public synchronized Object registerNewContainerBean(Object newObject) {
        if (newObject == null) {
            return null;
        }
        this.logDebugMessage(newObject, "register_new");
        this.startOperationProfile("register");
        this.setShouldNewObjectsBeCached(true);
        ClassDescriptor descriptor = this.getDescriptor(newObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(newObject.getClass().toString());
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        if (this.shouldPerformFullValidation()) {
            Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(newObject, this);
            Object objectFromCache = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, descriptor.getJavaClass(), descriptor);
            if (objectFromCache != null) {
                throw ValidationException.wrongObjectRegistered(newObject, objectFromCache);
            }
        }
        Object original = builder.buildNewInstance();
        builder.copyInto(newObject, original);
        Object clone = this.registerObject(original);
        this.getContainerBeans().put(newObject, clone);
        this.endOperationProfile("register");
        return newObject;
    }

    public synchronized Object registerNewContainerBeanForCMP(Object newObject) {
        if (newObject == null) {
            return null;
        }
        this.logDebugMessage(newObject, "register_new_bean");
        this.startOperationProfile("register");
        Object clone = this.cloneAndRegisterNewObject(newObject);
        this.endOperationProfile("register");
        return clone;
    }

    public synchronized Object registerNewObject(Object newObject) {
        if (newObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(newObject);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(newObject.getClass().toString());
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(newObject, this);
        this.registerNewObject(implementation, descriptor);
        if (implementation == newObject) {
            return newObject;
        }
        return builder.wrapObject(implementation, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerNewObject(Object implementation, ClassDescriptor descriptor) {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerNewObject");
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(implementation.getClass());
        }
        try {
            this.logDebugMessage(implementation, "register_new");
            this.startOperationProfile("register");
            Object registeredObject = this.checkIfAlreadyRegistered(implementation, descriptor);
            if (registeredObject == null) {
                if (this.shouldPerformFullValidation()) {
                    Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(implementation, this);
                    Object objectFromCache = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, implementation.getClass(), descriptor);
                    if (objectFromCache != null) {
                        throw ValidationException.wrongObjectRegistered(implementation, objectFromCache);
                    }
                }
                ObjectBuilder builder = descriptor.getObjectBuilder();
                Object original = builder.buildNewInstance();
                Object backupClone = implementation;
                if (!descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    backupClone = builder.buildNewInstance();
                }
                this.getCloneMapping().put(implementation, backupClone);
                this.registerNewObjectClone(implementation, original, descriptor);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return implementation;
    }

    public void discoverAndPersistUnregisteredNewObjects(Object object, boolean cascadePersist, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects) {
        if (object == null) {
            return;
        }
        if (cascadePersist && this.isObjectDeleted(object)) {
            this.undeleteObject(object);
        }
        if (visitedObjects.containsKey(object)) {
            return;
        }
        visitedObjects.put(object, object);
        if (this.isObjectDeleted(object)) {
            return;
        }
        ClassDescriptor descriptor = this.getDescriptor(object);
        if (this.isClassReadOnly(object.getClass(), descriptor)) {
            return;
        }
        if (!this.isObjectRegistered(object)) {
            if (cascadePersist) {
                this.registerNotRegisteredNewObjectForPersist(object, descriptor);
                newObjects.put(object, object);
            } else {
                if (this.checkForUnregisteredExistingObject(object)) {
                    unregisteredExistingObjects.put(object, object);
                    return;
                }
                throw new IllegalStateException(ExceptionLocalization.buildMessage("new_object_found_during_commit", new Object[]{object}));
            }
        }
        descriptor.getObjectBuilder().cascadeDiscoverAndPersistUnregisteredNewObjects(object, newObjects, unregisteredExistingObjects, visitedObjects, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerNewObjectForPersist(Object newObject, Map visitedObjects) {
        if (newObject == null) {
            return;
        }
        if (visitedObjects.containsKey(newObject)) {
            return;
        }
        visitedObjects.put(newObject, newObject);
        ClassDescriptor descriptor = this.getDescriptor(newObject);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{newObject}));
        }
        this.startOperationProfile("register");
        try {
            Object registeredObject = this.checkIfAlreadyRegistered(newObject, descriptor);
            if (registeredObject == null) {
                this.registerNotRegisteredNewObjectForPersist(newObject, descriptor);
            } else if (this.isObjectDeleted(newObject)) {
                this.undeleteObject(newObject);
            }
            descriptor.getObjectBuilder().cascadeRegisterNewForCreate(newObject, this, visitedObjects);
        }
        finally {
            this.endOperationProfile("register");
        }
    }

    public boolean wasDeleted(Object original) {
        return false;
    }

    protected void registerNotRegisteredNewObjectForPersist(Object newObject, ClassDescriptor descriptor) {
        newObject.getClass();
        if (this.shouldValidateExistence()) {
            DoesExistQuery existQuery = descriptor.getQueryManager().getDoesExistQuery();
            existQuery = (DoesExistQuery)existQuery.clone();
            existQuery.setObject(newObject);
            existQuery.setDescriptor(descriptor);
            existQuery.setIsExecutionClone(true);
            if (((Boolean)this.executeQuery(existQuery)).booleanValue()) {
                throw ValidationException.cannotPersistExistingObject(newObject, this);
            }
        }
        this.logDebugMessage(newObject, "register_new_for_persist");
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object original = builder.buildNewInstance();
        Object backupClone = newObject;
        if (!descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            backupClone = builder.buildNewInstance();
        }
        this.getCloneMapping().put(newObject, backupClone);
        this.assignSequenceNumber(newObject, descriptor);
        this.registerNewObjectClone(newObject, original, descriptor);
    }

    protected void registerNewObjectClone(Object clone, Object original, ClassDescriptor descriptor) {
        this.registerNewObjectInIdentityMap(clone, original, descriptor);
        this.getNewObjectsCloneToOriginal().put(clone, original);
        this.getNewObjectsOriginalToClone().put(original, clone);
        if (descriptor.getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setEventCode(15);
            event.setSession(this);
            descriptor.getEventManager().executeEvent(event);
        }
    }

    protected void registerNewObjectInIdentityMap(Object clone, Object original, ClassDescriptor descriptor) {
        if (this.shouldNewObjectsBeCached()) {
            Class<?> cls = clone.getClass();
            boolean usesSequences = descriptor.usesSequenceNumbers();
            Vector key = this.keyFromObject(clone, descriptor);
            boolean containsNull = false;
            for (int index = 0; index < key.size(); ++index) {
                Object pkElement = key.elementAt(index);
                if (pkElement == null) {
                    containsNull = true;
                    continue;
                }
                if (!usesSequences) continue;
                containsNull = containsNull || this.getSequencing().shouldOverrideExistingValue(cls, pkElement);
            }
            if (!containsNull) {
                this.getIdentityMapAccessorInstance().putInIdentityMap(clone, key, null, 0L, descriptor);
            }
        }
    }

    public synchronized Object registerObject(Object object) {
        if (object == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(object, this);
        boolean wasWrapped = implementation != object;
        Object registeredObject = this.registerObject(implementation, descriptor);
        if (wasWrapped) {
            return builder.wrapObject(registeredObject, this);
        }
        return registeredObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerObject(Object object, ClassDescriptor descriptor) {
        Object registeredObject;
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerObject");
        }
        this.logDebugMessage(object, "register");
        try {
            this.startOperationProfile("register");
            registeredObject = this.internalRegisterObject(object, descriptor);
        }
        finally {
            this.endOperationProfile("register");
        }
        return registeredObject;
    }

    public void registerOriginalNewObjectFromNestedUnitOfWork(Object originalObject, Object backupClone, Object newInstance, ClassDescriptor descriptor) {
        this.getCloneMapping().put(originalObject, backupClone);
        this.registerNewObjectClone(originalObject, newInstance, descriptor);
    }

    public void registerWithTransactionIfRequired() {
        if (this.getParent().hasExternalTransactionController() && !this.isSynchronized()) {
            boolean hasAlreadyStarted = this.getParent().wasJTSTransactionInternallyStarted();
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
            if (!hasAlreadyStarted && this.getParent().wasJTSTransactionInternallyStarted()) {
                this.setWasTransactionBegunPrematurely(true);
            }
        }
    }

    public void release() {
        this.log(2, "transaction", "release_unit_of_work");
        this.getEventManager().preReleaseUnitOfWork();
        if (this.getLifecycle() == 2) {
            if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
                this.rollbackTransaction(false);
                this.setWasTransactionBegunPrematurely(false);
            }
        } else if (this.wasTransactionBegunPrematurely() && !this.isNestedUnitOfWork()) {
            this.rollbackTransaction();
            this.setWasTransactionBegunPrematurely(false);
        }
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
        this.setDead();
        if (this.shouldClearForCloseOnRelease()) {
            this.clearForClose(false);
        }
        this.setBatchReadObjects(null);
        this.getParent().releaseUnitOfWork(this);
        this.getEventManager().postReleaseUnitOfWork();
        if (this.getObjectTracker() != null) {
            this.getObjectTracker().releaseAllocatedObjects();
        }
    }

    public void removeAllReadOnlyClasses() throws ValidationException {
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().clear();
    }

    public void removeForceUpdateToVersionField(Object lockObject) {
        this.getOptimisticReadLockObjects().remove(lockObject);
    }

    public void removeReadOnlyClass(Class theClass) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().remove(theClass);
    }

    protected void resetAllCloneCollection() {
        this.allClones = null;
    }

    public void revertAndResume() {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "revertAndResume");
        }
        this.log(2, "transaction", "revert_unit_of_work");
        MergeManager manager = new MergeManager(this);
        manager.mergeOriginalIntoWorkingCopy();
        manager.cascadeAllParts();
        for (Object clone : new IdentityHashMap(this.getCloneMapping()).keySet()) {
            manager.mergeChanges(clone, null);
            ClassDescriptor descriptor = this.getDescriptor(clone);
            descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, this, this.getCloneMapping());
        }
        if (this.hasNewObjects()) {
            for (Object clone : this.getNewObjectsCloneToOriginal().keySet()) {
                this.getCloneMapping().remove(clone);
            }
            if (this.getUnitOfWorkChangeSet() != null) {
                ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().clear();
            }
        }
        this.setNewObjectsCloneToOriginal(null);
        this.setNewObjectsOriginalToClone(null);
        this.resetAllCloneCollection();
        this.setObjectsDeletedDuringCommit(new IdentityHashMap());
        this.setDeletedObjects(new IdentityHashMap());
        this.setRemovedObjects(new IdentityHashMap());
        this.setUnregisteredNewObjects(new IdentityHashMap());
        if (this.isNestedUnitOfWork()) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
        this.log(2, "transaction", "resume_unit_of_work");
    }

    public Object revertObject(Object clone) {
        return this.revertObject(clone, 2);
    }

    public Object revertObject(Object clone, int cascadeDepth) {
        if (clone == null) {
            return null;
        }
        this.logDebugMessage(clone, "revert");
        ClassDescriptor descriptor = this.getDescriptor(clone);
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(clone, this);
        MergeManager manager = new MergeManager(this);
        manager.mergeOriginalIntoWorkingCopy();
        manager.setCascadePolicy(cascadeDepth);
        try {
            manager.mergeChanges(implementation, null);
        }
        catch (RuntimeException exception) {
            return this.handleException(exception);
        }
        if (cascadeDepth != 1) {
            builder.instantiateEagerMappings(clone, this);
        }
        return clone;
    }

    public void rollbackTransaction() throws DatabaseException {
        this.incrementProfile("UnitOfWorkRollbacks");
        this.getParent().rollbackTransaction();
    }

    protected void rollbackTransaction(boolean intendedToCommitTransaction) throws DatabaseException {
        if (!intendedToCommitTransaction && this.getParent().hasExternalTransactionController() && !this.getParent().wasJTSTransactionInternallyStarted()) {
            this.getParent().getExternalTransactionController().markTransactionForRollback();
        }
        this.rollbackTransaction();
    }

    public Map scanForConformingInstances(Expression selectionCriteria, Class referenceClass, AbstractRecord arguments, ObjectLevelReadQuery query) {
        IdentityHashMap indexedInterimResult;
        block6: {
            int policy = query.getInMemoryQueryIndirectionPolicyState();
            if (policy != 1) {
                policy = 3;
            }
            indexedInterimResult = new IdentityHashMap();
            try {
                Vector fromCache = null;
                if (selectionCriteria != null) {
                    fromCache = this.getIdentityMapAccessor().getAllFromIdentityMap(selectionCriteria, referenceClass, (Record)arguments, policy);
                    Enumeration fromCacheEnum = fromCache.elements();
                    while (fromCacheEnum.hasMoreElements()) {
                        Object object = fromCacheEnum.nextElement();
                        if (this.isObjectDeleted(object)) continue;
                        indexedInterimResult.put(object, object);
                    }
                }
                Vector newObjects = null;
                newObjects = this.getAllFromNewObjects(selectionCriteria, referenceClass, arguments, policy);
                Enumeration newObjectsEnum = newObjects.elements();
                while (newObjectsEnum.hasMoreElements()) {
                    Object object = newObjectsEnum.nextElement();
                    if (this.isObjectDeleted(object)) continue;
                    indexedInterimResult.put(object, object);
                }
            }
            catch (QueryException exception) {
                if (this.getShouldThrowConformExceptions() != 1) break block6;
                throw exception;
            }
        }
        return indexedInterimResult;
    }

    protected void setAllClonesCollection(Map objects) {
        this.allClones = objects;
    }

    protected void setCloneMapping(Map cloneMapping) {
        this.cloneMapping = cloneMapping;
    }

    protected void setContainerBeans(Map containerBeans) {
        this.containerBeans = containerBeans;
    }

    protected void setContainerUnitOfWork(UnitOfWorkImpl containerUnitOfWork) {
        this.containerUnitOfWork = containerUnitOfWork;
    }

    public void setDead() {
        this.setLifecycle(5);
    }

    protected void setDeletedObjects(Map deletedObjects) {
        this.deletedObjects = deletedObjects;
    }

    protected void setLifecycle(int lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setMergeManager(MergeManager mergeManager) {
        this.lastUsedMergeManager = mergeManager;
    }

    protected void setNewObjectsCloneToOriginal(Map newObjects) {
        this.newObjectsCloneToOriginal = newObjects;
    }

    protected void setNewObjectsOriginalToClone(Map newObjects) {
        this.newObjectsOriginalToClone = newObjects;
    }

    public void setObjectsDeletedDuringCommit(Map deletedObjects) {
        this.objectsDeletedDuringCommit = deletedObjects;
    }

    public void setParent(AbstractSession parent) {
        this.parent = parent;
    }

    public void setPendingMerge() {
        this.setLifecycle(4);
    }

    public void setReadOnlyClasses(Vector classes) {
        this.readOnlyClasses = new Hashtable(classes.size() + 10);
        Enumeration enumtr = classes.elements();
        while (enumtr.hasMoreElements()) {
            Class theClass = (Class)enumtr.nextElement();
            this.addReadOnlyClass(theClass);
        }
    }

    protected void setRemovedObjects(Map removedObjects) {
        this.removedObjects = removedObjects;
    }

    public void setResumeUnitOfWorkOnTransactionCompletion(boolean resumeUnitOfWork) {
        this.resumeOnTransactionCompletion = resumeUnitOfWork;
    }

    public void setShouldCascadeCloneToJoinedRelationship(boolean shouldCascadeCloneToJoinedRelationship) {
        this.shouldCascadeCloneToJoinedRelationship = shouldCascadeCloneToJoinedRelationship;
    }

    public void setShouldNewObjectsBeCached(boolean shouldNewObjectsBeCached) {
        this.shouldNewObjectsBeCached = shouldNewObjectsBeCached;
    }

    public void setShouldPerformDeletesFirst(boolean shouldPerformDeletesFirst) {
        this.shouldPerformDeletesFirst = shouldPerformDeletesFirst;
    }

    public void setShouldThrowConformExceptions(int shouldThrowExceptions) {
        this.shouldThrowConformExceptions = shouldThrowExceptions;
    }

    public static void setSmartMerge(boolean option) {
        SmartMerge = option;
    }

    public void setSynchronized(boolean synched) {
        super.setSynchronized(synched);
        this.getParent().setSynchronized(synched);
    }

    public void setUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
    }

    protected void setUnregisteredExistingObjects(Map newUnregisteredExistingObjects) {
        this.unregisteredExistingObjects = newUnregisteredExistingObjects;
    }

    protected void setUnregisteredNewObjects(Map newObjects) {
        this.unregisteredNewObjects = newObjects;
    }

    protected void setUnregisteredNewObjectsInParent(Map newObjects) {
        this.unregisteredNewObjectsInParent = newObjects;
    }

    public void setValidationLevel(int validationLevel) {
        this.validationLevel = validationLevel;
    }

    public void setWasTransactionBegunPrematurely(boolean wasTransactionBegunPrematurely) {
        if (this.isNestedUnitOfWork()) {
            ((UnitOfWorkImpl)this.getParent()).setWasTransactionBegunPrematurely(wasTransactionBegunPrematurely);
        }
        this.wasTransactionBegunPrematurely = wasTransactionBegunPrematurely;
    }

    public Object shallowMergeClone(Object rmiClone) {
        return this.mergeClone(rmiClone, 1);
    }

    public Object shallowRevertObject(Object clone) {
        return this.revertObject(clone, 1);
    }

    public void shallowUnregisterObject(Object clone) {
        this.unregisterObject(clone, 1);
    }

    public boolean shouldCascadeCloneToJoinedRelationship() {
        return this.shouldCascadeCloneToJoinedRelationship;
    }

    public boolean shouldNewObjectsBeCached() {
        return this.shouldNewObjectsBeCached;
    }

    protected boolean shouldValidateExistence() {
        if (this.shouldValidateExistence == null) {
            String value = PropertiesHandler.getSessionPropertyValueLogDebug("eclipselink.validate-existence", this);
            this.shouldValidateExistence = value != null && value.equalsIgnoreCase("true");
        }
        return this.shouldValidateExistence;
    }

    public boolean shouldPerformDeletesFirst() {
        return this.shouldPerformDeletesFirst;
    }

    public boolean shouldPerformFullValidation() {
        return this.getValidationLevel() == 2;
    }

    public boolean shouldPerformNoValidation() {
        return this.getValidationLevel() == 0;
    }

    public boolean shouldPerformPartialValidation() {
        return this.getValidationLevel() == 1;
    }

    public boolean shouldResumeUnitOfWorkOnTransactionCompletion() {
        return this.resumeOnTransactionCompletion;
    }

    public void storeModifyAllQuery(DatabaseQuery query) {
        if (this.modifyAllQueries == null) {
            this.modifyAllQueries = new ArrayList();
        }
        this.modifyAllQueries.add(query);
    }

    public void storeDeferredModifyAllQuery(DatabaseQuery query, AbstractRecord translationRow) {
        if (this.deferredModifyAllQueries == null) {
            this.deferredModifyAllQueries = new ArrayList();
        }
        this.deferredModifyAllQueries.add(new Object[]{query, translationRow});
    }

    public void synchronizeAndResume() {
        this.getPessimisticLockedObjects().clear();
        this.getProperties().remove(LOCK_QUERIES_PROPERTY);
        Map newCloneMapping = this.createMap(1 + this.getCloneMapping().size());
        for (Object clone : this.getCloneMapping().keySet()) {
            if (this.isObjectDeleted(clone) || this.getRemovedObjects().containsKey(clone)) continue;
            ClassDescriptor descriptor = this.getDescriptor(clone);
            descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, this, newCloneMapping);
        }
        this.setCloneMapping(newCloneMapping);
        if (this.hasObjectsDeletedDuringCommit()) {
            for (Object removedObject : this.getObjectsDeletedDuringCommit().keySet()) {
                this.getIdentityMapAccessor().removeFromIdentityMap((Vector)this.getObjectsDeletedDuringCommit().get(removedObject), removedObject.getClass());
            }
        }
        if (!this.isNestedUnitOfWork()) {
            if (this.hasNewObjects()) {
                for (Object newClone : this.getNewObjectsCloneToOriginal().keySet()) {
                    this.getCloneToOriginals().put(newClone, this.getNewObjectsCloneToOriginal().get(newClone));
                }
            }
            this.setNewObjectsCloneToOriginal(null);
            this.setNewObjectsOriginalToClone(null);
        }
        this.setUnitOfWorkChangeSet(null);
        this.resetAllCloneCollection();
        this.setObjectsDeletedDuringCommit(new IdentityHashMap());
        this.setDeletedObjects(new IdentityHashMap());
        this.setRemovedObjects(new IdentityHashMap());
        this.setUnregisteredNewObjectsInParent(new IdentityHashMap());
        this.setUnregisteredNewObjects(new IdentityHashMap());
        this.lifecycle = 0;
        this.isSynchronized = false;
        if (this.isNestedUnitOfWork()) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
    }

    protected void undeleteObject(Object object) {
        this.getDeletedObjects().remove(object);
        if (this.getParent().isUnitOfWork()) {
            ((UnitOfWorkImpl)this.getParent()).undeleteObject(object);
        }
    }

    public void unregisterObject(Object clone) {
        this.unregisterObject(clone, 2);
    }

    public void unregisterObject(Object clone, int cascadeDepth) {
        if (clone == null) {
            return;
        }
        this.logDebugMessage(clone, "unregister");
        Object implementation = this.getDescriptor(clone).getObjectBuilder().unwrapObject(clone, this);
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                Object original;
                if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                Vector primaryKey = this.getCurrentDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, UnitOfWorkImpl.this);
                UnitOfWorkImpl.this.getIdentityMapAccessorInstance().removeFromIdentityMap(primaryKey, object.getClass(), this.getCurrentDescriptor());
                UnitOfWorkImpl.this.getCloneMapping().remove(object);
                if (UnitOfWorkImpl.this.hasNewObjects() && (original = UnitOfWorkImpl.this.getNewObjectsCloneToOriginal().remove(object)) != null) {
                    UnitOfWorkImpl.this.getNewObjectsOriginalToClone().remove(original);
                }
            }
        };
        iterator.setSession(this);
        iterator.setCascadeDepth(cascadeDepth);
        iterator.startIterationOn(implementation);
    }

    public void updateChangeTrackersIfRequired(Object objectToWrite, ObjectChangeSet changeSetToWrite, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
    }

    public void validateObjectSpace() {
        this.log(2, "transaction", "validate_object_space");
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                try {
                    if (UnitOfWorkImpl.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                        this.setShouldBreak(true);
                        return;
                    }
                    UnitOfWorkImpl.this.getBackupClone(object);
                }
                catch (EclipseLinkException exception) {
                    UnitOfWorkImpl.this.log(1, "transaction", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    UnitOfWorkImpl.this.log(2, "transaction", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    throw exception;
                }
            }
        };
        iterator.setSession(this);
        Iterator clonesEnum = this.getCloneMapping().keySet().iterator();
        while (clonesEnum.hasNext()) {
            iterator.startIterationOn(clonesEnum.next());
        }
    }

    public boolean wasTransactionBegunPrematurely() {
        if (this.isNestedUnitOfWork()) {
            return ((UnitOfWorkImpl)this.getParent()).wasTransactionBegunPrematurely();
        }
        return this.wasTransactionBegunPrematurely;
    }

    public void writeChanges() {
        if (!this.isActive()) {
            throw ValidationException.inActiveUnitOfWork("writeChanges");
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.cannotWriteChangesTwice();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.writeChangesOnNestedUnitOfWork();
        }
        this.mergeBmpAndWsEntities();
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        try {
            this.commitToDatabaseWithChangeSet(false);
            this.writesCompleted();
        }
        catch (RuntimeException e) {
            this.setLifecycle(3);
            throw e;
        }
        this.setLifecycle(2);
    }

    public void writesCompleted() {
        this.getParent().writesCompleted();
    }

    private void logDebugMessage(Object object, String debugMessage) {
        this.log(1, "transaction", debugMessage, object);
    }

    public Object getWorkingCopyFromUnitOfWorkIdentityMap(Object object, Vector primaryKey) {
        ClassDescriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object registeredObject = this.getCloneMapping().get(object);
        if (registeredObject != null) {
            return object;
        }
        Object objectFromUOWCache = this.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(primaryKey, object.getClass(), descriptor);
        if (objectFromUOWCache != null) {
            return objectFromUOWCache;
        }
        return null;
    }

    public Map getBatchReadObjects() {
        if (this.batchReadObjects == null) {
            this.batchReadObjects = this.createMap();
        }
        return this.batchReadObjects;
    }

    public void setBatchReadObjects(Map batchReadObjects) {
        this.batchReadObjects = batchReadObjects;
    }

    public Map getPessimisticLockedObjects() {
        if (this.pessimisticLockedObjects == null) {
            this.pessimisticLockedObjects = new IdentityHashMap();
        }
        return this.pessimisticLockedObjects;
    }

    public void addToChangeTrackedHardList(Object obj) {
        if (this.referenceMode != ReferenceMode.HARD) {
            this.getChangeTrackedHardList().add(obj);
        }
    }

    public void addPessimisticLockedClone(Object clone) {
        this.log(1, "transaction", "tracking_pl_object", clone, new Integer(this.hashCode()));
        this.getPessimisticLockedObjects().put(clone, clone);
    }

    public boolean isPessimisticLocked(Object clone) {
        return this.getPessimisticLockedObjects().containsKey(clone);
    }

    public void setWasNonObjectLevelModifyQueryExecuted(boolean wasNonObjectLevelModifyQueryExecuted) {
        this.wasNonObjectLevelModifyQueryExecuted = wasNonObjectLevelModifyQueryExecuted;
    }

    public boolean wasNonObjectLevelModifyQueryExecuted() {
        return this.wasNonObjectLevelModifyQueryExecuted;
    }

    public boolean shouldReadFromDB() {
        return this.wasNonObjectLevelModifyQueryExecuted();
    }

    public void releaseReadConnection(Accessor connection) {
        this.getParent().releaseReadConnection(connection);
    }

    public void clear(boolean shouldClearCache) {
        this.cloneToOriginals = null;
        this.cloneMapping = this.createMap();
        this.newObjectsCloneToOriginal = null;
        this.newObjectsOriginalToClone = null;
        this.deletedObjects = null;
        this.allClones = null;
        this.objectsDeletedDuringCommit = null;
        this.removedObjects = null;
        this.unregisteredNewObjects = null;
        this.unregisteredExistingObjects = null;
        this.newAggregates = null;
        this.unitOfWorkChangeSet = null;
        this.pessimisticLockedObjects = null;
        this.optimisticReadLockObjects = null;
        this.batchReadObjects = null;
        if (shouldClearCache) {
            this.getIdentityMapAccessor().initializeIdentityMaps();
            if (this.getParent() instanceof IsolatedClientSession) {
                this.getParent().getIdentityMapAccessor().initializeIdentityMaps();
            }
        }
    }

    public void clearForClose(boolean shouldClearCache) {
        this.clear(shouldClearCache);
        if (this.isActive()) {
            this.lifecycle = 0;
            this.isSynchronized = false;
        }
    }

    public boolean shouldClearForCloseOnRelease() {
        return false;
    }

    private void copyStatementsCountIntoProperties() {
        if (this.getAccessor() != null && this.getAccessor() instanceof DatasourceAccessor) {
            this.getProperties().put("Read_Statements_Count_Property", new Integer(((DatasourceAccessor)this.getAccessor()).getReadStatementsCount()));
            this.getProperties().put("Write_Statements_Count_Property", new Integer(((DatasourceAccessor)this.getAccessor()).getWriteStatementsCount()));
            this.getProperties().put("StoredProcedure_Statements_Count_Property", new Integer(((DatasourceAccessor)this.getAccessor()).getStoredProcedureStatementsCount()));
        }
    }

    protected Map createMap() {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return new IdentityWeakHashMap();
        }
        return new IdentityHashMap();
    }

    protected Map createMap(int size) {
        if (this.referenceMode != null && this.referenceMode != ReferenceMode.HARD) {
            return new IdentityWeakHashMap(size);
        }
        return new IdentityHashMap(size);
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    public IdentityHashSet getChangeTrackedHardList() {
        if (this.changeTrackedHardList == null) {
            this.changeTrackedHardList = new IdentityHashSet();
        }
        return this.changeTrackedHardList;
    }

    public Object getReference(Class theClass, Object primaryKey) {
        Object reference;
        Vector primaryKeyValues;
        ClassDescriptor descriptor = this.getDescriptor(theClass);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{theClass}));
        }
        if (primaryKey == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_pk"));
        }
        if (primaryKey instanceof List) {
            primaryKeyValues = new NonSynchronizedVector((Collection)((List)primaryKey));
        } else if (descriptor.getCMPPolicy() != null) {
            if (descriptor.getCMPPolicy().getPKClass() != null && !descriptor.getCMPPolicy().getPKClass().isAssignableFrom(primaryKey.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{descriptor.getCMPPolicy().getPKClass(), primaryKey.getClass()}));
            }
            primaryKeyValues = descriptor.getCMPPolicy().createPkVectorFromKey(primaryKey, this);
        } else if (!primaryKey.getClass().equals(theClass)) {
            primaryKeyValues = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(primaryKey, this);
        } else {
            primaryKeyValues = new NonSynchronizedVector(1);
            primaryKeyValues.add(primaryKey);
        }
        if (ClassConstants.FetchGroupTracker_class.isAssignableFrom(theClass)) {
            reference = this.getIdentityMapAccessor().getFromIdentityMap(primaryKeyValues, theClass);
            if (reference == null) {
                if (primaryKey instanceof List) {
                    AbstractRecord row = descriptor.getObjectBuilder().buildRowFromPrimaryKeyValues(primaryKeyValues, this);
                    reference = descriptor.getObjectBuilder().buildNewInstance();
                    descriptor.getObjectBuilder().buildPrimaryKeyAttributesIntoObject(reference, row, new ReadObjectQuery());
                } else {
                    reference = descriptor.getCMPPolicy().createBeanUsingKey(primaryKey, this);
                }
                ((FetchGroupTracker)reference)._persistence_setSession(this);
                FetchGroup fetchGroup = new FetchGroup();
                for (DatabaseMapping mapping : descriptor.getObjectBuilder().getPrimaryKeyMappings()) {
                    fetchGroup.addAttribute(mapping.getAttributeName());
                }
                ((FetchGroupTracker)reference)._persistence_setFetchGroup(fetchGroup);
                reference = this.registerExistingObject(reference);
            }
        } else {
            ReadObjectQuery query = new ReadObjectQuery(descriptor.getJavaClass());
            query.setSelectionKey(primaryKeyValues);
            query.conformResultsInUnitOfWork();
            query.setIsExecutionClone(true);
            reference = this.executeQuery(query);
        }
        return reference;
    }
}

