/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.dotted.DottedName;
import org.glassfish.admin.amx.dotted.DottedNameAliasSupport;
import org.glassfish.admin.amx.dotted.DottedNameFactory;
import org.glassfish.admin.amx.dotted.DottedNameLogger;
import org.glassfish.admin.amx.dotted.DottedNameQuery;
import org.glassfish.admin.amx.dotted.DottedNameResolverForAliases;
import org.glassfish.admin.amx.dotted.DottedNameServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DottedNameAliasedQuery
implements DottedNameQuery {
    protected final DottedNameQuery mSrcQuery;
    protected final DottedNameServerInfo mServerInfo;
    final DottedNameResolverForAliases mAliasResolver;

    public DottedNameAliasedQuery(DottedNameQuery srcQuery, DottedNameServerInfo serverInfo) {
        this.mSrcQuery = srcQuery;
        this.mServerInfo = serverInfo;
        this.mAliasResolver = new DottedNameResolverForAliases(srcQuery, serverInfo);
    }

    @Override
    public ObjectName dottedNameToObjectName(String dottedName) {
        return this.mAliasResolver.resolveDottedName(dottedName);
    }

    @Override
    public Set<String> allDottedNameStrings() {
        Set<String> result = Collections.emptySet();
        try {
            result = this.allDottedNameStringsThrow();
        }
        catch (DottedNameServerInfo.UnavailableException e) {
            DottedNameLogger.logException(e);
        }
        return result;
    }

    protected Set<String> allDottedNameStringsThrow() throws DottedNameServerInfo.UnavailableException {
        Set<String> srcSet = this.mSrcQuery.allDottedNameStrings();
        HashSet<String> destSet = new HashSet<String>();
        Set<String> configNames = this.mServerInfo.getConfigNames();
        for (String dottedName : srcSet) {
            DottedName dn = DottedNameFactory.getInstance().get(dottedName);
            String scope = dn.getScope();
            if (DottedNameAliasSupport.scopeIsDomain(scope)) {
                if (!DottedNameAliasSupport.isAliasedDomain(dn)) continue;
                destSet.add(dottedName);
                this.addAllNamesForDomain(dn, destSet);
                continue;
            }
            if (configNames.contains(scope)) {
                this.addAllNamesForConfig(dn, destSet);
                continue;
            }
            destSet.add(dottedName);
        }
        return destSet;
    }

    protected void addAllNamesForDomain(DottedName domainDN, Set<String> outSet) throws DottedNameServerInfo.UnavailableException {
        for (String serverName : this.mServerInfo.getServerNames()) {
            String dottedNameString = DottedName.toString(domainDN.getDomain(), serverName, domainDN.getParts());
            DottedName newName = DottedNameFactory.getInstance().get(dottedNameString);
            outSet.add(newName.toString());
        }
    }

    protected void addAllNamesForConfig(DottedName configDN, Set<String> outSet) throws DottedNameServerInfo.UnavailableException {
        String[] serverNames = this.mServerInfo.getServerNamesForConfig(configDN.getScope());
        for (int i = 0; i < serverNames.length; ++i) {
            String newName = DottedName.toString(configDN.getDomain(), serverNames[i], configDN.getParts());
            outSet.add(newName);
        }
    }
}

