/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import javax.management.ObjectName;
import org.glassfish.admin.amx.dotted.DottedName;
import org.glassfish.admin.amx.dotted.DottedNameAliasSupport;
import org.glassfish.admin.amx.dotted.DottedNameFactory;
import org.glassfish.admin.amx.dotted.DottedNameLogger;
import org.glassfish.admin.amx.dotted.DottedNameQuery;
import org.glassfish.admin.amx.dotted.DottedNameResolver;
import org.glassfish.admin.amx.dotted.DottedNameServerInfo;

public class DottedNameResolverForAliases
implements DottedNameResolver {
    final DottedNameQuery mQuery;
    final DottedNameServerInfo mServerInfo;

    public DottedNameResolverForAliases(DottedNameQuery query, DottedNameServerInfo serverInfo) {
        this.mQuery = query;
        this.mServerInfo = serverInfo;
    }

    protected String getUnaliasedName(String dottedNameString) {
        DottedName dn;
        DottedName actualDN = dn = DottedNameFactory.getInstance().get(dottedNameString);
        if (!DottedName.isWildcardName(dottedNameString)) {
            try {
                String actualScope = DottedNameAliasSupport.resolveScope(this.mServerInfo, dn);
                if (!actualScope.equals(dn.getScope())) {
                    actualDN = DottedNameFactory.getInstance().get(DottedName.toString(dn.getDomain(), actualScope, dn.getParts()));
                }
            }
            catch (Exception e) {
                DottedNameLogger.logException(e);
            }
        }
        return actualDN.toString();
    }

    public ObjectName resolveDottedName(String dottedName) {
        String unaliasedName = this.getUnaliasedName(dottedName);
        ObjectName result = this.mQuery.dottedNameToObjectName(unaliasedName);
        return result;
    }
}

