/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigsConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServersConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.dotted.DottedNameServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DottedNameServerInfoImpl
implements DottedNameServerInfo {
    final MBeanServerConnection mConn;

    public DottedNameServerInfoImpl(MBeanServerConnection conn) {
        this.mConn = conn;
    }

    ObjectName getConfigsObjectName() throws MalformedObjectNameException {
        return new ObjectName("com.sun.appserv:type=configs,category=config");
    }

    ObjectName getServerObjectName(String serverName) {
        return Util.getObjectName((AMX)this._getServers().get(serverName));
    }

    private DomainRoot getDomainRoot() {
        return ProxyFactory.getInstance(this.mConn).getDomainRoot();
    }

    private Set<String> _getConfigNames() throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, MalformedObjectNameException, AttributeNotFoundException {
        ConfigsConfig configsConfig = this.getDomainRoot().getDomainConfig().getConfigsConfig();
        Map<String, ConfigConfig> configs = configsConfig.getConfigConfigMap();
        return Collections.unmodifiableSet(configs.keySet());
    }

    @Override
    public Set<String> getConfigNames() throws DottedNameServerInfo.UnavailableException {
        Set<String> namesSet = null;
        try {
            namesSet = this._getConfigNames();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e);
        }
        return namesSet;
    }

    private Map<String, ServerConfig> _getServers() {
        ServersConfig serversConfig = this.getDomainRoot().getDomainConfig().getServersConfig();
        HashMap<String, ServerConfig> result = new HashMap<String, ServerConfig>();
        result.putAll(serversConfig.getStandaloneServerConfigMap());
        result.putAll(serversConfig.getClusteredServerConfigMap());
        return result;
    }

    @Override
    public Set<String> getServerNames() throws DottedNameServerInfo.UnavailableException {
        Set<String> namesSet = null;
        try {
            namesSet = this._getServers().keySet();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e);
        }
        return namesSet;
    }

    @Override
    public String getConfigNameForServer(String serverName) throws DottedNameServerInfo.UnavailableException {
        ObjectName serverObjectName = this.getServerObjectName(serverName);
        if (serverObjectName == null) {
            throw new DottedNameServerInfo.UnavailableException(serverName);
        }
        String configName = null;
        try {
            configName = (String)this.mConn.getAttribute(serverObjectName, "config_ref");
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e);
        }
        return configName;
    }

    @Override
    public String[] getServerNamesForConfig(String configName) throws DottedNameServerInfo.UnavailableException {
        ArrayList<String> namesOut = new ArrayList<String>();
        for (String serverName : this.getServerNames()) {
            if (!configName.equals(this.getConfigNameForServer(serverName))) continue;
            namesOut.add(serverName);
        }
        String[] namesOutArray = new String[namesOut.size()];
        namesOut.toArray(namesOutArray);
        return namesOutArray;
    }
}

