/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.dotted.DottedName;
import org.glassfish.admin.amx.dotted.DottedNamesBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DottedNamesImpl
extends DottedNamesBase {
    public DottedNamesImpl(ObjectName parentObjectName) {
        super("X-ConfigDottedNames", "X-ConfigDottedNames", parentObjectName, DottedNames.class);
    }

    private String getDomainRootPart() {
        return this.getDomainRoot().getDottedNamePart();
    }

    @Override
    public String getGroup() {
        return "utility";
    }

    private DomainConfig getDomainConfig() {
        return this.getDomainRoot().getDomainConfig();
    }

    @Override
    public Object[] dottedNameGet(String[] names) {
        Object[] results = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.dottedNameGet(names[i]);
        }
        return results;
    }

    private AMX findMatchingChild(AMX amx, String namePart) {
        AMX child = null;
        if (amx instanceof Container) {
            Set containees = ((Container)amx).getContaineeSet();
            for (AMX containee : containees) {
                String p = containee.getDottedNamePart();
                if (!namePart.equals(p)) continue;
                child = containee;
                break;
            }
        }
        return child;
    }

    private String laxName(String dottedName) {
        int idx;
        String name = dottedName;
        if (!dottedName.startsWith(this.getDomainRootPart())) {
            name = this.getDomainRootPart() + "." + name;
        }
        if ((idx = name.indexOf(".property.")) > 0) {
            name = name.replace(".property.", ".property:");
        }
        if (!dottedName.equals(name)) {
            DottedNamesImpl.cdebug("laxName: translated " + dottedName + " => " + name);
        }
        return name;
    }

    private AMX resolveToAnAMX(String nameIn) {
        AMX amx = this.getDomainRoot();
        DottedName dottedName = new DottedName(this.laxName(nameIn));
        List<String> unescapedParts = dottedName.getParts();
        if (!dottedName.getScope().equals(this.getDomainRoot().getDottedNamePart())) {
            throw new IllegalArgumentException("bad root: " + nameIn);
        }
        if (unescapedParts.size() != 0) {
            int i;
            String[] escapedParts = new String[unescapedParts.size()];
            for (i = 0; i < unescapedParts.size(); ++i) {
                escapedParts[i] = DottedName.escapePart(unescapedParts.get(i));
            }
            for (i = 0; i < escapedParts.length; ++i) {
                AMX child = this.findMatchingChild(amx, escapedParts[i]);
                if (child == null) {
                    throw new IllegalArgumentException("Match failed for: " + nameIn);
                }
                amx = child;
            }
        }
        return amx;
    }

    public ObjectName getDottedNameTargetObjectName(String dottedName) {
        AMX amx = this.resolveToAnAMX(dottedName);
        return amx == null ? null : Util.getObjectName(amx);
    }

    public Map<String, ObjectName> getDottedNameTargetObjectNameMap(String[] dottedNames) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (String dottedName : dottedNames) {
            m.put(dottedName, this.getDottedNameTargetObjectName(dottedName));
        }
        return m;
    }

    public String[] getAllDottedNames() {
        Set<String> all = this.getAllDottedNameTargetsObjectNameMap().keySet();
        String[] allStrings = new String[all.size()];
        all.toArray(allStrings);
        return allStrings;
    }

    public String testResolve() {
        Map<String, ObjectName> all = this.getAllDottedNameTargetsObjectNameMap();
        String dump = "";
        int numProblems = 0;
        for (String dottedName : all.keySet()) {
            try {
                ObjectName on = this.getDottedNameTargetObjectName(dottedName);
                dump = dump + dottedName + " => " + JMXUtil.toString(on) + StringUtil.NEWLINE();
            }
            catch (Exception e) {
                dump = dump + dottedName + " => " + ExceptionUtil.toString(e) + StringUtil.NEWLINE();
                ++numProblems;
            }
        }
        dump = dump + "PROBLEMS FOUND: " + numProblems;
        return dump;
    }

    @Override
    public Object dottedNameGet(String nameIn) {
        DottedNamesImpl.cdebug("dottedNameGet: " + nameIn);
        AMX amx = this.resolveToAnAMX(nameIn);
        if (amx != null) {
            DottedNamesImpl.cdebug("dottedNameGet: resolved: " + nameIn + " to " + JMXUtil.toString(Util.getObjectName(amx)));
        }
        return amx == null ? null : Util.getObjectName(amx);
    }

    public Object[] dottedNameList(String name) {
        Object[] results = null;
        try {
            AMX amx = this.resolveToAnAMX(name);
            if (amx instanceof Container) {
                Set containees = ((Container)amx).getContaineeSet();
                results = new String[containees.size()];
                int i = 0;
                for (AMX containee : containees) {
                    results[i++] = containee.getDottedName();
                }
            } else {
                results = new String[]{};
            }
        }
        catch (Exception e) {
            results = new Exception[]{e};
        }
        return results;
    }

    @Override
    public Object[] dottedNameList(String[] names) {
        Object[] results = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.dottedNameList(names[i]);
        }
        return results;
    }

    @Override
    public Object[] dottedNameSet(String[] nameValuePairs) {
        return null;
    }

    @Override
    protected boolean isWriteableDottedName(String name) {
        return true;
    }

    public Map<String, ObjectName> getAllDottedNameTargetsObjectNameMap() {
        QueryMgr queryMgr = this.getDomainRoot().getQueryMgr();
        Set<AMX> allAMX = queryMgr.queryAllSet();
        HashMap<String, ObjectName> result = new HashMap<String, ObjectName>();
        for (AMX amx : allAMX) {
            result.put(amx.getDottedName(), Util.getObjectName(amx));
        }
        return result;
    }

    private Pieces split(String dottedName) {
        String[] parts = dottedName.split("@");
        if (parts.length > 2) {
            throw new IllegalArgumentException("Malformed dotted name: " + dottedName);
        }
        return new Pieces(parts[0], parts.length == 2 ? parts[1] : null);
    }

    public Map<String, String> getDottedNameValuesMap(Set<String> dottedNames) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (String dottedName : dottedNames) {
            Pieces pieces = this.split(dottedName);
            AMX amx = this.resolveToAnAMX(pieces.getPath());
            if (amx == null) continue;
            DottedNamesImpl.cdebug("Resolved " + pieces.getPath() + " to " + Util.getObjectName(amx));
            try {
                String value = "" + amx.getDottedValue(pieces.getValueName());
                results.put(dottedName, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public String getDottedNameValue(String dottedName) {
        Set<String> temp = Collections.singleton(dottedName);
        Map<String, String> results = this.getDottedNameValuesMap(temp);
        String result = results.get(dottedName);
        return result;
    }

    private static final class Pieces {
        final String mPath;
        final String mValueName;

        Pieces(String path, String valueName) {
            this.mPath = path;
            this.mValueName = valueName;
        }

        public String getPath() {
            return this.mPath;
        }

        public String getValueName() {
            return this.mValueName;
        }

        public String toString() {
            return this.mPath + "@" + this.mValueName;
        }
    }
}

