/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted.valueaccessor;

import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.TokenizerException;
import com.sun.appserv.management.util.misc.TokenizerImpl;
import com.sun.appserv.management.util.misc.TokenizerParams;
import java.lang.reflect.Array;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.dotted.valueaccessor.ValueAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ValueAccessorBase
implements ValueAccessor {
    final MBeanServerConnection mConn;
    static final char ARRAY_ELEMENT_SEPARATOR = ',';
    static final char ESCAPE_CHAR = '\\';

    MBeanServerConnection getMBS() {
        return this.mConn;
    }

    public ValueAccessorBase(MBeanServerConnection conn) {
        this.mConn = conn;
    }

    String[] stringToStringArray(String s) throws TokenizerException {
        String delimiters = ",";
        String escapableChars = ",\\";
        TokenizerParams params = new TokenizerParams();
        params.mEscapableChars = ",\\";
        params.mDelimiters = ",";
        TokenizerImpl tok = new TokenizerImpl(s, params);
        String[] values = tok.getTokens();
        return values;
    }

    Object[] convert(String[] stringValues, Class<?> elementClass) throws Exception {
        if (elementClass == String.class) {
            return stringValues;
        }
        if (ClassUtil.classnameIsPrimitiveArray(elementClass.getName())) {
            throw new IllegalArgumentException();
        }
        Object[] values = (Object[])Array.newInstance(elementClass, stringValues.length);
        for (int i = 0; i < values.length; ++i) {
            values[i] = ClassUtil.InstantiateFromString(elementClass, stringValues[i]);
        }
        return values;
    }

    Object[] stringToArray(String s, Class<?> elementClass) throws Exception {
        String[] stringValues = this.stringToStringArray(s);
        Object[] values = this.convert(stringValues, elementClass);
        return values;
    }

    Object coerceToClass(Class<?> theClass, String value) throws Exception {
        Object result = value;
        if (theClass != String.class) {
            if (ClassUtil.classIsArray(theClass)) {
                String theClassName = theClass.getName();
                String elementClassName = ClassUtil.getArrayMemberClassName(theClassName);
                result = this.stringToArray((String)value, ClassUtil.getClassFromName(elementClassName));
            } else {
                boolean canCoerce = true;
                Class resultClass = ClassUtil.PrimitiveClassToObjectClass(theClass);
                if (resultClass == Boolean.class) {
                    boolean bl = canCoerce = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
                }
                if (canCoerce) {
                    result = ClassUtil.InstantiateFromString(resultClass, (String)value);
                }
            }
        }
        return result;
    }

    @Override
    public abstract Attribute getValue(ObjectName var1, String var2) throws Exception;

    @Override
    public abstract Attribute setValue(ObjectName var1, Attribute var2) throws Exception;
}

