/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.j2ee.J2EETypes;
import com.sun.appserv.management.util.jmx.AttributeChangeNotificationBuilder;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionSource;
import com.sun.appserv.management.util.jmx.stringifier.AttributeChangeNotificationStringifier;
import com.sun.appserv.management.util.jmx.stringifier.MBeanInfoStringifier;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.ThrowableMapper;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.dotted.DottedName;
import org.glassfish.admin.amx.mbean.ContainerSupport;
import org.glassfish.admin.amx.mbean.Delegate;
import org.glassfish.admin.amx.mbean.DelegateBase;
import org.glassfish.admin.amx.mbean.DelegateOwner;
import org.glassfish.admin.amx.mbean.MBeanImplBase;
import org.glassfish.admin.amx.mbean.MBeanInfoCache;
import org.glassfish.admin.amx.mbean.QueryMgrImpl;
import org.glassfish.admin.amx.util.Issues;
import org.glassfish.admin.amx.util.ObjectNames;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXImplBase
extends MBeanImplBase
implements DynamicMBean,
MBeanRegistration,
AMX,
NotificationEmitter,
DelegateOwner {
    protected static final String GET = "get";
    protected static final String SET = "set";
    private final Class<? extends AMX> mInterface;
    private final MBeanInfo mAMXMBeanInterfaceMBeanInfo;
    private volatile MBeanInfo mInvariantMBeanInfo;
    private final ObjectName mContainerObjectName;
    private final boolean mEmitAttributeChangeNotifications;
    private volatile QueryMgr mQueryMgr;
    private volatile AMX mSelfProxy;
    private ConnectionSource mConnectionSource;
    private final Delegate mSuppliedDelegate;
    private volatile Delegate mDelegate;
    private Map<String, MBeanAttributeInfo> mAttributeInfos;
    private final String mFullType;
    private final String mJ2EEType;
    private static final Map<String, Map<String, Class>> ATTRIBUTE_CLASSES = Collections.synchronizedMap(new HashMap());
    private volatile String mDottedName = null;
    private volatile String mDottedNamePart = null;
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATIONS = new MBeanNotificationInfo[0];
    private static final Class[] GETTER_SIG = new Class[0];
    protected static final String GET_PREFIX = "get";
    protected static final String OBJECT_NAME_SUFFIX = "ObjectName";
    protected static final String OBJECT_NAME_MAP_SUFFIX = "ObjectNameMap";
    private static final Set<String> NO_AUTO_GET = GSetUtil.newUnmodifiableStringSet("ContainerObjectName", "MonitoringPeerObjectName", "ObjectName", "ConfigPeerObjectName", "ServerObjectName");
    protected static final Set<String> EMPTY_STRING_SET = Collections.emptySet();
    private static final Set<String> NOT_SUPERFLUOUS = GSetUtil.newUnmodifiableStringSet("getProxyFactory", "getDomainRootObjectName", "getQueryMgrObjectName", "getServerRootMonitorObjectName");
    private static final String OBJECT_REF_ATTR_NAME = "__ObjectRef";
    private volatile ContainerSupport mContainerSupport = null;

    private synchronized MBeanInfo getInterfaceMBeanInfo(Class<? extends AMX> theInterface) {
        MBeanInfo info = MBeanInfoCache.getAMXMBeanInfo(theInterface);
        if (this.getAMXDebug()) {
            this.debug((Object)("Interface " + this.mInterface.getName() + " has MBeanInfo:\n" + MBeanInfoStringifier.DEFAULT.stringify(info)));
        }
        return info;
    }

    public AMXImplBase(String j2eeType, String fullType, ObjectName parentObjectName, Class<? extends AMX> theInterface, Delegate delegate) {
        if (parentObjectName == null && theInterface != DomainRoot.class) {
            this.debug((Object)("WARNING: every AMX MBean must have a parent object (Container)! Missing parent for j2eeType " + j2eeType));
            throw new IllegalArgumentException("every AMX MBean must have a parent object (Container)");
        }
        if (j2eeType == null) {
            throw new IllegalArgumentException("AMXImplBase: j2eeType is null for " + theInterface.getName());
        }
        if (fullType == null || !fullType.endsWith(j2eeType)) {
            throw new IllegalArgumentException("AMXImplBase: fullType is null or ends wrong: " + fullType + " for " + theInterface.getName());
        }
        this.mJ2EEType = j2eeType;
        this.mFullType = fullType;
        this.mInterface = theInterface;
        this.mContainerObjectName = parentObjectName;
        if (delegate != null) {
            delegate.setOwner(this);
        }
        this.mEmitAttributeChangeNotifications = true;
        this.mQueryMgr = null;
        this.mSelfProxy = null;
        this.mSuppliedDelegate = delegate;
        if (this.mSuppliedDelegate instanceof DelegateBase) {
            ((DelegateBase)this.mSuppliedDelegate).setDebugOutput(this.getDebugOutput());
        }
        ATTRIBUTE_CLASSES.put(this.mJ2EEType, Collections.synchronizedMap(new HashMap()));
        this.mDelegate = null;
        this.mAttributeInfos = null;
        this.mAMXMBeanInterfaceMBeanInfo = this.getInterfaceMBeanInfo(this.mInterface);
    }

    @Override
    public void delegateFailed(Throwable t) {
    }

    protected String _getDottedNamePart() {
        String result = null;
        if (AMXImplBase.isSingletonMBean(this.getInterface())) {
            result = this.getJ2EEType();
            if (result.startsWith("X-")) {
                result = result.substring("X-".length(), result.length());
            }
        } else {
            result = this.getName();
        }
        return result;
    }

    @Override
    public final String getDottedNamePart() {
        String result;
        if (this.mDottedNamePart != null) {
            return this.mDottedNamePart;
        }
        this.mDottedNamePart = result = DottedName.escapePart(this._getDottedNamePart());
        return this.mDottedNamePart;
    }

    @Override
    public final String getDottedName() {
        if (this.mDottedName != null) {
            return this.mDottedName;
        }
        String result = null;
        Container container = this.getContainer();
        result = container != null ? container.getDottedName() + "." + this.getDottedNamePart() : this.getDottedNamePart();
        this.mDottedName = result;
        return this.mDottedName;
    }

    protected String attributeNameToDottedValueName(String attrName) {
        String dottedName = attrName;
        if (attrName.endsWith(OBJECT_NAME_SUFFIX) || attrName.endsWith(OBJECT_NAME_MAP_SUFFIX) || attrName.endsWith("ObjectNameSet") || attrName.endsWith("ObjectNameList")) {
            dottedName = null;
        }
        return dottedName;
    }

    @Override
    public final Map<String, String> getDottedToAttributes() {
        HashMap<String, String> dottedToAttr = new HashMap<String, String>();
        Set<String> attrNames = this.getAttributeInfos().keySet();
        for (String attrName : attrNames) {
            String dottedValueName = this.attributeNameToDottedValueName(attrName);
            if (dottedValueName == null) continue;
            dottedToAttr.put(dottedValueName, attrName);
        }
        return dottedToAttr;
    }

    private final String _getDottedValue(Map<String, String> dottedToAttrs, String dottedName) {
        Set<String> attrNames = this.getAttributeInfos().keySet();
        String attrName = null;
        if (attrNames.contains(dottedName)) {
            attrName = dottedName;
        } else if (dottedToAttrs.containsKey(dottedName)) {
            attrName = dottedToAttrs.get(dottedName);
        } else {
            attrName = GSetUtil.findIgnoreCase(attrNames, dottedName);
            if (attrName == null) {
                String d = GSetUtil.findIgnoreCase(dottedToAttrs.keySet(), dottedName);
                attrName = dottedToAttrs.get(d);
            }
        }
        if (attrName == null) {
            String msg = "No such dotted value: " + StringUtil.quote(dottedName) + " in MBean " + this.getObjectName() + ", dottedToAttributes = " + MapUtil.toString(dottedToAttrs);
            AMXImplBase.cdebug(msg);
            throw new IllegalArgumentException(msg);
        }
        AMXImplBase.cdebug("_getDottedValue: " + dottedName);
        Object value = this.getAttributeNoThrow(attrName);
        AMXImplBase.cdebug("_getDottedValue: " + dottedName + " = " + value);
        return "" + value;
    }

    @Override
    public final String getDottedValue(String dottedName) {
        return this._getDottedValue(this.getDottedToAttributes(), dottedName);
    }

    @Override
    public final Map<String, String> getDottedValues(Set<String> dottedValueNamesIn) {
        Map<String, String> dottedToAttr = this.getDottedToAttributes();
        Set<String> dottedNames = dottedValueNamesIn != null ? dottedValueNamesIn : dottedToAttr.keySet();
        HashMap<String, String> results = new HashMap<String, String>();
        for (String dottedName : dottedNames) {
            try {
                results.put(dottedName, "" + this._getDottedValue(dottedToAttr, dottedName));
            }
            catch (Exception e) {}
        }
        return results;
    }

    @Override
    protected String getDebugID() {
        return ClassUtil.stripPackageName(this.getClass().getName());
    }

    public boolean getMBeanInfoIsInvariant() {
        return true;
    }

    protected MBeanInfo removeUnsupportedMBeanInfo(MBeanInfo info) {
        return info;
    }

    protected MBeanInfo modifyMBeanInfo(MBeanInfo info) {
        return info;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo = null;
        if (this.mInvariantMBeanInfo != null) {
            mbeanInfo = this.mInvariantMBeanInfo;
        } else {
            mbeanInfo = this.mAMXMBeanInterfaceMBeanInfo;
            try {
                MBeanNotificationInfo[] notifs = this.getNotificationInfo();
                if (notifs != null && notifs.length != 0) {
                    mbeanInfo = JMXUtil.addNotificationInfos(mbeanInfo, notifs);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            mbeanInfo = this.removeUnsupportedMBeanInfo(mbeanInfo);
            mbeanInfo = this.modifyMBeanInfo(mbeanInfo);
            if (this.getMBeanInfoIsInvariant()) {
                this.mInvariantMBeanInfo = mbeanInfo;
            }
        }
        return mbeanInfo;
    }

    protected final boolean shouldEmitNotifications() {
        return this.mEmitAttributeChangeNotifications && this.getListenerCount() != 0;
    }

    public Delegate getDelegate() {
        return this.mDelegate;
    }

    protected void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    protected boolean haveDelegate() {
        return this.getDelegate() != null;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return EMPTY_NOTIFICATIONS;
    }

    protected String getKeyProperty(String key) {
        return this.getObjectName().getKeyProperty(key);
    }

    public ProxyFactory getProxyFactory() {
        assert (this.mConnectionSource != null);
        return ProxyFactory.getInstance(this.mConnectionSource, true);
    }

    public <T extends AMX> T getProxy(ObjectName objectName, Class<T> theClass) {
        return this.getProxyFactory().getProxy(objectName, theClass);
    }

    @Override
    protected boolean shouldOmitObjectNameForDebug() {
        return super.shouldOmitObjectNameForDebug() || this.getObjectName().getKeyProperty("name").equals("na");
    }

    protected static boolean isSingletonMBean(Class<? extends AMX> mbeanInterface) {
        return Singleton.class.isAssignableFrom(mbeanInterface);
    }

    protected static boolean isUtilityMBean(Class mbeanInterface) {
        return Utility.class.isAssignableFrom(mbeanInterface);
    }

    protected static boolean hasElementName(Class mbeanInterface) {
        return NamedConfigElement.class.isAssignableFrom(mbeanInterface);
    }

    @Override
    public final Container getContainer() {
        ObjectName objectName = this.getContainerObjectName();
        return objectName == null ? null : this.getProxyFactory().getProxy(objectName, Container.class);
    }

    public ObjectName getContainerObjectName() {
        return this.mContainerObjectName;
    }

    protected ObjectNames getObjectNames() {
        return ObjectNames.getInstance(this.getJMXDomain());
    }

    public final ObjectName getObjectNamePattern() {
        ObjectName selfObjectName = this.getObjectName();
        Set<String> requiredKeys = Util.getPatternKeys(this.getFullType());
        String requiredProps = JMXUtil.getProps(selfObjectName, requiredKeys, true);
        ObjectName pat = Util.newObjectNamePattern(selfObjectName.getDomain(), requiredProps);
        return pat;
    }

    public final Class<? extends AMX> getInterface() {
        return this.mInterface;
    }

    public final String getInterfaceName() {
        return this.getInterface().getName();
    }

    public final String[] getAttributeNames() {
        return GSetUtil.toStringArray(this.getAttributeInfos().keySet());
    }

    protected final void unimplementedOperation(String operation) {
        String msg = "UNIMPLEMENTED OPERATION: " + operation + " in " + this.getObjectName();
        this.logInfo(msg);
        throw new UnsupportedOperationException(operation);
    }

    protected final Object unimplementedAttribute(String attrName) {
        String msg = "UNIMPLEMENTED ATTRIBUTE: " + attrName + " in " + this.getObjectName();
        this.logInfo(msg);
        return null;
    }

    protected final void impossible(Throwable t) {
        this.logSevere("AMXImplBase.impossible: " + t.getMessage());
        assert (false);
        throw new RuntimeException(t);
    }

    private Object convertToClass(Object value, Class theClass) throws Exception {
        Object result = value;
        if (value instanceof String) {
            result = ClassUtil.InstantiateFromString(theClass, (String)value);
        } else {
            this.getMBeanLogger().info("convertToClass: don't know how to convert: " + value.getClass().getName());
        }
        return result;
    }

    private Class<?> getAttributeClass(String attributeName) throws ClassNotFoundException {
        Map<String, Class> mappings = ATTRIBUTE_CLASSES.get(this.getJ2EEType());
        Class theClass = mappings.get(attributeName);
        if (theClass == null && !mappings.containsKey(attributeName)) {
            MBeanAttributeInfo[] infos = this.getMBeanInfo().getAttributes();
            for (int i = 0; i < infos.length; ++i) {
                String attrName = infos[i].getName();
                Class<?> c = ClassUtil.getClassFromName(infos[i].getType());
                mappings.put(attrName, c);
            }
            theClass = mappings.get(attributeName);
        }
        return theClass;
    }

    protected Object delegateGetAttribute(String name) throws Exception {
        Object value;
        assert (name != null);
        Delegate delegate = this.getDelegate();
        assert (delegate != null);
        Object result = value = delegate.getAttribute(name);
        if (value != null) {
            Class attrClass = this.getAttributeClass(name);
            if (attrClass != null) {
                if (ClassUtil.IsPrimitiveClass(attrClass)) {
                    attrClass = ClassUtil.PrimitiveClassToObjectClass(attrClass);
                }
                if (!attrClass.isAssignableFrom(value.getClass())) {
                    try {
                        result = this.convertToClass(value, attrClass);
                    }
                    catch (Exception e) {
                        result = value;
                    }
                }
            } else {
                this.getMBeanLogger().warning("AMXImplBase.delegateGetAttribute: Can't find class for attribute: " + name + "=" + value + " in object " + this.getObjectName());
                ATTRIBUTE_CLASSES.get(this.getJ2EEType()).put(name, null);
            }
        }
        return result;
    }

    protected Object delegateGetAttributeNoThrow(String name) {
        try {
            Object value = this.delegateGetAttribute(name);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object getAttributeNoThrow(String name) {
        Object result = null;
        try {
            result = this.getAttribute(name);
        }
        catch (Exception e) {
            throw new RuntimeException(new ThrowableMapper(e).map());
        }
        return result;
    }

    protected synchronized Map<String, MBeanAttributeInfo> getAttributeInfos() {
        if (this.mAttributeInfos == null || !this.getMBeanInfoIsInvariant()) {
            this.mAttributeInfos = JMXUtil.attributeInfosToMap(this.getMBeanInfo().getAttributes());
        }
        return this.mAttributeInfos;
    }

    protected void clearAttributeInfos() {
        this.mAttributeInfos = null;
    }

    protected boolean isLegalAttribute(String name) {
        return this.getAttributeInfos().keySet().contains(name);
    }

    protected MBeanAttributeInfo getAttributeInfo(String name) {
        return this.getAttributeInfos().get(name);
    }

    protected boolean isReadOnlyAttribute(String name) {
        return !this.getAttributeInfo(name).isWritable();
    }

    public Logger getLogger() {
        return this.getMBeanLogger();
    }

    protected static void cdebug(String s) {
        System.out.println(s);
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        Object result = null;
        if (name == null || !this.isLegalAttribute(name) && !name.equals(OBJECT_REF_ATTR_NAME)) {
            throw new AttributeNotFoundException(name);
        }
        try {
            result = this.getAttributeInternal(name);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    private boolean isSpecialAMXAttr(String attrName) {
        return this.isObjectNameMapAttribute(attrName) || this.isObjectNameAttribute(attrName);
    }

    protected Object getAttributeInternal(String name) throws AttributeNotFoundException, ReflectionException, MBeanException {
        Object result = null;
        boolean handleManually = false;
        Method m = this.findGetter(name);
        if (m != null) {
            result = this.getAttributeByMethod(name, m);
            handleManually = false;
        } else if (this.isSpecialAMXAttr(name)) {
            handleManually = true;
        } else if (this.haveDelegate()) {
            this.trace("getAttribute: " + name + " HAVE DELEGATE ");
            if (this.getDelegate().supportsAttribute(name)) {
                try {
                    result = this.delegateGetAttribute(name);
                }
                catch (Exception e) {
                    this.trace("getAttribute: DELEGATE claims support, but fails: " + name);
                    handleManually = true;
                }
            } else {
                handleManually = true;
            }
        } else {
            handleManually = true;
        }
        if (handleManually) {
            this.trace("getAttribute: handle manually: " + name);
            try {
                result = this.getAttributeManually(name);
            }
            catch (AttributeNotFoundException e) {
                this.trace("getAttribute: " + name + " NOT FOUND ");
                throw e;
            }
        }
        return result;
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        this.trace("AMXImplBase.getAttributes: " + SmartStringifier.toString(names));
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                this.trace("%%% calling getAttribute: " + names[i] + " on " + this.getObjectName());
                Object value = this.getAttribute(names[i]);
                attrs.add(new Attribute(names[i], value));
                continue;
            }
            catch (Exception e) {
                System.out.println("### AttributeNotFoundException: " + names[i] + " for " + JMXUtil.toString(this.getObjectName()));
            }
        }
        return attrs;
    }

    private final void rethrowAttributeNotFound(Throwable t, String attrName) throws AttributeNotFoundException {
        Throwable rootCause = ExceptionUtil.getRootCause(t);
        if (rootCause instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)rootCause;
        }
        String msg = "Attribute not found: " + StringUtil.quote(attrName) + " [" + rootCause.getMessage() + "]";
        throw new AttributeNotFoundException(msg);
    }

    protected Object getAttributeByMethod(String attrName, Method m) throws AttributeNotFoundException {
        Object result = null;
        try {
            result = m.invoke((Object)this, (Object[])null);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.trace("InvocationTargetException: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(e, attrName);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.trace("ILLEGAL ACCESS TO: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(e, attrName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("Exception: " + attrName + " by " + m);
            this.rethrowAttributeNotFound(e, attrName);
        }
        return result;
    }

    protected void setAttributeByMethod(Attribute attr, Method m) throws AttributeNotFoundException, InvalidAttributeValueException {
        try {
            m.invoke((Object)this, attr.getValue());
        }
        catch (InvocationTargetException e) {
            this.trace("setAttributeByMethod: InvocationTargetException: " + e);
            Throwable t = ExceptionUtil.getRootCause(e);
            if (t instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)t;
            }
            this.rethrowAttributeNotFound(e, attr.getName());
        }
        catch (IllegalAccessException e) {
            this.trace("setAttributeByMethod: IllegalAccessException: " + e);
            this.rethrowAttributeNotFound(e, attr.getName());
        }
        catch (Exception e) {
            this.trace("setAttributeByMethod: Exception: " + e);
            this.rethrowAttributeNotFound(e, attr.getName());
        }
    }

    protected Object getAttributeManually(String attributeName) throws AttributeNotFoundException {
        Object result = null;
        AMXDebug.getInstance().getOutput("getAttributeManually").println(attributeName + " on " + this.getObjectName());
        if (this.isObjectNameAttribute(attributeName)) {
            String j2eeType = this.attributeNameToJ2EEType(attributeName);
            this.debug((Object)("getAttributeManually: attributeName " + attributeName + " => j2eeType " + j2eeType));
            result = this.getContainerSupport().getContaineeObjectName(j2eeType);
        } else if (this.isObjectNameMapAttribute(attributeName)) {
            String j2eeType = this.attributeNameToJ2EEType(attributeName);
            this.debug((Object)("invokeManually:  attributeName " + attributeName + " => j2eeType " + j2eeType));
            result = this.getContainerSupport().getContaineeObjectNameMap(j2eeType);
        } else {
            throw new AttributeNotFoundException(attributeName);
        }
        return result;
    }

    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        throw new AttributeNotFoundException(attr.getName());
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        String name = attr.getName();
        if (this.isReadOnlyAttribute(name)) {
            throw new IllegalArgumentException("Attribute is read-only: " + attr.getName());
        }
        boolean failure = true;
        try {
            this.setAttributeInternal(attr);
            failure = false;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvalidAttributeValueException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setAttributeInternal(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, ReflectionException, MBeanException {
        Object oldValue;
        this.trace("setAttribute: " + attr.getName() + " = " + attr.getValue());
        boolean handleManually = false;
        Method m = this.findSetter(attr);
        boolean shouldEmitNotifications = this.shouldEmitNotifications();
        Object object = oldValue = shouldEmitNotifications ? this.getAttribute(attr.getName()) : null;
        if (m != null) {
            this.setAttributeByMethod(attr, m);
        } else if (this.haveDelegate()) {
            if (this.getDelegate().supportsAttribute(attr.getName())) {
                AttributeList attrList = new AttributeList();
                attrList.add(attr);
                this.setAttributes(attrList);
                shouldEmitNotifications = false;
            } else {
                handleManually = true;
            }
        } else {
            handleManually = true;
        }
        if (handleManually) {
            this.setAttributeManually(attr);
        }
        if (shouldEmitNotifications) {
            String attrType = this.getAttributeType(attr.getName());
            this.sendAttributeChangeNotification("", attr.getName(), attrType, System.currentTimeMillis(), oldValue, attr.getValue());
        }
    }

    protected String asAMXAttributeName(String name) {
        return name;
    }

    protected final String getAttributeType(String attrName) {
        String amxName = this.asAMXAttributeName(attrName);
        MBeanAttributeInfo info = JMXUtil.getMBeanAttributeInfo(this.getMBeanInfo(), amxName);
        if (info == null) {
            this.logWarning("getAttributeType: unknown attribute: " + attrName);
        }
        return info == null ? String.class.getName() : info.getType();
    }

    protected synchronized void sendAttributeChangeNotification(String msg, String name, String attrType, long when, Object oldValue, Object newValue) {
        if (oldValue != null && !oldValue.equals(newValue)) {
            AttributeChangeNotificationBuilder builder = (AttributeChangeNotificationBuilder)this.getNotificationBuilder("jmx.attribute.change");
            AttributeChangeNotification n = builder.buildAttributeChange(msg, name, attrType, when, oldValue, newValue);
            System.out.println("AttributeChangeNotification: " + AttributeChangeNotificationStringifier.DEFAULT.stringify(n));
            this.sendNotification(n);
        }
    }

    protected void splitAttributes(AttributeList attrsIn, AttributeList delegatedAttrs, AttributeList otherAttrs) {
        if (this.haveDelegate()) {
            Delegate delegate = this.getDelegate();
            for (Object attrO : attrsIn) {
                Attribute attr = (Attribute)attrO;
                if (delegate.supportsAttribute(attr.getName())) {
                    delegatedAttrs.add(attr);
                    continue;
                }
                otherAttrs.add(attr);
            }
        } else {
            otherAttrs.addAll(attrsIn);
        }
    }

    private void sendAttributeChangeNotifications(AttributeList attrList, Map<String, Object> oldValues) {
        long when = System.currentTimeMillis();
        Map<String, String> attrsMap = JMXUtil.attributeListToStringMap(attrList);
        if (!((Object)attrsMap.keySet()).equals(oldValues.keySet())) {
            throw new IllegalArgumentException();
        }
        String msg = "";
        for (String attrName : attrsMap.keySet()) {
            String attrType = this.getAttributeType(attrName);
            Object oldValue = oldValues.get(attrName);
            String newValue = attrsMap.get(attrName);
            this.sendAttributeChangeNotification("", attrName, attrType, when, oldValue, newValue);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        AttributeList successList = new AttributeList();
        System.out.println("AMXImplBase.setAttributes = " + SmartStringifier.toString(attrs));
        AttributeList delegatedAttrs = new AttributeList();
        AttributeList otherAttrs = new AttributeList();
        this.splitAttributes(attrs, delegatedAttrs, otherAttrs);
        if (delegatedAttrs.size() != 0) {
            HashMap<String, Object> oldValues = new HashMap<String, Object>();
            AttributeList delegateSuccess = this.getDelegate().setAttributes(delegatedAttrs, oldValues);
            successList.addAll(delegateSuccess);
        }
        if (otherAttrs.size() != 0) {
            for (int i = 0; i < otherAttrs.size(); ++i) {
                Attribute attr = (Attribute)otherAttrs.get(i);
                try {
                    this.setAttribute(attr);
                    successList.add(attr);
                    continue;
                }
                catch (Exception e) {
                    this.debug((Object)ExceptionUtil.toString(e));
                }
            }
        }
        return successList;
    }

    protected final Method findMethod(String methodName, Class[] sig) {
        return ClassUtil.findMethod(this.getClass(), methodName, sig);
    }

    protected final Method findGetter(String name) {
        String methodName = "get" + name;
        Method m = this.findMethod(methodName, GETTER_SIG);
        if (m == null) {
            m = this.findMethod("is" + name, GETTER_SIG);
        }
        return m;
    }

    protected final Method findSetter(Attribute attr) {
        Object value = attr.getValue();
        Class<?> valueClass = null;
        if (value == null) {
            MBeanAttributeInfo info = this.getAttributeInfos().get(attr.getName());
            if (info != null) {
                try {
                    valueClass = ClassUtil.getClassFromName(info.getType());
                }
                catch (Exception e) {}
            }
        } else {
            valueClass = value.getClass();
        }
        if (valueClass == null) {
            return null;
        }
        String methodName = SET + attr.getName();
        Class[] sig = new Class[]{valueClass};
        Method setter = this.findMethod(methodName, sig);
        Class primitiveClass = ClassUtil.ObjectClassToPrimitiveClass(valueClass);
        if (setter == null && primitiveClass != valueClass) {
            sig[0] = primitiveClass;
            setter = this.findMethod(methodName, sig);
        }
        return setter;
    }

    protected boolean operationNameMatches(String operationName, String prefix, String suffix) {
        return operationName.startsWith(prefix) && operationName.endsWith(suffix);
    }

    protected boolean getterNameMatches(String operationName, String suffix) {
        return this.operationNameMatches(operationName, "get", suffix);
    }

    protected boolean isObjectNameGetter(String operationName, Object[] args, String[] types) {
        int numArgs = args == null ? 0 : args.length;
        return numArgs == 0 && this.isObjectNameGetter(operationName);
    }

    protected boolean isObjectNameGetter(String operationName) {
        return this.getterNameMatches(operationName, OBJECT_NAME_SUFFIX);
    }

    protected boolean isObjectNameAttribute(String attributeName) {
        return attributeName.endsWith(OBJECT_NAME_SUFFIX) && !NO_AUTO_GET.contains(attributeName);
    }

    protected boolean isObjectNameMapAttribute(String attributeName) {
        return attributeName.endsWith(OBJECT_NAME_MAP_SUFFIX) && !NO_AUTO_GET.contains(attributeName);
    }

    protected String attributeNameToJ2EEType(String attributeName) {
        String j2eeType = null;
        if (this.isObjectNameAttribute(attributeName)) {
            j2eeType = StringUtil.stripSuffix(attributeName, OBJECT_NAME_SUFFIX);
        } else if (this.isObjectNameMapAttribute(attributeName)) {
            j2eeType = StringUtil.stripSuffix(attributeName, OBJECT_NAME_MAP_SUFFIX);
        }
        if (!J2EETypes.ALL_STD.contains(j2eeType)) {
            j2eeType = "X-" + j2eeType;
        }
        return j2eeType;
    }

    protected boolean isObjectNameMapGetter(String operationName, Object[] args, String[] types) {
        int numArgs = args == null ? 0 : args.length;
        return numArgs == 0 && this.isObjectNameMapGetter(operationName);
    }

    protected boolean isObjectNameMapGetter(String operationName) {
        return this.getterNameMatches(operationName, OBJECT_NAME_MAP_SUFFIX);
    }

    protected String j2eeTypeToSimpleClassname(String j2eeType) {
        return StringUtil.stripPrefix(j2eeType, "X-");
    }

    protected String operationNameToJ2EEType(String operationName) {
        String j2eeType = null;
        if (this.isObjectNameGetter(operationName)) {
            j2eeType = StringUtil.stripPrefixAndSuffix(operationName, "get", OBJECT_NAME_SUFFIX);
        } else if (this.isObjectNameMapGetter(operationName)) {
            j2eeType = StringUtil.stripPrefixAndSuffix(operationName, "get", OBJECT_NAME_MAP_SUFFIX);
        }
        if (!J2EETypes.ALL_STD.contains(j2eeType)) {
            j2eeType = "X-" + j2eeType;
        }
        return j2eeType;
    }

    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        boolean handled = false;
        boolean ALLOW_GETTERS = true;
        if (numArgs == 0 && operationName.startsWith("get")) {
            String attributeName = StringUtil.stripPrefix(operationName, "get");
            if (this.getAttributeInfos().get(attributeName) != null) {
                result = this.getAttribute(attributeName);
                handled = true;
            }
        } else if (operationName.equals("toString") && numArgs == 0) {
            result = this.toString();
        }
        if (!handled) {
            this.debugMethod(operationName, args);
            throw new NoSuchMethodException("no operation " + operationName + AMXImplBase.toString(types) + " in " + this.getObjectName());
        }
        return result;
    }

    protected void handleException(Exception e) throws MBeanException, ReflectionException {
        ThrowableMapper mapper = new ThrowableMapper(e);
        Throwable mapped = mapper.map();
        if (mapped instanceof ReflectionException) {
            throw (ReflectionException)mapped;
        }
        if (mapped instanceof MBeanException) {
            throw (MBeanException)mapped;
        }
        if (!(mapped instanceof Exception)) {
            Exception wrapper = new Exception(mapped);
            throw new MBeanException(wrapper);
        }
        throw new MBeanException((Exception)mapped);
    }

    protected void handleGetAttributeException(Exception e) throws MBeanException, ReflectionException, AttributeNotFoundException {
        if (e instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)e;
        }
        this.handleException(e);
    }

    protected void handleInvokeThrowable(Exception e) throws MBeanException, ReflectionException {
        this.handleException(e);
    }

    @Override
    public final Object invoke(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException {
        Object result = null;
        boolean unimplemented = false;
        try {
            Class[] signature = ClassUtil.signatureFromClassnames(types);
            Method m = this.findMethod(operationName, signature);
            if (m != null) {
                this.debugMethod("invoking method: " + operationName, args);
                result = m.invoke((Object)this, args);
            } else if (this.haveDelegate() && this.getDelegate().supportsOperation(operationName, args, types)) {
                this.debug("AMXImplBase.invoke: calling delegate for ", operationName);
                result = this.getDelegate().invoke(operationName, args, types);
            } else {
                result = this.invokeManually(operationName, args, types);
            }
        }
        catch (Exception e) {
            this.debug((Object)ExceptionUtil.toString(e));
            this.handleInvokeThrowable(e);
        }
        return result;
    }

    protected final String getSelfJ2EEType() {
        return this.mJ2EEType;
    }

    protected String getSelfName() {
        return Util.getName(this.getObjectName());
    }

    private boolean isContainer() {
        return Container.class.isAssignableFrom(this.getInterface());
    }

    protected ObjectName getProgenyObjectName(String j2eeType, String name) {
        Container container = this.getContainer();
        Object containee = container.getContainee(j2eeType, name);
        if (containee == null) {
            throw new IllegalArgumentException("Not containee found: " + j2eeType + "=" + name);
        }
        return Util.getObjectName(containee);
    }

    protected boolean getOffline() {
        return false;
    }

    protected void unregisterMisc() {
    }

    @Override
    public String getGroup() {
        return "other";
    }

    @Override
    public String getName() {
        return Util.getName(this.getObjectName());
    }

    @Override
    public String getJ2EEType() {
        return Util.getJ2EEType(this.getObjectName());
    }

    @Override
    public final String getFullType() {
        return this.mFullType;
    }

    protected ObjectName preRegisterModifyName(MBeanServer server, ObjectName nameIn) {
        return nameIn;
    }

    @Override
    public final synchronized ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        ObjectName nameFromSuper = super.preRegister(server, nameIn);
        this.mConnectionSource = new MBeanServerConnectionSource(server);
        this.mDelegate = this.mSuppliedDelegate;
        this.mSelfObjectName = this.preRegisterModifyName(server, nameFromSuper);
        this.mSelfObjectName = this.preRegisterHook(this.mSelfObjectName);
        this.preRegisterDone();
        if (this.mSelfObjectName == null) {
            throw new IllegalArgumentException("null mSelfObjectName");
        }
        return this.mSelfObjectName;
    }

    protected ObjectName preRegisterHook(ObjectName selfObjectName) throws Exception {
        return selfObjectName;
    }

    protected void preRegisterDone() throws Exception {
        this.debug("AMXImplBase.preRegister() done for: ", this.getObjectName());
    }

    protected Set<String> getNotSuperfluousMethods() {
        return NOT_SUPERFLUOUS;
    }

    protected Set<String> getSuperfluousMethods() {
        Method[] methods;
        HashSet<String> items = new HashSet<String>();
        for (Method m : methods = this.getClass().getMethods()) {
            String name;
            String attributeName;
            if (!JMXUtil.isGetter(m) || !this.isObjectNameAttribute(attributeName = StringUtil.stripPrefix(name = m.getName(), "get")) && !this.isObjectNameMapAttribute(attributeName)) continue;
            items.add(name);
        }
        items.removeAll(NOT_SUPERFLUOUS);
        return items;
    }

    protected final void checkSuperfluousMethods() {
        Set<String> items = this.getSuperfluousMethods();
        items.removeAll(this.getNotSuperfluousMethods());
        if (items.size() != 0) {
            String LINE_SEP = System.getProperty("line.separator");
            String msg = "The following methods in " + this.getJ2EEType() + " are probably superfluous:" + LINE_SEP + CollectionUtil.toString(items, LINE_SEP) + LINE_SEP;
            AMXDebug.getInstance().getOutput("AMXImplBase.checkSuperfluousMethods").println(msg);
            this.logFine(msg);
        }
    }

    private AMXImplBase getContainerObject() {
        MBeanServer mbeanServer;
        ObjectName objectName;
        AMXImplBase containerObject = null;
        ObjectName containerObjectName = this.getContainerObjectName();
        if (containerObjectName == null && !"X-DomainRoot".equals(this.mJ2EEType)) {
            System.err.println("ContainerObjectName is null for: " + this.getObjectName());
        }
        if ((objectName = this.getObjectName()) == null) {
            System.err.println("ObjectName is null, container = " + containerObjectName);
        }
        if ((mbeanServer = this.getMBeanServer()) == null) {
            System.err.println("MBeanServer is null for: " + this.getObjectName());
        }
        if (containerObjectName != null && mbeanServer.isRegistered(containerObjectName)) {
            try {
                containerObject = AMXImplBase.__getObjectRef__(this.getMBeanServer(), containerObjectName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return containerObject;
    }

    @Override
    protected synchronized void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            AMXImplBase containerObject = this.getContainerObject();
            if (this.getContainerObjectName() == null && this.getInterface() != DomainRoot.class) {
                System.out.println("postRegister: containerObject null for " + this.getObjectName());
            }
            if (containerObject != null) {
                containerObject.getContainerSupport().containeeRegistered(this.getObjectName());
            }
        }
    }

    public static AMXImplBase __getObjectRef__(MBeanServer mbeanServer, ObjectName objectName) {
        try {
            Object value = mbeanServer.getAttribute(objectName, OBJECT_REF_ATTR_NAME);
            return (AMXImplBase)AMXImplBase.class.cast(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public AMXImplBase get__ObjectRef() {
        return this;
    }

    public AMXImplBase get__ObjectRef(ObjectName objectName) {
        if (objectName.equals(this.getObjectName())) {
            return this;
        }
        return AMXImplBase.__getObjectRef__(this.getMBeanServer(), objectName);
    }

    @Override
    protected void preDeregisterHook() throws Exception {
        super.preDeregisterHook();
    }

    @Override
    protected void postDeregisterHook() {
        AMXImplBase containerObject = this.getContainerObject();
        if (containerObject != null) {
            containerObject.getContainerSupport().containeeUnregistered(this.getObjectName());
        }
        super.postDeregisterHook();
    }

    public final ObjectName getDomainRootObjectName() {
        return Util.getObjectName(this.getDomainRoot());
    }

    public ObjectName getQueryMgrObjectName() {
        ObjectName objectName = null;
        if (this.mQueryMgr != null) {
            objectName = Util.getObjectName(this.mQueryMgr);
        } else {
            MBeanServer server = this.getMBeanServer();
            String domainName = this.getObjectName().getDomain();
            objectName = QueryMgrImpl.querySingletonJ2EETypeObjectName(server, domainName, "X-QueryMgr");
        }
        assert (objectName != null) : "getQueryMgrObjectName failed";
        return objectName;
    }

    protected ConnectionSource getMBeanServerConnectionSource() {
        return this.mConnectionSource;
    }

    protected final synchronized AMX getSelf() {
        if (this.mSelfProxy == null) {
            ObjectName selfObjectName = this.getObjectName();
            assert (selfObjectName != null);
            this.mSelfProxy = this.getProxyFactory().getProxy(selfObjectName, AMX.class);
            assert (this.mSelfProxy != null);
        }
        return this.mSelfProxy;
    }

    protected final <T> T getSelf(Class<T> theClass) {
        return theClass.cast(this.getSelf());
    }

    protected Container getSelfAsContainer() {
        return this.getSelf(Container.class);
    }

    @Override
    public final DomainRoot getDomainRoot() {
        return this.getProxyFactory().getDomainRoot();
    }

    protected final QueryMgr getQueryMgr() {
        if (this.mQueryMgr != null) {
            return this.mQueryMgr;
        }
        ObjectName objectName = this.getQueryMgrObjectName();
        if (objectName != null) {
            this.mQueryMgr = this.getProxyFactory().getProxy(objectName, QueryMgr.class);
        }
        return this.mQueryMgr;
    }

    private static String makeType(String parentType, String subType) {
        String result = null;
        result = parentType == null || parentType.length() == 0 ? subType : parentType + "." + subType;
        return result;
    }

    protected Object getAttribute(ObjectName objectName, String name) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException {
        return this.getMBeanServer().getAttribute(objectName, name);
    }

    protected AttributeList getAttributes(ObjectName objectName, String[] names) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException {
        return this.getMBeanServer().getAttributes(objectName, names);
    }

    protected void setAttribute(ObjectName objectName, Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, InstanceNotFoundException, ReflectionException, MBeanException {
        this.getMBeanServer().setAttribute(objectName, attr);
    }

    protected AttributeList setAttributes(ObjectName objectName, AttributeList attrs) throws AttributeNotFoundException, InvalidAttributeValueException, InstanceNotFoundException, ReflectionException, MBeanException {
        return this.getMBeanServer().setAttributes(objectName, attrs);
    }

    protected ObjectName registerMBean(Object mbean, ObjectName name) throws MalformedObjectNameException, InstanceAlreadyExistsException, NotCompliantMBeanException, MBeanRegistrationException {
        return this.getMBeanServer().registerMBean(mbean, name).getObjectName();
    }

    protected String stringify(Object o) {
        return SmartStringifier.toString(o);
    }

    public String toString() {
        return this.getImplString(false);
    }

    public String getImplString(boolean verbose) {
        String NEWLINE = System.getProperty("line.separator");
        String s = this.getClass().getName() + NEWLINE + MBeanInfoStringifier.DEFAULT.stringify(this.getMBeanInfo()) + NEWLINE;
        if (verbose) {
            AttributeList attrs = this.getAttributes(this.getAttributeNames());
            Map<String, Object> m = JMXUtil.attributeListToValueMap(attrs);
            s = NEWLINE + s + MapUtil.toString(m, NEWLINE + NEWLINE) + NEWLINE;
        }
        return s;
    }

    @Override
    public boolean isDAS() {
        Issues.getAMXIssues().notDone("AMXImplBase: how to determine if this is the DAS?");
        return true;
    }

    protected void addContainee(ObjectName objectName) {
        this.getContainerSupport().addContainee(objectName);
    }

    protected void removeContainee(ObjectName objectName) {
        this.getContainerSupport().removeContainee(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerSupport getContainerSupport() {
        if (this.mContainerSupport != null) {
            return this.mContainerSupport;
        }
        if (!this.isContainer()) {
            throw new UnsupportedOperationException("MBean " + StringUtil.quote(this.getObjectName()) + " is not an AMX 'Container'");
        }
        AMXImplBase aMXImplBase = this;
        synchronized (aMXImplBase) {
            if (this.mContainerSupport == null) {
                this.mContainerSupport = new ContainerSupport(this.getMBeanServer(), this.getObjectName());
            }
        }
        return this.mContainerSupport;
    }

    public Set<String> getContaineeJ2EETypes() {
        Set<String> j2eeTypes = this.getContainerSupport().getContaineeJ2EETypes();
        return j2eeTypes;
    }

    public Map<String, Map<String, ObjectName>> getMultiContaineeObjectNameMap(Set<String> j2eeTypes) {
        return this.getContainerSupport().getMultiContaineeObjectNameMap(j2eeTypes);
    }

    public Map<String, ObjectName> getContaineeObjectNameMap(String j2eeType) {
        return this.getContainerSupport().getContaineeObjectNameMap(j2eeType);
    }

    public ObjectName getContaineeObjectName(String j2eeType) {
        return this.getContainerSupport().getContaineeObjectName(j2eeType);
    }

    public Set<ObjectName> getContaineeObjectNameSet(String j2eeType) {
        return this.getContainerSupport().getContaineeObjectNameSet(j2eeType);
    }

    public Set<ObjectName> getContaineeObjectNameSet() {
        return this.getContainerSupport().getContaineeObjectNameSet();
    }

    public Set<ObjectName> getContaineeObjectNameSet(Set<String> j2eeTypes) {
        return this.getContainerSupport().getContaineeObjectNameSet(j2eeTypes);
    }

    public Set<ObjectName> getByNameContaineeObjectNameSet(Set<String> j2eeTypes, String name) {
        return this.getContainerSupport().getByNameContaineeObjectNameSet(j2eeTypes, name);
    }

    public ObjectName getContaineeObjectName(String j2eeType, String name) {
        return this.getContainerSupport().getContaineeObjectName(j2eeType, name);
    }
}

