/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.AMXDebugSupportMBean;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.FileUtils;
import java.io.File;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.loader.BootUtil;

public final class AMXDebugSupport
implements AMXDebugSupportMBean {
    private final MBeanServer mServer;
    public static final String NAME = "debug";

    public static ObjectName getObjectName() {
        String domain = BootUtil.getInstance().getAMXSupportJMXDomain();
        String props = Util.makeNameProp(NAME);
        ObjectName objectName = Util.newObjectName(domain, props);
        return objectName;
    }

    public AMXDebugSupport(MBeanServer server) {
        this.mServer = server;
    }

    private AMXDebug getAMXDebug() {
        return AMXDebug.getInstance();
    }

    public String[] getOutputIDs() {
        return AMXDebug.getInstance().getOutputIDs();
    }

    public boolean getDefaultDebug() {
        return this.getAMXDebug().getDefaultDebug();
    }

    public void setDefaultDebug(boolean debug) {
        this.getAMXDebug().setDefaultDebug(debug);
    }

    public boolean getDebug(String id) {
        return this.getAMXDebug().getDebug(id);
    }

    public void setDebug(String id, boolean debug) {
        this.getAMXDebug().setDebug(id, debug);
    }

    public void setAll(boolean debug) {
        this.getAMXDebug().setAll(debug);
    }

    public void cleanup() {
        this.getAMXDebug().cleanup();
    }

    public String getOutputFrom(String id) {
        String output = "";
        File f = this.getAMXDebug().getOutputFile(id);
        if (f != null && f.exists()) {
            try {
                output = FileUtils.fileToString(f);
            }
            catch (Exception e) {
                output = "";
            }
        }
        return output;
    }
}

