/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.util.ArrayList;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.admin.mbeanserver.BooterMBean;
import org.glassfish.admin.mbeanserver.Util;
import org.jvnet.hk2.component.Habitat;

final class Booter
implements BooterMBean {
    private final MBeanServer mMBeanServer;
    private final ObjectName mObjectName;
    private final Habitat mHabitat;
    private ObjectName mDomainRootObjectName;

    private static void debug(String s) {
        System.out.println(s);
    }

    private Booter(Habitat habitat, MBeanServer mbeanServer) {
        this.mHabitat = habitat;
        this.mMBeanServer = mbeanServer;
        this.mObjectName = BooterMBean.OBJECT_NAME;
        this.mDomainRootObjectName = null;
        if (this.mMBeanServer.isRegistered(this.mObjectName)) {
            throw new IllegalStateException();
        }
    }

    public static synchronized Booter create(Habitat habitat, MBeanServer server) {
        Booter booter = new Booter(habitat, server);
        ObjectName objectName = BooterMBean.OBJECT_NAME;
        try {
            if (!server.registerMBean(booter, objectName).getObjectName().equals(objectName)) {
                throw new IllegalStateException();
            }
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
        return booter;
    }

    public synchronized ObjectName bootAMX() {
        if (this.mDomainRootObjectName == null) {
            Booter.debug("Booter.bootAMX: getting AMXStartupServiceMBean via contract");
            AMXStartupServiceMBean loader = this.mHabitat.getByContract(AMXStartupServiceMBean.class);
            Booter.debug("Booter.bootAMX: assuming that amx-impl loads through other means");
            ObjectName startupON = AMXStartupServiceMBean.OBJECT_NAME;
            if (!this.mMBeanServer.isRegistered(startupON)) {
                Booter.debug("AMX MBean not yet available: " + startupON);
                throw new IllegalStateException("AMX MBean not yet available: " + startupON);
            }
            try {
                Booter.debug("Booter.bootAMX: invoking startAMX() on " + startupON);
                this.mDomainRootObjectName = (ObjectName)this.mMBeanServer.invoke(startupON, "startAMX", null, null);
                Booter.debug("Booter.bootAMX: domainRoot = " + this.mDomainRootObjectName);
            }
            catch (JMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.mDomainRootObjectName;
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        ObjectName queryPattern = Util.newObjectName("jmxremote:type=jmx-connector,*");
        Set<ObjectName> objectNames = this.mMBeanServer.queryNames(queryPattern, null);
        ArrayList<JMXServiceURL> urls = new ArrayList<JMXServiceURL>();
        for (ObjectName objectName : objectNames) {
            try {
                urls.add((JMXServiceURL)this.mMBeanServer.getAttribute(objectName, "Address"));
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        }
        return urls.toArray(new JMXServiceURL[urls.size()]);
    }
}

