/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.datatree.impl;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode
implements TreeNode {
    protected Map<String, TreeNode> children = new ConcurrentHashMap<String, TreeNode>();
    protected String name;
    protected Object instance;
    protected String category;
    protected boolean enabled = false;
    private static char NAME_SEPARATOR = (char)46;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new RuntimeException("Flashlight-utils: Tree Node needs a non-null name");
        }
        this.name = name;
    }

    @Override
    public Object getValue() {
        if (this.enabled) {
            return this.instance;
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new RuntimeException("Flashlight-utils: Tree Node needs a non-null value");
        }
        this.instance = value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public TreeNode addChild(TreeNode newChild) {
        return this.children.put(newChild.getName(), newChild);
    }

    @Override
    public Collection<TreeNode> getChildNodes() {
        return this.children.values();
    }

    public Enumeration<TreeNode> getChildNodesImmutable() {
        return ((ConcurrentHashMap)this.children).elements();
    }

    @Override
    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    @Override
    public void removeChild(TreeNode oldChild) {
        String child = oldChild.getName();
        if (child != null) {
            this.children.remove(child);
        }
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public TreeNode getChild(String childName) {
        if (childName == null) {
            return null;
        }
        return this.children.get(childName);
    }

    @Override
    public TreeNode getNode(String completeName) {
        if (completeName == null) {
            return null;
        }
        char regex = NAME_SEPARATOR;
        String split = completeName.replace(regex, ':');
        String[] tokens = split.split(":");
        TreeNode n = null;
        if (tokens.length == 1) {
            if (this.getName().equals(tokens[0])) {
                n = this;
            }
        } else {
            n = this.findNodeInTree(this.dropFirstStringToken(tokens));
        }
        return n;
    }

    public TreeNode findNodeInTree(String[] tokens) {
        if (tokens == null) {
            return null;
        }
        TreeNode child = this.getChild(tokens[0]);
        if (child == null) {
            return null;
        }
        if (tokens.length > 1) {
            child = ((AbstractTreeNode)child).findNodeInTree(this.dropFirstStringToken(tokens));
        }
        return child;
    }

    private String[] dropFirstStringToken(String[] token) {
        if (token.length == 0) {
            return null;
        }
        if (token.length == 1) {
            return null;
        }
        String[] newToken = new String[token.length - 1];
        for (int i = 0; i < newToken.length; ++i) {
            newToken[i] = token[i + 1];
        }
        return newToken;
    }
}

