/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.flashlight.impl.core.Probe;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ProbeRegistry {
    private static ProbeRegistry _me = new ProbeRegistry();
    private ConcurrentHashMap<Integer, Probe> probeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Probe> probeDesc2ProbeMap = new ConcurrentHashMap();

    public static ProbeRegistry getInstance() {
        return _me;
    }

    public void registerProbe(Probe probe) {
        this.probeMap.put(probe.getId(), probe);
        this.probeDesc2ProbeMap.put(probe.getProbeStr(), probe);
    }

    public void unregisterProbe(Probe probe) {
        this.probeMap.remove(probe.getId());
    }

    public void unregisterProbe(int id) {
        this.probeMap.remove(id);
    }

    public Probe getProbe(int id) {
        return this.probeMap.get(id);
    }

    public Probe getProbe(String probeStr) {
        return this.probeDesc2ProbeMap.get(probeStr);
    }

    public static Probe getProbeById(int id) {
        return _me.getProbe(id);
    }
}

