/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.statistics.impl;

import java.util.concurrent.atomic.AtomicLongArray;
import org.glassfish.flashlight.datatree.impl.AbstractTreeNode;
import org.glassfish.flashlight.statistics.Average;

public class AverageImpl
extends AbstractTreeNode
implements Average {
    int bucketSize = 100;
    int current = 0;
    boolean flagQFilledOnce = false;
    long min = 0L;
    long max = 0L;
    boolean firstDataPointAdded = false;
    private static final String NAME = "average";
    double average = 0.0;
    AtomicLongArray queue;

    public AverageImpl(int size) {
        this.bucketSize = size;
        this.queue = new AtomicLongArray(size);
        this.name = NAME;
        this.instance = this;
        this.enabled = true;
    }

    public void setBucketSize(int bucketSize) {
        this.setReset(bucketSize);
        this.resizeQueue(bucketSize);
    }

    public int getSize() {
        return this.queue.length();
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public void addDataPoint(long value) {
        if (!this.firstDataPointAdded) {
            this.min = this.max = value;
            this.firstDataPointAdded = true;
        }
        if (this.current == this.bucketSize) {
            this.current = 0;
        }
        this.queue.set(this.current++, value);
        if (value < this.min) {
            this.min = value;
        } else if (value > this.max) {
            this.max = value;
        }
    }

    public double getRunningAverage() {
        double sum = 0.0;
        int length = this.flagQFilledOnce ? this.queue.length() : this.current;
        this.flagQFilledOnce = length == this.queue.length();
        for (int i = 0; i < length; ++i) {
            sum += (double)this.queue.get(i);
        }
        this.average = sum / (double)length;
        return this.average;
    }

    public void setReset(int size) {
        this.queue = null;
        this.queue = new AtomicLongArray(size);
        this.flagQFilledOnce = false;
    }

    private void resizeQueue(int size) {
        this.chopOrExpand(size);
    }

    private void chopOrExpand(int size) {
        AtomicLongArray tmp = this.queue;
        this.queue = new AtomicLongArray(size);
        if (this.queue.length() <= tmp.length()) {
            for (int i = this.queue.length() - 1; i >= 0; --i) {
                this.queue.set(i, tmp.get(i));
                this.flagQFilledOnce = true;
                this.current = 0;
            }
        } else {
            int i = 0;
            while (i < tmp.length()) {
                this.queue.set(i, tmp.get(i));
                this.flagQFilledOnce = false;
                this.current = i++;
            }
        }
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getMinInCurrentDataSet() {
        long mini = 0L;
        for (int i = 0; i < this.queue.length(); ++i) {
            if (i == 0) {
                mini = this.queue.get(0);
                continue;
            }
            long tmp = this.queue.get(i);
            if (tmp >= mini) continue;
            mini = tmp;
        }
        return mini;
    }

    public long getMaxInCurrentDataSet() {
        long maxi = 0L;
        for (int i = 0; i < this.queue.length(); ++i) {
            if (i == 0) {
                maxi = this.queue.get(0);
                continue;
            }
            long tmp = this.queue.get(i);
            if (tmp <= maxi) continue;
            maxi = tmp;
        }
        return maxi;
    }

    public String toString() {
        return this.queue.toString();
    }

    public Object getValue() {
        return this.getRunningAverage();
    }
}

