/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.statistics.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.flashlight.datatree.impl.AbstractTreeNode;
import org.glassfish.flashlight.statistics.Counter;

public class CounterImpl
extends AbstractTreeNode
implements Counter {
    private AtomicLong count = new AtomicLong(0L);
    long max = 0L;
    long min = 0L;
    private static final String NAME = "counter";

    public CounterImpl() {
        super.setName(NAME);
        super.setEnabled(true);
    }

    public long getCount() {
        return this.count.get();
    }

    public void setCount(long count) {
        if (count > this.max) {
            this.max = count;
        } else {
            this.min = count;
        }
        this.count.set(count);
    }

    public void increment() {
        long cnt = this.count.incrementAndGet();
        if (cnt > this.max) {
            this.max = cnt;
        }
    }

    public void decrement() {
        long cnt = this.count.decrementAndGet();
        if (cnt < this.min) {
            this.min = cnt;
        }
    }

    public void setReset(boolean reset) {
        if (reset) {
            this.count.set(0L);
        }
    }

    public Object getValue() {
        return this.getCount();
    }
}

