/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.statistics.impl;

import org.glassfish.flashlight.datatree.impl.AbstractTreeNode;
import org.glassfish.flashlight.statistics.TimeStats;

public abstract class TimeStatsAbstractImpl
extends AbstractTreeNode
implements TimeStats {
    protected long entryTime = 0L;
    protected long exitTime = 0L;
    long time = 0L;
    long low = -1L;
    long high = -1L;
    long sum = 0L;
    int count = 0;

    public long getTime() {
        return this.time;
    }

    public abstract void entry();

    public abstract void exit();

    public void postExit() {
        this.time = this.exitTime - this.entryTime;
        this.setLowAndHigh(this.time);
        ++this.count;
    }

    private void setLowAndHigh(long time) {
        if (this.low == -1L && this.high == -1L) {
            this.low = this.high = time;
        }
        if (time < this.low) {
            this.low = time;
        }
        if (time > this.high) {
            this.high = time;
        }
    }

    public long getMinimumTime() {
        return this.low;
    }

    public long getMaximumTime() {
        return this.high;
    }

    public void setTime(long time) {
        this.time = time;
        this.setLowAndHigh(time);
    }

    public void setReset(boolean reset) {
        this.entryTime = 0L;
        this.time = 0L;
        this.low = 0L;
        this.high = 0L;
        this.count = 0;
    }

    public long getTimesCalled() {
        return this.count;
    }
}

