/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-virtual-server")
@Scoped(value=PerLookup.class)
@I18n(value="delete.virtual.server")
public class DeleteVirtualServer
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteVirtualServer.class);
    @Param(name="virtual_server_id", primary=true)
    String vsid;
    @Inject
    HttpService httpService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.exists()) {
            report.setMessage(localStrings.getLocalString("delete.virtual.server.notexists", "{0} doesn't exist", this.vsid));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new Config(this.vsid), this.httpService);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.virtual.server.fail", "{0} delete failed ", this.vsid));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    private boolean exists() {
        if (this.vsid == null) {
            return false;
        }
        List<VirtualServer> list = this.httpService.getVirtualServer();
        for (VirtualServer vs : list) {
            String currId = vs.getId();
            if (currId == null || !currId.equals(this.vsid)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Config
    implements SingleConfigCode<HttpService> {
        private String vsid;

        private Config(String vsid) {
            this.vsid = vsid;
        }

        @Override
        public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
            List<VirtualServer> list = param.getVirtualServer();
            for (VirtualServer item : list) {
                String currId = item.getId();
                if (currId == null || !currId.equals(this.vsid)) continue;
                list.remove(item);
                break;
            }
            return list;
        }
    }
}

