/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.common_impl.Jar;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class OSGiModuleDefinition
implements ModuleDefinition {
    private String name;
    private URI location;
    private String version;
    private String lifecyclePolicyClassName;
    private Manifest manifest;
    private ModuleMetadata metadata = new ModuleMetadata();

    public OSGiModuleDefinition(File jar) throws IOException {
        Jar jarFile = Jar.create(jar);
        this.location = jar.toURI();
        this.manifest = jarFile.getManifest();
        Attributes mainAttr = this.manifest.getMainAttributes();
        this.name = mainAttr.getValue("Bundle-SymbolicName");
        this.version = mainAttr.getValue("Bundle-Version");
        if (this.version == null) {
            this.version = "0.0.0";
        }
        this.lifecyclePolicyClassName = mainAttr.getValue("HK2-Module-Lifecycle-Policy");
        jarFile.loadMetadata(this.metadata);
    }

    public String getName() {
        return this.name;
    }

    public String[] getPublicInterfaces() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    public ModuleDependency[] getDependencies() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    public URI[] getLocations() {
        return new URI[]{this.location};
    }

    public String getVersion() {
        return this.version;
    }

    public String getImportPolicyClassName() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    public String getLifecyclePolicyClassName() {
        return this.lifecyclePolicyClassName;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        String bundleDescriptiveName = this.manifest.getMainAttributes().getValue("Bundle-Name");
        return this.name + "(" + bundleDescriptiveName + ")" + ':' + this.version;
    }
}

