/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.Log;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.FileFilter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopDomainCommand
extends AbstractCommand {
    private File domainsDir;
    private File domainRootDir;
    private String domainName;
    private File domainXml;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.getDomainRootDir();
        this.getDomainXml();
        this.domainRootDir = SmartFile.sanitize(this.domainRootDir);
        Integer[] ports = null;
        try {
            MiniXmlParser parser = new MiniXmlParser(this.domainXml);
            Set<Integer> portsSet = parser.getAdminPorts();
            ports = portsSet.toArray(new Integer[portsSet.size()]);
        }
        catch (MiniXmlParserException ex) {
            throw new CommandValidationException(strings.get("StopDomain.parserError", ex), ex);
        }
        int adminPort = ports[0];
        if (!CLIRemoteCommand.pingDASQuietly(adminPort)) {
            throw new CommandValidationException(strings.get("StopDomain.dasNotRunning"));
        }
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            CLIRemoteCommand rc = new CLIRemoteCommand(this.getCmd("" + adminPort));
            rc.runCommand();
            this.waitForDeath(adminPort);
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    @Override
    public boolean validateOptions() throws CommandValidationException {
        String domaindir;
        super.validateOptions();
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.firstElement();
        }
        if (StopDomainCommand.ok(domaindir = this.getOption("domaindir"))) {
            this.domainsDir = new File(domaindir);
            if (!this.domainsDir.isDirectory()) {
                throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", this.domainsDir));
            }
        }
        return true;
    }

    private String[] getCmd(String port) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("stop-domain");
        cmd.add("--port");
        cmd.add(port);
        this.addOption(cmd, "user");
        this.addOption(cmd, "passwordfile");
        this.addOption(cmd, "force");
        return cmd.toArray(new String[cmd.size()]);
    }

    private void addOption(List<String> cmd, String option) {
        String value = this.getOption(option);
        if (value != null) {
            cmd.add("--" + option);
            cmd.add(value);
        }
    }

    private void getDomainRootDir() throws CommandValidationException {
        if (this.domainsDir == null) {
            this.domainsDir = new File(this.getSystemProperty("com.sun.aas.domainsRoot"));
        }
        if (!this.domainsDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", this.domainsDir));
        }
        this.domainRootDir = this.domainName != null ? new File(this.domainsDir, this.domainName) : this.getTheOneAndOnlyDomain(this.domainsDir);
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainDir", this.domainRootDir));
        }
    }

    private void getDomainXml() throws CommandValidationException {
        this.domainXml = new File(this.domainRootDir, "config/domain.xml");
        if (!this.domainXml.canRead()) {
            throw new CommandValidationException(strings.get("StopDomain.noDomainXml", this.domainXml));
        }
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandValidationException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandValidationException(strings.get("noDomainDirs", parent));
        }
        if (files.length > 1) {
            throw new CommandValidationException(strings.get("StopDomain.tooManyDomainDirs", parent));
        }
        return files[0];
    }

    private void waitForDeath(int adminPort) throws CommandException {
        long startWait = System.currentTimeMillis();
        System.err.print(strings.get("StopDomain.WaitDASDeath") + " ");
        boolean alive = true;
        while (!this.timedOut(startWait)) {
            if (!this.pingPort(adminPort)) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                System.err.print(".");
            }
            catch (InterruptedException ex) {}
        }
        System.err.println("");
        if (alive) {
            throw new CommandException(strings.get("StopDomain.DASNotDead", 60L));
        }
    }

    private boolean pingPort(int port) {
        try {
            String host = null;
            new Socket(host, port);
            return true;
        }
        catch (Exception ex) {
            Log.finer("pingPort got Exception: " + ex, new Object[0]);
            return false;
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

