/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup.util;

import com.sun.enterprise.backup.util.FileListerRelative;
import com.sun.enterprise.backup.util.FileUtils;
import com.sun.enterprise.backup.util.ZipFileException;
import com.sun.enterprise.backup.util.ZipItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipWriter {
    private String dirName = null;
    private ZipOutputStream zipStream = null;
    private byte[] buffer = new byte[16384];
    private ZipItem[] items = null;

    public ZipWriter(String zipFilename, String dirName) throws ZipFileException {
        this.init(zipFilename, dirName);
        this.createItemList(null);
    }

    public ZipWriter(String zipFilename, String dirName, ZipItem[] theItems) throws ZipFileException {
        this.items = theItems;
        this.init(zipFilename, dirName);
    }

    public ZipWriter(String zipFilename, String dirName, String[] fileList) throws ZipFileException {
        this.init(zipFilename, dirName);
        this.createItemList(fileList);
    }

    public ZipWriter(OutputStream outStream, String dirName, String[] fileList) throws ZipFileException {
        this.init(outStream, dirName);
        this.createItemList(fileList);
    }

    public void excludeDirs(String[] dirs) {
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].endsWith("/")) continue;
            int n = i;
            dirs[n] = dirs[n] + "/";
        }
        ArrayList<ZipItem> list = new ArrayList<ZipItem>(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            for (int j = 0; j < dirs.length; ++j) {
                if (this.items[i].name.startsWith(dirs[j])) continue;
                list.add(this.items[i]);
            }
        }
        if (list.size() != this.items.length) {
            this.items = new ZipItem[list.size()];
            this.items = list.toArray(this.items);
        }
    }

    private void init(String outFileName, String dirName) throws ZipFileException {
        try {
            this.init(new FileOutputStream(outFileName), dirName);
        }
        catch (Exception e) {
            throw new ZipFileException(e);
        }
    }

    private void init(OutputStream outStream, String dirName) throws ZipFileException {
        try {
            File f = new File(dirName);
            dirName = FileUtils.safeGetCanonicalPath(f);
            dirName = dirName.replace('\\', '/');
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            this.dirName = dirName;
            this.zipStream = new ZipOutputStream(outStream);
        }
        catch (Throwable t) {
            throw new ZipFileException(t);
        }
    }

    public void safeWrite() throws ZipFileException {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                try {
                    this.addEntry(this.items[i]);
                    continue;
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
            }
            this.zipStream.close();
        }
        catch (ZipFileException z) {
            throw z;
        }
        catch (Exception e) {
            throw new ZipFileException(e);
        }
    }

    public void write() throws ZipFileException {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                this.addEntry(this.items[i]);
            }
            this.zipStream.close();
        }
        catch (ZipFileException z) {
            throw z;
        }
        catch (Exception e) {
            throw new ZipFileException(e);
        }
    }

    private void addEntry(ZipItem item) throws ZipFileException, IOException {
        int totalBytes = 0;
        ZipEntry ze = new ZipEntry(item.name);
        this.zipStream.putNextEntry(ze);
        if (!item.name.endsWith("/")) {
            FileInputStream in = new FileInputStream(item.file);
            int numBytes = in.read(this.buffer);
            while (numBytes > 0) {
                this.zipStream.write(this.buffer, 0, numBytes);
                totalBytes += numBytes;
                numBytes = in.read(this.buffer);
            }
            in.close();
        }
        this.zipStream.closeEntry();
    }

    private void createItemList(String[] files) throws ZipFileException {
        try {
            if (files == null) {
                FileListerRelative lister = new FileListerRelative(new File(this.dirName));
                files = lister.getFiles();
            }
            if (files.length <= 0) {
                throw new ZipFileException("No files to add!");
            }
            this.items = new ZipItem[files.length];
            for (int i = 0; i < files.length; ++i) {
                File f = new File(this.dirName + files[i]);
                this.items[i] = new ZipItem(f, files[i].replace('\\', '/'));
                if (!f.isDirectory()) continue;
                this.items[i].name = this.items[i].name + "/";
            }
        }
        catch (Throwable t) {
            throw new ZipFileException(t);
        }
    }

    String getDirName() {
        return this.dirName;
    }

    private static void usage() {
        System.out.println("usage: java com.elf.util.zip.ZipWriter zip-filename directory-name");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            ZipWriter.usage();
        }
        try {
            ZipWriter zw = new ZipWriter(args[0], args[1]);
            zw.write();
        }
        catch (ZipFileException e) {
            System.exit(0);
        }
    }
}

