/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.spi.ManagedConnectionFactory;
import org.glassfish.api.naming.NamingObjectProxy;

public class ConnectorObjectFactory
implements NamingObjectProxy {
    private ConnectorRuntime runtime;
    private String jndiName;
    private String poolName;
    private String moduleName;
    private String connectionFactoryName;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");

    public ConnectorObjectFactory(String jndiName, String connectionFactoryName, String moduleName, String poolName) {
        this.jndiName = jndiName;
        this.moduleName = moduleName;
        this.poolName = poolName;
        this.connectionFactoryName = connectionFactoryName;
        this.runtime = ConnectorRuntime.getRuntime();
    }

    public boolean isCreateResultCacheable() {
        return false;
    }

    public Object create(Context ic) throws NamingException {
        Object cf = null;
        try {
            ManagedConnectionFactory mcf = this.getRuntime().obtainManagedConnectionFactory(this.poolName);
            if (mcf == null) {
                _logger.log(Level.FINE, "Failed to create MCF ", this.poolName);
                throw new ConnectorRuntimeException("Failed to create MCF");
            }
            boolean forceNoLazyAssoc = false;
            if (this.jndiName.endsWith("__pm")) {
                forceNoLazyAssoc = true;
            }
            String derivedJndiName = ConnectorsUtil.deriveJndiName(this.jndiName, ic.getEnvironment());
            ConnectionManagerImpl mgr = (ConnectionManagerImpl)this.getRuntime().obtainConnectionManager(this.poolName, forceNoLazyAssoc);
            mgr.setJndiName(derivedJndiName);
            mgr.setRarName(this.moduleName);
            mgr.initialize();
            cf = mcf.createConnectionFactory(mgr);
            if (cf == null) {
                String msg = "No resource adapter found";
                throw new RuntimeException(new ConfigurationException(msg));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection Factory:" + cf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cf;
    }

    private ConnectorRuntime getRuntime() {
        return this.runtime;
    }
}

