/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.deployment.DeploymentContextImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.ServerEnvironmentImpl;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.data.ApplicationInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="undeploy")
@I18n(value="undeploy.command")
public class UndeployCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UndeployCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Param(primary=true, name="name")
    String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    Boolean keepreposdir;

    public void execute(AdminCommandContext context) {
        Properties parameters = context.getCommandParameters();
        ActionReport report = context.getActionReport();
        this.name = new File(this.name).getName();
        parameters.setProperty("name", this.name);
        ApplicationInfo info = this.appRegistry.get(this.name);
        Module module = ConfigBeansUtilities.getModule(this.name);
        Application application = null;
        if (module instanceof Application) {
            application = (Application)module;
        }
        if (module == null) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", this.name));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive source = null;
        if (info == null) {
            if (application != null) {
                File location = new File(application.getLocation());
                if (location.exists()) {
                    try {
                        source = this.archiveFactory.openArchive(location);
                    }
                    catch (IOException e) {
                        this.logger.log(Level.INFO, e.getMessage(), e);
                    }
                } else {
                    this.logger.warning("Originally deployed application at " + location + " not found");
                }
            }
        } else {
            source = info.getSource();
        }
        DeploymentContextImpl deploymentContext = new DeploymentContextImpl(this.logger, source, parameters, this.env);
        if (info != null) {
            this.undeploy(this.name, deploymentContext, report);
        }
        boolean isDirectoryDeployed = false;
        if (application != null) {
            isDirectoryDeployed = Boolean.valueOf(application.getDirectoryDeployed());
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            try {
                this.unregisterAppFromDomainXML(this.name);
            }
            catch (TransactionFailure e) {
                this.logger.warning("Module " + this.name + " not found in configuration");
            }
            this.deleteContainerMetaInfo(deploymentContext);
            if (source != null && !this.keepreposdir.booleanValue() && !isDirectoryDeployed && source.exists()) {
                FileUtils.whack(new File(info.getSource().getURI()));
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

