/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.common.XMLActionReporter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicReloader
implements Runnable {
    private static final String RELOAD_FILE_NAME = ".reload";
    private AtomicBoolean inProgress;
    private Map<String, AppReloadInfo> appReloadInfo;
    private AtomicBoolean cancelRequested = new AtomicBoolean(false);
    private Applications applications;
    private Logger logger;
    private Habitat habitat;

    DynamicReloader(Applications applications, Logger logger, Habitat habitat) throws URISyntaxException {
        this.applications = applications;
        this.logger = logger;
        this.habitat = habitat;
        this.initAppReloadInfo(applications);
        this.inProgress = new AtomicBoolean(false);
    }

    private void initAppReloadInfo(Applications applications) throws URISyntaxException {
        this.appReloadInfo = new HashMap<String, AppReloadInfo>();
        this.logger.fine("[Reloader] Preparing list of apps to monitor:");
        for (Module m : applications.getModules()) {
            if (!(m instanceof Application)) continue;
            Application app = (Application)m;
            AppReloadInfo info = new AppReloadInfo(app);
            this.appReloadInfo.put(app.getName(), info);
            this.logger.fine("[Reloader] Monitoring " + app.getName() + " at " + app.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.markInProgress();
        try {
            this.reloadApps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clearInProgress();
        }
    }

    void cancel() {
        this.cancelRequested.set(true);
    }

    private void reloadApps() throws URISyntaxException, IOException {
        List<AppReloadInfo> appsToReload = this.chooseAppsToReload();
        for (AppReloadInfo appInfo : appsToReload) {
            if (this.cancelRequested.get()) break;
            this.reloadApp(appInfo);
        }
        this.cancelRequested.set(false);
    }

    private synchronized List<AppReloadInfo> chooseAppsToReload() throws URISyntaxException {
        ArrayList<AppReloadInfo> result = new ArrayList<AppReloadInfo>();
        HashSet<AppReloadInfo> possiblyUndeployedApps = new HashSet<AppReloadInfo>(this.appReloadInfo.values());
        for (Module m : this.applications.getModules()) {
            if (!(m instanceof Application)) continue;
            Application app = (Application)m;
            AppReloadInfo reloadInfo = this.findOrCreateAppReloadInfo(app);
            if (reloadInfo.needsReload()) {
                this.logger.fine("[Reloader] Selecting app " + reloadInfo.getApplication().getName() + " to reload");
                result.add(reloadInfo);
            }
            possiblyUndeployedApps.remove(reloadInfo);
        }
        for (AppReloadInfo info : possiblyUndeployedApps) {
            this.logger.fine("[Reloader] Removing undeployed app " + info.getApplication().getName() + " from reload info");
            this.appReloadInfo.remove(info.getApplication().getName());
        }
        return result;
    }

    private synchronized AppReloadInfo findOrCreateAppReloadInfo(Application app) throws URISyntaxException {
        AppReloadInfo result = this.appReloadInfo.get(app.getName());
        if (result == null) {
            this.logger.fine("[Reloader] Recording info for new app " + app.getName() + " at " + app.getLocation());
            result = new AppReloadInfo(app);
            this.appReloadInfo.put(app.getName(), result);
        }
        return result;
    }

    private void reloadApp(AppReloadInfo appInfo) throws IOException {
        this.logger.fine("[Reloader] Reloading " + appInfo.getApplication().getName());
        CommandRunner commandRunner = this.habitat.getComponent(CommandRunner.class);
        Properties deployParam = new Properties();
        deployParam.put("force", Boolean.TRUE.toString());
        deployParam.put("path", appInfo.getApplicationDirectory().getCanonicalPath());
        deployParam.put("name", appInfo.getApplication().getName());
        deployParam.put("keepreposdir", "true");
        XMLActionReporter report = new XMLActionReporter();
        commandRunner.doCommand("deploy", deployParam, report);
        appInfo.recordLoad();
    }

    private void markInProgress() {
        this.inProgress.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInProgress() {
        AtomicBoolean atomicBoolean = this.inProgress;
        synchronized (atomicBoolean) {
            this.inProgress.set(false);
            this.inProgress.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.inProgress;
        synchronized (atomicBoolean) {
            if (this.inProgress.get()) {
                this.inProgress.wait();
            }
        }
    }

    private final class AppReloadInfo {
        private File reloadFile;
        private long latestRecordedLoad;
        private Application app;
        private File appDir;

        private AppReloadInfo(Application app) throws URISyntaxException {
            this.app = app;
            this.appDir = new File(new URI(app.getLocation()));
            this.reloadFile = new File(this.appDir, DynamicReloader.RELOAD_FILE_NAME);
            this.recordLoad();
        }

        private Application getApplication() {
            return this.app;
        }

        private boolean needsReload() {
            boolean answer = this.reloadFile.lastModified() > this.latestRecordedLoad;
            return answer;
        }

        private void recordLoad() {
            this.latestRecordedLoad = System.currentTimeMillis();
        }

        private File getApplicationDirectory() {
            return this.appDir;
        }
    }
}

