/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ExtensionModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.ManagerProperties;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.SessionConfig;
import com.sun.enterprise.config.serverbeans.SessionManager;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.config.serverbeans.StoreProperties;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerConfigLookup {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static final String EE_BUILDER_PATH_PROPERTY_NAME = "ee-builder-path";
    private static final String DEFAULT_EE_BUILDER_PATH = "com.sun.enterprise.ee.web.initialization";
    private Config configBean;

    public ServerConfigLookup(Config configBean) {
        this.configBean = configBean;
    }

    public SessionManager getInstanceSessionManager() {
        if (this.configBean == null) {
            return null;
        }
        WebContainer webContainerBean = this.configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        return sessionConfigBean.getSessionManager();
    }

    public ManagerProperties getInstanceSessionManagerManagerProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getManagerProperties();
    }

    public StoreProperties getInstanceSessionManagerStoreProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getStoreProperties();
    }

    public SessionProperties getInstanceSessionProperties() {
        if (this.configBean == null) {
            return null;
        }
        WebContainer webContainerBean = this.configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        return sessionConfigBean.getSessionProperties();
    }

    public String getEEBuilderPathFromConfig() {
        return this.getWebContainerAvailabilityPropertyString(EE_BUILDER_PATH_PROPERTY_NAME, DEFAULT_EE_BUILDER_PATH);
    }

    protected AvailabilityService getAvailabilityService() {
        if (this.configBean == null) {
            return null;
        }
        return this.configBean.getAvailabilityService();
    }

    public boolean getAvailabilityEnabledFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("AvailabilityService was not defined - check domain.xml");
            }
            return false;
        }
        Boolean bool = this.toBoolean(as.getAvailabilityEnabled());
        if (bool == null) {
            return false;
        }
        return bool;
    }

    private WebContainerAvailability getWebContainerAvailability() {
        AvailabilityService availabilityServiceBean = this.getAvailabilityService();
        if (availabilityServiceBean == null) {
            return null;
        }
        return availabilityServiceBean.getWebContainerAvailability();
    }

    protected String getWebContainerAvailabilityPropertyString(String propName) {
        return this.getWebContainerAvailabilityPropertyString(propName, null);
    }

    protected String getWebContainerAvailabilityPropertyString(String propName, String defaultValue) {
        WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
        if (wcAvailabilityBean == null) {
            return defaultValue;
        }
        List<Property> props = wcAvailabilityBean.getProperty();
        if (props == null) {
            return defaultValue;
        }
        for (Property prop : props) {
            String name = prop.getName();
            String value = prop.getValue();
            if (!name.equalsIgnoreCase(propName)) continue;
            return value;
        }
        return defaultValue;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        WebContainerAvailability was = this.getWebContainerAvailability();
        if (was == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("WebContainerAvailability not defined - check domain.xml");
            }
            return globalAvailabilityEnabled;
        }
        Boolean bool = this.toBoolean(was.getAvailabilityEnabled());
        if (bool == null) {
            return globalAvailabilityEnabled;
        }
        return bool;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig(boolean inheritedValue) {
        WebContainerAvailability was = this.getWebContainerAvailability();
        if (was == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("WebContainerAvailability not defined - check domain.xml");
            }
            return inheritedValue;
        }
        Boolean bool = this.toBoolean(was.getAvailabilityEnabled());
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    public boolean calculateWebAvailabilityEnabledFromConfig(WebModule ctx) {
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("globalAvailability = " + globalAvailability);
        }
        boolean webContainerAvailability = this.getWebContainerAvailabilityEnabledFromConfig(globalAvailability);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("webContainerAvailability = " + webContainerAvailability);
        }
        String webModuleAvailabilityString = null;
        J2eeApplication j2eeApp = ctx.getApplicationBean();
        if (j2eeApp == null) {
            com.sun.enterprise.config.serverbeans.WebModule bean = ctx.getBean();
            if (bean != null) {
                if (bean instanceof com.sun.enterprise.config.serverbeans.WebModule) {
                    webModuleAvailabilityString = bean.getAvailabilityEnabled();
                } else if (bean instanceof ExtensionModule) {
                    webModuleAvailabilityString = ((ExtensionModule)((Object)bean)).getAvailabilityEnabled();
                }
            }
        } else {
            webModuleAvailabilityString = j2eeApp.getAvailabilityEnabled();
        }
        boolean webModuleAvailability = false;
        Boolean bool = this.toBoolean(webModuleAvailabilityString);
        if (bool != null) {
            webModuleAvailability = bool;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("webModuleAvailability = " + webModuleAvailability);
        }
        return globalAvailability && webContainerAvailability && webModuleAvailability;
    }

    public PersistenceType getPersistenceTypeFromConfig() {
        String persistenceTypeString = null;
        PersistenceType persistenceType = null;
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        persistenceTypeString = webContainerAvailabilityBean.getPersistenceType();
        if (persistenceTypeString != null) {
            persistenceType = PersistenceType.parseType(persistenceTypeString);
        }
        if (persistenceType != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SERVER.XML persistenceType= " + persistenceType.getType());
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("SERVER.XML persistenceType missing");
        }
        return persistenceType;
    }

    public String getPersistenceFrequencyFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceFrequency();
    }

    public String getPersistenceScopeFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceScope();
    }

    protected Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

