/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCConnectionQueueStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.web.stats.StatsUtil;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public final class PWCConnectionQueueStatsImpl
implements PWCConnectionQueueStats {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private GenericStatsImpl baseStatsImpl = new GenericStatsImpl(PWCConnectionQueueStats.class, (Object)this);
    private MBeanServer server;
    private ObjectName connectionQueueName;
    private StringStatistic id;
    private MutableCountStatistic countTotalConnections;
    private MutableCountStatistic countQueued;
    private MutableCountStatistic peakQueued;
    private MutableCountStatistic maxQueued;
    private MutableCountStatistic countOverflows;
    private MutableCountStatistic countTotalQueued;
    private MutableCountStatistic ticksTotalQueued;
    private MutableCountStatistic countQueued1MinuteAverage;
    private MutableCountStatistic countQueued5MinuteAverage;
    private MutableCountStatistic countQueued15MinuteAverage;

    public PWCConnectionQueueStatsImpl(String domain) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        String objNameStr = domain + ":type=PWCConnectionQueue,*";
        try {
            this.connectionQueueName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            String msg = _logger.getResourceBundle().getString("webcontainer.objectNameCreationError");
            msg = MessageFormat.format(msg, objNameStr);
            _logger.log(Level.SEVERE, msg, t);
        }
        this.initializeStatistics();
    }

    public StringStatistic getId() {
        return this.id;
    }

    public CountStatistic getCountTotalConnections() {
        this.countTotalConnections.setCount(StatsUtil.getAggregateStatistic(this.server, this.connectionQueueName, "countTotalConnections"));
        return (CountStatistic)this.countTotalConnections.unmodifiableView();
    }

    public CountStatistic getCountQueued() {
        this.countQueued.setCount(StatsUtil.getAggregateStatistic(this.server, this.connectionQueueName, "countQueued"));
        return (CountStatistic)this.countQueued.unmodifiableView();
    }

    public CountStatistic getPeakQueued() {
        this.peakQueued.setCount(StatsUtil.getAggregateStatistic(this.server, this.connectionQueueName, "peakQueued"));
        return (CountStatistic)this.peakQueued.unmodifiableView();
    }

    public CountStatistic getMaxQueued() {
        this.maxQueued.setCount(StatsUtil.getConstant(this.server, this.connectionQueueName, "maxQueued"));
        return (CountStatistic)this.maxQueued.unmodifiableView();
    }

    public CountStatistic getCountOverflows() {
        this.countOverflows.setCount(StatsUtil.getAggregateStatistic(this.server, this.connectionQueueName, "countOverflows"));
        return (CountStatistic)this.countOverflows.unmodifiableView();
    }

    public CountStatistic getCountTotalQueued() {
        this.countTotalQueued.setCount(StatsUtil.getAggregateStatistic(this.server, this.connectionQueueName, "countTotalQueued"));
        return (CountStatistic)this.countTotalQueued.unmodifiableView();
    }

    public CountStatistic getTicksTotalQueued() {
        this.ticksTotalQueued.setCount(StatsUtil.getAverageStatistic(this.server, this.connectionQueueName, "ticksTotalQueued"));
        return (CountStatistic)this.ticksTotalQueued.unmodifiableView();
    }

    public CountStatistic getCountQueued1MinuteAverage() {
        this.countQueued1MinuteAverage.setCount(StatsUtil.getAverageStatistic(this.server, this.connectionQueueName, "countQueued1MinuteAverage"));
        return (CountStatistic)this.countQueued1MinuteAverage.unmodifiableView();
    }

    public CountStatistic getCountQueued5MinuteAverage() {
        this.countQueued5MinuteAverage.setCount(StatsUtil.getAverageStatistic(this.server, this.connectionQueueName, "countQueued5MinuteAverage"));
        return (CountStatistic)this.countQueued5MinuteAverage.unmodifiableView();
    }

    public CountStatistic getCountQueued15MinuteAverage() {
        this.countQueued15MinuteAverage.setCount(StatsUtil.getAverageStatistic(this.server, this.connectionQueueName, "countQueued15MinuteAverage"));
        return (CountStatistic)this.countQueued15MinuteAverage.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String name) {
        return this.baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        long startTime = System.currentTimeMillis();
        this.id = new StringStatisticImpl("", "Id", "String", "ID of the connection queue", startTime, startTime);
        CountStatisticImpl c = new CountStatisticImpl("CountTotalConnections");
        this.countTotalConnections = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("CountQueued");
        this.countQueued = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("PeakQueued");
        this.peakQueued = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("MaxQueued");
        this.maxQueued = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("CountOverflows");
        this.countOverflows = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("CountTotalQueued");
        this.countTotalQueued = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("TicksTotalQueued");
        this.ticksTotalQueued = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("CountQueued1MinuteAverage");
        this.countQueued1MinuteAverage = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("CountQueued5MinuteAverage");
        this.countQueued5MinuteAverage = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("CountQueued15MinuteAverage");
        this.countQueued15MinuteAverage = new MutableCountStatisticImpl(c);
    }
}

