/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.WebappLifecycleListener;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.ELContextListenerImpl;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigureListener
implements ServletRequestListener,
HttpSessionListener,
ServletRequestAttributeListener,
HttpSessionAttributeListener,
ServletContextAttributeListener,
ServletContextListener {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    protected WebappLifecycleListener webAppListener = new WebappLifecycleListener();
    protected WebConfiguration webConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        this.webAppListener.contextInitialized(sce);
        Timer timer = Timer.getInstance();
        if (timer != null) {
            timer.startTiming();
        }
        ServletContext context = sce.getServletContext();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, MessageFormat.format("ConfigureListener.contextInitialized({0})", ConfigureListener.getServletContextIdentifier(context)));
        }
        this.webConfig = WebConfiguration.getInstance(context);
        ConfigManager configManager = ConfigManager.getInstance();
        if (configManager.hasBeenInitialized(context)) {
            return;
        }
        if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ForceLoadFacesConfigFiles)) {
            WebXmlProcessor processor = new WebXmlProcessor(context);
            if (!processor.isFacesServletPresent()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "No FacesServlet found in deployment descriptor - bypassing configuration");
                }
                WebConfiguration.clear(context);
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "FacesServlet found in deployment descriptor - processing configuration.");
            }
        }
        InitFacesContext initContext = new InitFacesContext(context);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        try {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.config.listener.version", ConfigureListener.getServletContextIdentifier(context));
            }
            Util.setHtmlTLVActive(this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableHtmlTagLibraryValidator));
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.VerifyFacesConfigObjects)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("jsf.config.verifyobjects.development_only");
                }
                this.webConfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.EnableLazyBeanValidation, false);
                Verifier.setCurrentInstance(new Verifier());
            }
            configManager.initialize(context);
            Verifier v = Verifier.getCurrentInstance();
            if (v != null && !v.isApplicationValid() && LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("jsf.config.verifyobjects.failures_detected");
                StringBuilder sb = new StringBuilder(128);
                for (String m : v.getMessages()) {
                    sb.append(m).append('\n');
                }
                LOGGER.severe(sb.toString());
            }
            this.registerELResolverAndListenerWithJsp(context);
            ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
            if (associate != null) {
                associate.setContextName(ConfigureListener.getServletContextIdentifier(context));
            }
            RenderKitUtils.loadSunJsfJs(((FacesContext)initContext).getExternalContext());
        }
        finally {
            Verifier.setCurrentInstance(null);
            ((FacesContext)initContext).release();
            LOGGER.log(Level.FINE, "jsf.config.listener.version.complete");
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Initialization of context " + ConfigureListener.getServletContextIdentifier(context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        this.webAppListener.contextDestroyed(sce);
        ServletContext context = sce.getServletContext();
        LOGGER.log(Level.FINE, "ConfigureListener.contextDestroyed({0})", context.getServletContextName());
        try {
            FactoryFinder.releaseFactories();
        }
        finally {
            InitFacesContext initContext = new InitFacesContext(context);
            ApplicationAssociate.clearInstance(((FacesContext)initContext).getExternalContext());
            ConfigManager.getInstance().destory(context);
            ((FacesContext)initContext).release();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(context);
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        this.webAppListener.requestDestroyed(event);
    }

    public void requestInitialized(ServletRequestEvent event) {
        this.webAppListener.requestInitialized(event);
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.webAppListener.sessionDestroyed(event);
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        this.webAppListener.attributeRemoved(event);
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        this.webAppListener.attributeReplaced(event);
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.webAppListener.attributeRemoved(event);
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.webAppListener.attributeReplaced(event);
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        this.webAppListener.attributeRemoved(event);
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        this.webAppListener.attributeReplaced(event);
    }

    private static String getServletContextIdentifier(ServletContext context) {
        if (context.getMajorVersion() == 2 && context.getMinorVersion() < 5) {
            return context.getServletContextName();
        }
        return context.getContextPath();
    }

    private static boolean isJspTwoOne() {
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        if (JspFactory.getDefaultFactory() == null) {
            return false;
        }
        try {
            JspFactory.class.getMethod("getJspApplicationContext", ServletContext.class);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return true;
    }

    public void registerELResolverAndListenerWithJsp(ServletContext context) {
        if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ExpressionFactory) || !ConfigureListener.isJspTwoOne()) {
            if (!this.installExpressionFactory(context, this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ExpressionFactory))) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.INCORRECT_JSP_VERSION", WebConfiguration.WebContextInitParameter.ExpressionFactory.getDefaultValue(), WebConfiguration.WebContextInitParameter.ExpressionFactory.getQualifiedName()));
            }
        } else {
            JspApplicationContext jspAppContext;
            block8: {
                if (JspFactory.getDefaultFactory().getJspApplicationContext(context) == null) {
                    return;
                }
                FacesCompositeELResolver compositeELResolverForJsp = new FacesCompositeELResolver(FacesCompositeELResolver.ELResolverChainType.JSP);
                ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
                if (associate != null) {
                    associate.setFacesELResolverForJsp(compositeELResolverForJsp);
                }
                jspAppContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
                if (associate != null) {
                    associate.setExpressionFactory(jspAppContext.getExpressionFactory());
                }
                try {
                    jspAppContext.addELResolver(compositeELResolverForJsp);
                }
                catch (IllegalStateException e) {
                    if (Util.isUnitTestModeEnabled()) break block8;
                    throw e;
                }
            }
            ELContextListenerImpl elContextListener = new ELContextListenerImpl();
            jspAppContext.addELContextListener(elContextListener);
        }
    }

    private boolean installExpressionFactory(ServletContext sc, String elFactoryType) {
        if (elFactoryType == null) {
            return false;
        }
        try {
            ExpressionFactory factory = (ExpressionFactory)Class.forName(elFactoryType).newInstance();
            ApplicationAssociate associate = ApplicationAssociate.getInstance(sc);
            if (associate != null) {
                associate.setExpressionFactory(factory);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.severe(MessageFormat.format("Unable to instantiate ExpressionFactory ''{0}''", elFactoryType));
            return false;
        }
    }

    private static class WebXmlProcessor {
        private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
        private boolean facesServletPresent;

        WebXmlProcessor(ServletContext context) {
            if (context != null) {
                this.scanForFacesServlet(context);
            }
        }

        boolean isFacesServletPresent() {
            return this.facesServletPresent;
        }

        private void scanForFacesServlet(ServletContext context) {
            SAXParserFactory factory = this.getConfiguredFactory();
            try {
                SAXParser parser = factory.newSAXParser();
                parser.parse(context.getResourceAsStream(WEB_XML_PATH), (DefaultHandler)new WebXmlHandler());
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, MessageFormat.format("Unable to process deployment descriptor for context ''{0}''", ConfigureListener.getServletContextIdentifier(context)));
                }
                this.facesServletPresent = true;
            }
        }

        private SAXParserFactory getConfiguredFactory() {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            return factory;
        }

        private class WebXmlHandler
        extends DefaultHandler {
            private static final String SERVLET_CLASS = "servlet-class";
            private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
            private boolean servletClassFound;
            private StringBuffer content;

            private WebXmlHandler() {
            }

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                return new InputSource(new StringReader(""));
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!WebXmlProcessor.this.facesServletPresent) {
                    if (SERVLET_CLASS.equals(localName)) {
                        this.servletClassFound = true;
                        this.content = new StringBuffer();
                    } else {
                        this.servletClassFound = false;
                    }
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent) {
                    this.content.append(ch, start, length);
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent && FACES_SERVLET.equals(this.content.toString().trim())) {
                    WebXmlProcessor.this.facesServletPresent = true;
                }
            }
        }
    }
}

