/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.embed;

import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.http.Management;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.embed.Statistics;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapterChain;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class GrizzlyWebServer {
    private int defaultPort = 8080;
    private SelectorThread st;
    private ObjectInstance stMBean;
    private GrizzlyAdapterChain adapterChains = new GrizzlyAdapterChain();
    private ArrayList<GrizzlyAdapter> adapters = new ArrayList();
    private boolean isStarted = false;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private String webResourcesPath = ".";
    private String mBeanName = "com.sun.grizzly:type=GrizzlyWebServer,name=GrizzlyHttpEngine-" + this.defaultPort;
    private Statistics statistics;

    public GrizzlyWebServer() {
        this.createSelectorThread(this.defaultPort, 5);
    }

    public GrizzlyWebServer(int port) {
        this.createSelectorThread(port, 5);
    }

    public GrizzlyWebServer(String webResourcesPath) {
        this.createSelectorThread(this.defaultPort, 5);
        this.webResourcesPath = webResourcesPath;
    }

    public GrizzlyWebServer(int port, int maxThreads) {
        this.createSelectorThread(port, maxThreads);
    }

    public GrizzlyWebServer(int port, String webResourcesPath) {
        this.createSelectorThread(port, 5);
        this.webResourcesPath = webResourcesPath;
    }

    public GrizzlyWebServer(int port, int maxThreads, String webResourcesPath) {
        this.createSelectorThread(port, maxThreads);
        this.webResourcesPath = webResourcesPath;
    }

    private void createSelectorThread(int port, int maxThreads) {
        this.st = new SelectorThread();
        this.st.setPort(port);
        this.st.setMaxThreads(maxThreads);
    }

    public SelectorThread getSelectorThread() {
        return this.st;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public void addGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter) {
        this.adapters.add(grizzlyAdapter);
    }

    public void start() throws IOException {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        if (this.adapters.size() == 0) {
            this.st.setAdapter(new StaticResourcesAdapter(this.webResourcesPath));
        }
        if (this.adapters.size() == 1) {
            this.st.setAdapter(this.adapters.get(0));
        } else {
            for (GrizzlyAdapter adapter : this.adapters) {
                this.adapterChains.addGrizzlyAdapter(adapter);
            }
            this.st.setAdapter(this.adapterChains);
            this.adapterChains.setHandleStaticResources(true);
            this.adapterChains.setRootFolder(this.webResourcesPath);
        }
        if (this.asyncFilters.size() > 0) {
            this.st.setEnableAsyncExecution(true);
            DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
            for (AsyncFilter asyncFilter : this.asyncFilters) {
                asyncHandler.addAsyncFilter(asyncFilter);
            }
            this.st.setAsyncHandler(asyncHandler);
        }
        try {
            this.st.listen();
        }
        catch (InstantiationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void enableJMX(Management jmxManagement) {
        if (jmxManagement == null) {
            return;
        }
        this.st.setManagement(jmxManagement);
        try {
            ObjectName sname = new ObjectName(this.mBeanName);
            jmxManagement.registerComponent(this.st, sname, null);
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "Enabling JMX failed", ex);
        }
    }

    public Statistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new Statistics(this.st);
        }
        return this.statistics;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        this.st.stopEndpoint();
    }

    public static final GrizzlyWebServer newInstance(String path) {
        GrizzlyWebServer ws = new GrizzlyWebServer(8080);
        ws.addGrizzlyAdapter(new GrizzlyAdapter(path){
            {
                this.setHandleStaticResources(true);
            }

            public void service(GrizzlyRequest request, GrizzlyResponse response) {
                try {
                    response.setStatus(404);
                    response.flushBuffer();
                }
                catch (IOException ex) {
                    Logger.getLogger(GrizzlyWebServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        return ws;
    }
}

