/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.util;

import java.beans.Beans;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;

public class Util {
    private Util() {
    }

    public static UIComponent getChild(UIComponent parent, String id) {
        return Util.findChild(parent, id, id);
    }

    public static UIComponent findChild(UIComponent parent, String id, String facetName) {
        if (parent == null) {
            return null;
        }
        UIComponent child2 = null;
        if (facetName != null && (child2 = parent.getFacets().get(facetName)) != null) {
            return child2;
        }
        if (id != null) {
            for (UIComponent child2 : parent.getChildren()) {
                if (!id.equals(child2.getId())) continue;
                return child2;
            }
        }
        return null;
    }

    public static UIComponent getForm(FacesContext context, UIComponent component) {
        if (component != null) {
            if (component instanceof UIForm) {
                return component;
            }
            UIComponent form = component;
            do {
                if ((form = form.getParent()) == null || !(form instanceof UIForm)) continue;
                return form;
            } while (form != null);
        }
        return null;
    }

    public static String getFormName(FacesContext context, UIComponent component) {
        UIComponent form = Util.getForm(context, component);
        if (form != null) {
            return form.getClientId(context);
        }
        return null;
    }

    public static String getBase(FacesContext context) {
        return Util.getContext(context) + context.getViewRoot().getViewId();
    }

    public static String getContext(FacesContext context) {
        if (Beans.isDesignTime()) {
            return "http://localhost:18080/myapp";
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        StringBuffer sb = new StringBuffer(request.getScheme());
        sb.append("://");
        sb.append(request.getServerName());
        if (!("http".equals(request.getScheme()) && 80 == request.getServerPort() || "https".equals(request.getScheme()) && 443 == request.getServerPort())) {
            sb.append(":" + request.getServerPort());
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    public static String getActionURL(FacesContext context, String url) {
        return context.getApplication().getViewHandler().getActionURL(context, url);
    }

    public static void addPhaseListener(PhaseListener phaseListener) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.addPhaseListener(phaseListener);
    }

    public static void removePhaseListener(PhaseListener phaseListener) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.removePhaseListener(phaseListener);
    }
}

