/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.ajax;

import com.sun.webui.jsf.component.Login;
import com.sun.webui.jsf.model.login.LoginCallback;
import com.sun.webui.jsf.model.login.LoginConstants;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginRenderer
extends com.sun.webui.jsf.renderkit.widget.LoginRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!(component instanceof Login)) {
            throw new IllegalArgumentException("LoginRenderer can only decode Login components.");
        }
        Login login = (Login)component;
        try {
            ExternalContext ec = context.getExternalContext();
            Map<String, String> map = ec.getRequestHeaderMap();
            JSONObject xjson = new JSONObject(map.get("X-JSON"));
            String id = (String)xjson.get("id");
            if (login.getClientId(context).equals(id)) {
                JSONArray keys;
                String loginState = (String)xjson.get("loginState");
                if (loginState != null) {
                    if (loginState.equalsIgnoreCase("INIT")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.INIT);
                    } else if (loginState.equalsIgnoreCase("CONTINUE")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.CONTINUE);
                    } else if (loginState.equalsIgnoreCase("SUCCESS")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.SUCCESS);
                    } else if (loginState.equalsIgnoreCase("FAILURE")) {
                        login.setLoginState(LoginConstants.LOGINSTATE.FAILURE);
                    }
                } else {
                    login.setLoginState(LoginConstants.LOGINSTATE.INIT);
                }
                if (!login.getLoginState().equals((Object)LoginConstants.LOGINSTATE.INIT) && (keys = (JSONArray)xjson.get("keys")) != null) {
                    Map<String, String> parmMap = ec.getRequestParameterMap();
                    HashMap<String, Object> hMap = new HashMap<String, Object>();
                    Map keyMap = login.getAuthenticationKeys();
                    int length = keys.length();
                    String[] strKeys = new String[length];
                    for (int i = 0; i < length; ++i) {
                        JSONArray keyArray = (JSONArray)keys.get(i);
                        String key = (String)keyArray.get(0);
                        Object value = keyArray.get(1);
                        hMap.put(key, value);
                    }
                    login.setSubmittedValue(hMap);
                }
            }
        }
        catch (JSONException e) {
            login.setLoginState(LoginConstants.LOGINSTATE.INIT);
        }
        catch (NullPointerException e) {
            login.setLoginState(LoginConstants.LOGINSTATE.INIT);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        Login login = (Login)component;
        try {
            LoginCallback lcb = login.getCallbackObject();
            JSONObject json = new JSONObject();
            if (lcb != null) {
                json.put("loginState", (Object)lcb.getLoginState());
                json.put("id", login.getClientId(context));
                if (login.getLoginState().equals((Object)LoginConstants.LOGINSTATE.FAILURE)) {
                    String msgSummary = lcb.getMessageSummary();
                    if (!login.isValid()) {
                        Iterator<FacesMessage> it = context.getMessages();
                        while (it.hasNext()) {
                            FacesMessage fm = it.next();
                            json.put("alert", this.getAlertData(context, fm.getSeverity().toString(), fm.getSummary(), fm.getDetail()));
                        }
                    } else if (msgSummary != null && msgSummary.length() > 0) {
                        json.put("alert", this.getAlertData(context, lcb.getMessageType(), msgSummary, lcb.getMessageDetail()));
                    }
                    Map oldKeyMap = login.getAuthenticationKeys();
                    login.setAuthenticationKeys(oldKeyMap);
                } else {
                    JSONArray keys = new JSONArray();
                    JSONArray userData = new JSONArray();
                    String[] dataKeys = lcb.getDataKeys();
                    HashMap keyMap = new HashMap();
                    for (int i = 0; i < dataKeys.length; ++i) {
                        String key = dataKeys[i];
                        String type = lcb.getCallbackDataType(key);
                        JSONArray content = this.getRenderedWidget(login, context, lcb, key, keys, keyMap);
                        if (content == null) continue;
                        userData.put(i, content);
                    }
                    String msgSummary = lcb.getMessageSummary();
                    if (msgSummary != null && msgSummary.length() > 0) {
                        json.put("alert", this.getAlertData(context, lcb.getMessageType(), msgSummary, lcb.getMessageDetail()));
                    }
                    login.setAuthenticationKeys(keyMap);
                    json.put("keys", keys);
                    json.put("userData", userData);
                    json.put("redirectURL", login.getRedirectURL());
                }
            } else if (!login.isValid()) {
                json.put("loginState", (Object)LoginConstants.LOGINSTATE.FAILURE);
                json.put("id", login.getClientId(context));
                Iterator<FacesMessage> it = context.getMessages();
                while (it.hasNext()) {
                    FacesMessage fm = it.next();
                    json.put("alert", this.getAlertData(context, fm.getSeverity().toString(), fm.getSummary(), fm.getDetail()));
                }
            }
            json.write(context.getResponseWriter());
        }
        catch (JSONException je) {
            LogUtil.severe("JSON Exception thrown during rendering");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    private JSONArray getRenderedWidget(Login login, FacesContext context, LoginCallback lcb, String key, JSONArray keys, Map keyMap) throws IOException, JSONException {
        JSONArray contentArray = new JSONArray();
        JSONArray keyArray = new JSONArray();
        String widgetType = lcb.getCallbackDataType(key);
        String labelData = lcb.getCallbackDataLabel(key);
        this.setLabelData(labelData, contentArray, login, key, context);
        JSONObject props = new JSONObject();
        props.put("type", widgetType);
        props.put("id", key);
        if (widgetType.equalsIgnoreCase("staticText")) {
            props.put("value", lcb.getCallbackDataValue(key));
            contentArray.put(props);
        } else if (widgetType.equalsIgnoreCase("textField")) {
            props.put("value", lcb.getCallbackDataValue(key));
            contentArray.put(props);
            keyArray.put(key);
            keyArray.put(lcb.getCallbackDataValue(key));
            keys.put(keyArray);
        } else if (widgetType.equalsIgnoreCase("passwordfield")) {
            contentArray.put(props);
            keyArray.put(key);
            keys.put(keyArray);
        } else if (widgetType.equalsIgnoreCase("dropDown") || widgetType.equalsIgnoreCase("listbox")) {
            String[] list = lcb.getCallbackDataList(key);
            JSONArray optArray = new JSONArray();
            if (list != null && list.length > 0) {
                for (int i = 0; i < list.length; ++i) {
                    JSONObject opt = new JSONObject();
                    opt.put("group", false);
                    opt.put("separator", false);
                    opt.put("value", list[i]);
                    opt.put("label", list[i]);
                    optArray.put(opt);
                }
            }
            props.put("options", optArray);
            contentArray.put(props);
            keyArray.put(key);
            keys.put(keyArray);
        } else if (widgetType.equalsIgnoreCase("image")) {
            props.put("src", lcb.getCallbackDataValue(key));
            contentArray.put(props);
        }
        if (contentArray.length() > 0) {
            return contentArray;
        }
        return null;
    }

    private void setLabelData(String labelData, JSONArray contentArray, Login login, String key, FacesContext context) throws IOException, JSONException {
        if (labelData != null && labelData.length() > 0) {
            JSONObject stObject = new JSONObject();
            stObject.put("type", "label");
            stObject.put("id", login.getClientId(context) + "_" + key + "_label");
            stObject.put("value", labelData);
            contentArray.put(stObject);
        }
    }

    private JSONObject getAlertData(FacesContext context, String type, String summaryKey, String detailKey) {
        JSONObject json = new JSONObject();
        Theme theme = ThemeUtilities.getTheme(context);
        try {
            if (type != null && type.length() > 0) {
                json.put("type", type);
            }
            if (summaryKey != null && summaryKey.length() > 0) {
                String summary = theme.getMessage(summaryKey);
                if (summary != null) {
                    json.put("summary", summary);
                } else {
                    json.put("summary", summaryKey);
                }
            }
            if (detailKey != null && detailKey.length() > 0) {
                String detail = theme.getMessage(detailKey);
                if (detail != null) {
                    json.put("detail", detail);
                } else {
                    json.put("detail", detailKey);
                }
            }
            return json;
        }
        catch (JSONException je) {
            return null;
        }
    }
}

