/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.json.JSONException;
import org.json.JSONObject;

public class ButtonRenderer
extends AbstractRenderer {
    private static final String[] integerAttributes = new String[]{"tabIndex"};
    private static final String[] stringAttributes = new String[]{"dir", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "style"};
    private static final String[] inputAttributes = new String[]{"alt", "align"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Button button = (Button)component;
        if (button.isReset()) {
            return;
        }
        String clientId = button.getClientId(context);
        Map<String, String> map = context.getExternalContext().getRequestParameterMap();
        if (map.containsKey(clientId) || map.containsKey(clientId + ".x") && map.containsKey(clientId + ".y")) {
            button.queueEvent(new ActionEvent(button));
        }
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isEscape()) {
            writer.startElement("input", button);
        } else {
            writer.startElement("button", button);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        writer.writeAttribute("id", button.getClientId(context), null);
        writer.writeAttribute("name", button.getClientId(context), null);
        String style = this.getStyle(button, ThemeUtilities.getTheme(context));
        RenderingUtilities.renderStyleClass(context, writer, button, style);
        String js = this.getJavascript(button.getOnBlur(), "onblur");
        if (js != null) {
            writer.writeAttribute("onblur", js, "onBlur");
        }
        if ((js = this.getJavascript(button.getOnFocus(), "onfocus")) != null) {
            writer.writeAttribute("onfocus", js, "onFocus");
        }
        if ((js = this.getJavascript(button.getOnMouseOut(), "onmouseout")) != null) {
            writer.writeAttribute("onmouseout", js, "onMouseOut");
        }
        if ((js = this.getJavascript(button.getOnMouseOver(), "onmouseover")) != null) {
            writer.writeAttribute("onmouseover", js, "onMouseOver");
        }
        if (button.getToolTip() != null) {
            writer.writeAttribute("title", button.getToolTip(), "toolTip");
        }
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        this.addIntegerAttributes(context, component, writer, integerAttributes);
        ButtonRenderer.addStringAttributes(context, component, writer, stringAttributes);
        if (button.isEscape()) {
            ButtonRenderer.addStringAttributes(context, component, writer, inputAttributes);
        }
        String imageURL = button.getImageURL();
        String icon = button.getIcon();
        if (imageURL != null) {
            this.renderImageURLAttributes(context, component, writer, imageURL);
        } else if (icon != null) {
            this.renderIconAttributes(context, component, writer, icon);
        } else {
            this.renderTextAttributes(context, component, writer);
        }
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isEscape()) {
            writer.endElement("input");
        } else {
            writer.endElement("button");
        }
        try {
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            json.put("id", button.getClientId(context)).put("mini", button.isMini()).put("disabled", button.isDisabled()).put("secondary", !button.isPrimary()).put("icon", button.getImageURL() != null || button.getIcon() != null);
            buff.append(JavaScriptUtilities.getModuleName("button._init")).append("(").append(JSONUtilities.getString(json)).append(");");
            JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected void renderIconAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String icon) throws IOException {
        Button button = (Button)component;
        String imagePath = ThemeUtilities.getTheme(context).getImagePath(icon);
        writer.writeAttribute("type", "image", null);
        RenderingUtilities.renderURLAttribute(context, writer, component, "src", imagePath, "icon");
    }

    protected void renderImageURLAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String url) throws IOException {
        Button button = (Button)component;
        url = context.getApplication().getViewHandler().getResourceURL(context, url);
        writer.writeAttribute("type", "image", null);
        RenderingUtilities.renderURLAttribute(context, writer, component, "src", url, "imageURL");
    }

    protected void renderTextAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isReset()) {
            writer.writeAttribute("type", "reset", null);
        } else {
            writer.writeAttribute("type", "submit", null);
        }
        String text = ConversionUtilities.convertValueToString(button, button.getValue());
        if (text == null || text.trim().length() == 0) {
            return;
        }
        if (!button.isNoTextPadding()) {
            if (text.trim().length() <= 3) {
                text = "  " + text + "  ";
            } else if (text.trim().length() == 4) {
                text = " " + text + " ";
            }
        }
        if (button.isEscape()) {
            writer.writeAttribute("value", text, "text");
        } else {
            writer.write(text);
        }
    }

    protected String getOnBlurStyle(Button button, Theme theme) {
        String style = null;
        style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("BUTTON3") : (button.isMini() && !button.isPrimary() ? theme.getStyleClass("BUTTON2_MINI") : (button.isMini() ? theme.getStyleClass("BUTTON1_MINI") : (!button.isPrimary() ? theme.getStyleClass("BUTTON2") : theme.getStyleClass("BUTTON1"))));
        return style;
    }

    protected String getOnFocusStyle(Button button, Theme theme) {
        String style = null;
        style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("BUTTON3_HOVER") : (button.isMini() && !button.isPrimary() ? theme.getStyleClass("BUTTON2_MINI_HOVER") : (button.isMini() ? theme.getStyleClass("BUTTON1_MINI_HOVER") : (!button.isPrimary() ? theme.getStyleClass("BUTTON2_HOVER") : theme.getStyleClass("BUTTON1_HOVER"))));
        return style;
    }

    protected String getOnMouseOverStyle(Button button, Theme theme) {
        return this.getOnFocusStyle(button, theme);
    }

    protected String getOnMouseOutStyle(Button button, Theme theme) {
        return this.getOnBlurStyle(button, theme);
    }

    protected String getStyle(Button button, Theme theme) {
        String style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("BUTTON3") : (button.isMini() && !button.isPrimary() ? (button.isDisabled() ? theme.getStyleClass("BUTTON2_MINI_DISABLED") : theme.getStyleClass("BUTTON2_MINI")) : (button.isMini() ? (button.isDisabled() ? theme.getStyleClass("BUTTON1_MINI_DISABLED") : theme.getStyleClass("BUTTON1_MINI")) : (!button.isPrimary() ? (button.isDisabled() ? theme.getStyleClass("BUTTON2_DISABLED") : theme.getStyleClass("BUTTON2")) : (button.isDisabled() ? theme.getStyleClass("BUTTON1_DISABLED") : theme.getStyleClass("BUTTON1")))));
        return style;
    }

    protected String getJavascript(String value, String jsmethod) {
        if (jsmethod == null) {
            return value;
        }
        String event = "return this.my" + jsmethod + "();";
        return value != null ? value + ";" + event : event;
    }
}

