/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Frame;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class FrameRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"name", "scrolling"};

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Frame frame = (Frame)component;
        if (!RenderingUtilities.isPortlet(context)) {
            writer.startElement("frame", component);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Frame frame = (Frame)component;
        if (!RenderingUtilities.isPortlet(context)) {
            String style;
            String styleClass;
            String url;
            String id = frame.getClientId(context);
            if (id != null) {
                writer.writeAttribute("id", id, null);
            }
            if ((url = frame.getUrl()) != null) {
                url = context.getApplication().getViewHandler().getResourceURL(context, url);
                RenderingUtilities.renderURLAttribute(context, writer, component, "src", url, null);
            }
            if ((styleClass = frame.getStyleClass()) != null) {
                writer.writeAttribute("class", styleClass, null);
            }
            if ((style = frame.getStyle()) != null) {
                writer.writeAttribute("style", style, null);
            }
            FrameRenderer.addStringAttributes(context, component, writer, stringAttributes);
            boolean border = frame.isFrameBorder();
            if (border) {
                writer.writeAttribute("frameborder", "1", null);
            } else {
                writer.writeAttribute("frameborder", "0", null);
            }
            String longdesc = frame.getLongDesc();
            if (longdesc != null) {
                writer.writeAttribute("longdesc", longdesc, null);
            }
            Integer marginWidth = new Integer(frame.getMarginWidth());
            if (frame.getMarginWidth() >= 0) {
                writer.writeAttribute("marginwidth", marginWidth.toString(), null);
            }
            Integer marginHeight = new Integer(frame.getMarginHeight());
            if (frame.getMarginHeight() >= 0) {
                writer.writeAttribute("marginheight", marginHeight.toString(), null);
            }
            this.renderResizeAttribute(writer, component);
            String toolTip = frame.getToolTip();
            if (toolTip != null) {
                writer.writeAttribute("title", toolTip, "toolTip");
            }
        }
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Frame frame = (Frame)component;
        if (!RenderingUtilities.isPortlet(context)) {
            writer.endElement("frame");
            writer.write("\n");
        }
    }

    protected void renderResizeAttribute(ResponseWriter writer, UIComponent comp) throws IOException {
        boolean noresize = ((Frame)comp).isNoResize();
        if (noresize) {
            writer.writeAttribute("noresize", "noresize", null);
        }
    }
}

