/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.renderkit.widget.HyperlinkRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ImageHyperlinkRenderer
extends HyperlinkRenderer {
    private static final String LABEL_LEFT = "left";
    private static final String DISABLED_IMAGE = "disabledImage";

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.imageHyperlink");
    }

    protected void setContents(FacesContext context, UIComponent component, JSONObject json) throws JSONException, IOException {
        UIComponent disabledImage;
        if (!(component instanceof ImageHyperlink)) {
            throw new IllegalArgumentException("ImageHyperlinkRenderer can only render ImageHyperlink components.");
        }
        ImageHyperlink ilink = (ImageHyperlink)component;
        Object text = ilink.getText();
        JSONArray jArray = new JSONArray();
        json.put("contents", jArray);
        String label = text == null ? null : ConversionUtilities.convertValueToString(component, text);
        String textPosition = ilink.getTextPosition();
        if (textPosition.equals(LABEL_LEFT)) {
            json.put("imagePosition", "right");
        } else {
            json.put("imagePosition", LABEL_LEFT);
        }
        ImageComponent ic = ilink.getImageFacet();
        if (label != null) {
            jArray.put(label);
            jArray.put(" ");
        }
        if (ic != null) {
            json.put("enabledImage", WidgetUtilities.renderComponent(context, ic));
        }
        if ((disabledImage = component.getFacets().get(DISABLED_IMAGE)) != null) {
            json.put(DISABLED_IMAGE, WidgetUtilities.renderComponent(context, disabledImage));
        }
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UIParameter) continue;
            jArray.put(WidgetUtilities.renderComponent(context, child));
        }
    }
}

