/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.RadioButton;
import com.sun.webui.jsf.renderkit.widget.RbCbRendererBase;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;

public class RadioButtonRenderer
extends RbCbRendererBase {
    public void decode(FacesContext context, UIComponent component) {
        Map<String, String> requestParameterMap;
        if (!(component instanceof RadioButton)) {
            throw new IllegalArgumentException("RadioButtonRenderer can only decode RadioButton components.");
        }
        if (ComponentUtilities.isDisabled(component) || ComponentUtilities.isReadOnly(component)) {
            return;
        }
        RadioButton radioButton = (RadioButton)component;
        String name = radioButton.getName();
        boolean inGroup = name != null;
        String componentId = component instanceof ComplexComponent ? ((ComplexComponent)((Object)component)).getLabeledElementId(context) : component.getClientId(context);
        if (name == null) {
            name = componentId;
        }
        if ((requestParameterMap = context.getExternalContext().getRequestParameterMap()).containsKey(name)) {
            String newValue = requestParameterMap.get(name);
            Object selectedValue = radioButton.getSelectedValue();
            String selectedValueAsString = null;
            if (inGroup && selectedValue instanceof Boolean) {
                selectedValueAsString = componentId;
                if (selectedValueAsString.equals(newValue)) {
                    ((UIInput)component).setSubmittedValue(new String[]{selectedValue.toString()});
                    return;
                }
            } else {
                selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
                if (selectedValueAsString.equals(newValue)) {
                    ((UIInput)component).setSubmittedValue(new String[]{newValue});
                    return;
                }
            }
            ((UIInput)component).setSubmittedValue(new String[0]);
        }
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.radioButton");
    }

    protected boolean isSelected(FacesContext context, UIComponent component) {
        return ((RadioButton)component).isChecked();
    }
}

